/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.provenance;

import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.registry.api.workflow.WorkflowExecution;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionStatus;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNode;
import org.apache.airavata.registry.api.workflow.WorkflowNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowNodeStatusUpdater {
    private static Logger logger = LoggerFactory.getLogger(WorkflowNodeStatusUpdater.class);
    private AiravataAPI airavataAPI;

    public WorkflowNodeStatusUpdater(AiravataAPI airavataAPI) {
        this.airavataAPI = airavataAPI;
    }

    public boolean workflowNodeStarted(String workflowInstanceID, String nodeID, String inputs, String workflowID) {
        try {
            WorkflowNodeType workflowNodeType = new WorkflowNodeType();
            workflowNodeType.setNodeType(WorkflowNodeType.WorkflowNode.SERVICENODE);
            WorkflowInstanceNode node = new WorkflowInstanceNode(new WorkflowExecution(workflowInstanceID, workflowInstanceID), nodeID);
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeInput(node, inputs);
            this.airavataAPI.getProvenanceManager().setWorkflowNodeType(node, workflowNodeType);
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeStatus(workflowInstanceID, workflowInstanceID, nodeID, WorkflowExecutionStatus.State.STARTED);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowNodeFailed(String workflowInstanceID, String nodeID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeStatus(workflowInstanceID, workflowInstanceID, nodeID, WorkflowExecutionStatus.State.FAILED);
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceStatus(workflowInstanceID, workflowInstanceID, WorkflowExecutionStatus.State.FAILED);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowNodeFinished(String workflowInstanceID, String nodeID, String inputs, String workflowID) {
        try {
            WorkflowNodeType workflowNodeType = new WorkflowNodeType();
            workflowNodeType.setNodeType(WorkflowNodeType.WorkflowNode.SERVICENODE);
            WorkflowInstanceNode node = new WorkflowInstanceNode(new WorkflowExecution(workflowInstanceID, workflowInstanceID), nodeID);
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeOutput(node, inputs);
            this.airavataAPI.getProvenanceManager().setWorkflowNodeType(node, workflowNodeType);
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeStatus(workflowInstanceID, workflowInstanceID, nodeID, WorkflowExecutionStatus.State.FINISHED);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowNodeRunning(String workflowInstanceID, String nodeID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeStatus(workflowInstanceID, workflowInstanceID, nodeID, WorkflowExecutionStatus.State.RUNNING);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowNodePaused(String workflowInstanceID, String nodeID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeStatus(workflowInstanceID, workflowInstanceID, nodeID, WorkflowExecutionStatus.State.PAUSED);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowNodeStatusPending(String workflowInstanceID, String nodeID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeStatus(workflowInstanceID, workflowInstanceID, nodeID, WorkflowExecutionStatus.State.PENDING);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowNodeStatusActive(String workflowInstanceID, String nodeID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeStatus(workflowInstanceID, workflowInstanceID, nodeID, WorkflowExecutionStatus.State.ACTIVE);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }

    public boolean workflowNodeStatusDone(String workflowInstanceID, String nodeID) {
        try {
            this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeStatus(workflowInstanceID, workflowInstanceID, nodeID, WorkflowExecutionStatus.State.DONE);
        }
        catch (AiravataAPIInvocationException e) {
            logger.error("Error updating Wokflow Node status !!");
            return false;
        }
        return true;
    }
}

