/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.provenance;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.registry.api.workflow.WorkflowExecution;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNode;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.ForEachExecutableNode;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.system.EndForEachNode;
import org.apache.airavata.workflow.model.graph.system.ForEachNode;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.xbaya.concurrent.PredicatedExecutable;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.util.XBayaUtil;
import org.xmlpull.v1.builder.XmlElement;
import xsul5.XmlConstants;

public final class ProvenanceWrite
implements PredicatedExecutable {
    private static final String PROVENANCE_DIR = "provenance";
    private Node node;
    private String workflowName;
    private Map<Node, Invoker> invokerMap;
    private String experimentId;
    private AiravataAPI airavataAPI;

    public ProvenanceWrite(Node node, String workflowName, Map<Node, Invoker> invokerMap, String experimentId, AiravataAPI airavataAPI) {
        this.node = node;
        this.workflowName = workflowName;
        this.invokerMap = invokerMap;
        this.experimentId = experimentId;
        this.airavataAPI = airavataAPI;
    }

    @Override
    public void run() {
        try {
            this.saveNodeOutputs(this.node, this.invokerMap, this.workflowName);
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isReady() {
        return NodeController.isFinished(this.node) && this.invokerMap.get(this.node) != null;
    }

    private void saveNodeOutputs(Node node, Map<Node, Invoker> invokerMap, String workflowName) throws WorkflowException {
        if (null != node && !(node instanceof InputNode)) {
            org.xmlpull.infoset.XmlElement elem = XmlConstants.BUILDER.newFragment("previousdat");
            org.xmlpull.infoset.XmlElement inputs = null;
            if (node instanceof WSNode) {
                String nodeID = node.getComponent().getName();
                org.xmlpull.infoset.XmlElement nodeElement = elem.newElement("wsnode");
                elem.addChild((Object)nodeElement);
                nodeElement.addChild((Object)nodeID);
                inputs = elem.newElement("inputs");
                elem.addChild((Object)inputs);
                List portsToBeSaved = node.getInputPorts();
                for (DataPort savePort : portsToBeSaved) {
                    String portID = savePort.getName();
                    org.xmlpull.infoset.XmlElement portElem = inputs.newElement(portID);
                    inputs.addChild((Object)portElem);
                    Object portInput = XBayaUtil.findInputFromPort(savePort, invokerMap);
                    if (portInput instanceof XmlElement) {
                        portInput = XMLUtil.xmlElement3ToXmlElement5((XmlElement)((XmlElement)portInput));
                    }
                    portElem.addChild(portInput);
                }
            } else if (node instanceof EndForEachNode) {
                Node middleNode = node.getInputPort(0).getFromNode();
                String nodeID = middleNode.getComponent().getName();
                org.xmlpull.infoset.XmlElement nodeElement = elem.newElement("foreach");
                elem.addChild((Object)nodeElement);
                nodeElement.addChild((Object)nodeID);
                inputs = elem.newElement("inputs");
                elem.addChild((Object)inputs);
                XmlConstants.BUILDER.serializeToString((Object)elem);
                if (middleNode instanceof ForEachExecutableNode) {
                    List portsToBeSaved = middleNode.getInputPorts();
                    for (DataPort savePort : portsToBeSaved) {
                        if (savePort.getFromNode() instanceof ForEachNode) {
                            Object value = XBayaUtil.getInputsForForEachNode((ForEachNode)savePort.getFromNode(), new LinkedList<String>(), invokerMap);
                            if (value instanceof XmlElement) {
                                value = XMLUtil.xmlElement3ToXmlElement5((XmlElement)((XmlElement)value));
                            }
                            org.xmlpull.infoset.XmlElement portElement = inputs.newElement(savePort.getName());
                            inputs.addChild((Object)portElement);
                            portElement.addChild(value);
                            continue;
                        }
                        String portID = savePort.getName();
                        org.xmlpull.infoset.XmlElement portElem = inputs.newElement(portID);
                        inputs.addChild((Object)portElem);
                        Object portInput = XBayaUtil.findInputFromPort(savePort, invokerMap);
                        if (portInput instanceof XmlElement) {
                            portInput = XMLUtil.xmlElement3ToXmlElement5((XmlElement)((XmlElement)portInput));
                        }
                        portElem.addChild(portInput);
                    }
                }
            }
            if (inputs != null) {
                try {
                    this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeInput(new WorkflowInstanceNode(new WorkflowExecution(this.experimentId, this.experimentId), node.getID()), XmlConstants.BUILDER.serializeToString((Object)inputs));
                }
                catch (AiravataAPIInvocationException e) {
                    throw new WorkflowException((Throwable)e);
                }
            }
            org.xmlpull.infoset.XmlElement outputs = elem.newElement("outputs");
            elem.addChild((Object)outputs);
            List outputPorts = node.getOutputPorts();
            for (DataPort outputPort : outputPorts) {
                String outputName = outputPort.getName();
                org.xmlpull.infoset.XmlElement outputParamElement = outputs.newElement(outputName);
                outputs.addChild((Object)outputParamElement);
                Object ouputParamValue = invokerMap.get(node).getOutput(outputName);
                if (ouputParamValue instanceof XmlElement) {
                    ouputParamValue = XMLUtil.xmlElement3ToXmlElement5((XmlElement)((XmlElement)ouputParamValue));
                }
                if (ouputParamValue != null) {
                    outputParamElement.addChild(ouputParamValue);
                    continue;
                }
                outputParamElement.addChild((Object)"null");
            }
            try {
                this.airavataAPI.getProvenanceManager().setWorkflowInstanceNodeOutput(new WorkflowInstanceNode(new WorkflowExecution(this.experimentId, this.experimentId), node.getID()), XmlConstants.BUILDER.serializeToString((Object)outputs));
            }
            catch (AiravataAPIInvocationException e) {
                throw new WorkflowException((Throwable)e);
            }
        }
    }
}

