/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.provenance;

import java.util.List;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.registry.api.impl.WorkflowExecutionDataImpl;
import org.apache.airavata.registry.api.workflow.ExperimentData;
import org.apache.airavata.registry.api.workflow.NodeExecutionData;
import org.apache.airavata.registry.api.workflow.OutputData;
import org.apache.airavata.workflow.model.graph.Node;

public class ProvenanceReader {
    public String DEFAULT_LIBRARY_FOLDER_NAME = "provenance";
    private String experimentId;
    private AiravataAPI airavataAPI;
    private Node node;

    public ProvenanceReader(Node node, String experimentId, AiravataAPI airavataAPI) {
        this.experimentId = experimentId;
        this.airavataAPI = airavataAPI;
        this.node = node;
    }

    public Object read() throws Exception {
        try {
            ExperimentData workflowExecution = this.airavataAPI.getProvenanceManager().getExperimentData(this.experimentId);
            List nodeDataList = ((WorkflowExecutionDataImpl)workflowExecution.getWorkflowExecutionDataList().get(0)).getNodeDataList();
            if (nodeDataList.size() == 0) {
                return null;
            }
            for (NodeExecutionData data : nodeDataList) {
                if (!this.node.getID().equals(data.getWorkflowInstanceNode().getNodeId())) continue;
                return ((OutputData)data.getOutputData().get(0)).getValue();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

