/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.modifier;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.airavata.common.exception.UtilsException;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.workflow.model.component.system.InputComponent;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.impl.PortImpl;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.util.GraphUtil;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.workflow.model.graph.ws.WSPort;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.EventData;
import org.apache.airavata.ws.monitor.EventDataRepository;
import org.apache.airavata.ws.monitor.MonitorException;
import org.apache.airavata.ws.monitor.MonitorUtil;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.monitor.MonitorEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;
import xsul5.wsdl.WsdlDefinitions;
import xsul5.wsdl.WsdlPortTypeOperation;

public class WorkflowModifier {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowModifier.class);
    private Workflow modifiedWorkflow;
    private EventDataRepository eventData;

    public WorkflowModifier(Workflow modifiedWorkflow, EventDataRepository eventData) {
        this.modifiedWorkflow = modifiedWorkflow;
        this.eventData = eventData;
    }

    public Workflow createDifference() throws GraphException, MonitorException {
        WSGraph originalGraph = this.modifiedWorkflow.getGraph();
        Workflow workflow = this.modifiedWorkflow.clone();
        String name = workflow.getName();
        name = name + " (diff)";
        workflow.setName(name);
        WSGraph graph = workflow.getGraph();
        this.removeFinishedNodes(originalGraph, graph);
        Set<WSPort> originalFromPorts = this.getFinalOutputPorts(originalGraph, graph);
        this.createInputNodes(graph, originalFromPorts);
        for (WSPort originalFromPort : originalFromPorts) {
            String output;
            NodeImpl originalFromNode = originalFromPort.getNode();
            String fromNodeID = originalFromNode.getID();
            if (originalFromNode instanceof InputNode) {
                output = this.getWorkflowInput(fromNodeID);
            } else if (originalFromNode instanceof WSNode) {
                WSComponent component = ((WSNode)originalFromNode).getComponent();
                String messageName = component.getOutputTypeName();
                String parameterName = originalFromPort.getComponentPort().getName();
                output = this.getOutput(fromNodeID, messageName, parameterName);
            } else {
                throw new WorkflowRuntimeException(originalFromNode.getClass().getName());
            }
            Port originalToPort = (Port)originalFromPort.getToPorts().get(0);
            PortImpl toPort = graph.getPort(originalToPort.getID());
            InputNode inputNode = (InputNode)toPort.getFromNode();
            inputNode.setDefaultValue((Object)output);
        }
        return workflow;
    }

    private void removeFinishedNodes(WSGraph originalGraph, WSGraph graph) throws GraphException {
        ArrayList<Node> finishedNodes = new ArrayList<Node>();
        for (Node node : originalGraph.getNodes()) {
            Color color = NodeController.getGUI(node).getBodyColor();
            if (!MonitorEventHandler.NodeState.FINISHED.color.equals(color)) continue;
            finishedNodes.add(node);
        }
        for (Node finishedNode : finishedNodes) {
            NodeImpl node = graph.getNode(finishedNode.getID());
            graph.removeNode((Node)node);
        }
    }

    private Set<WSPort> getFinalOutputPorts(WSGraph originalGraph, WSGraph graph) {
        Collection inputPorts = GraphUtil.getPorts((Graph)graph, (Port.Kind)Port.Kind.DATA_IN);
        HashSet<WSPort> originalFromPorts = new HashSet<WSPort>();
        for (Port inputPort : inputPorts) {
            Port fromPort = inputPort.getFromPort();
            if (fromPort != null) continue;
            String inputPortID = inputPort.getID();
            logger.debug("id: " + inputPortID);
            PortImpl originalInputPort = originalGraph.getPort(inputPortID);
            Port originalFromPort = originalInputPort.getFromPort();
            originalFromPorts.add((WSPort)originalFromPort);
        }
        return originalFromPorts;
    }

    private void createInputNodes(WSGraph graph, Set<WSPort> originalFromPorts) throws GraphException {
        InputComponent inputComponent = new InputComponent();
        for (WSPort originalFromPort : originalFromPorts) {
            InputNode inputNode = inputComponent.createNode((Graph)graph);
            List originalToPorts = originalFromPort.getToPorts();
            boolean first = true;
            for (Port originalToPort : originalToPorts) {
                String toPortID = originalToPort.getID();
                PortImpl toPort = graph.getPort(toPortID);
                graph.addEdge((Port)inputNode.getPort(), (Port)toPort);
                if (!first) continue;
                first = false;
                Point position = NodeController.getGUI(originalToPort).getPosition();
                Point inputNodePosition = new Point(0, position.y);
                inputNode.setPosition(inputNodePosition);
            }
        }
    }

    private String getWorkflowInput(String nodeID) throws MonitorException {
        logger.debug("Node:" + nodeID);
        List events = this.eventData.getEvents();
        for (EventData event : events) {
            WsdlPortTypeOperation wsdlPortTypeOperation;
            String id;
            MonitorUtil.EventType type = event.getType();
            if (type != MonitorUtil.EventType.INVOKING_SERVICE || !"".equals(id = event.getNodeID())) continue;
            XmlElement eventElement = event.getEvent();
            XmlElement result = eventElement.element("request");
            XmlElement body = result.element("body");
            XmlElement soapBody = body.element("Body");
            try {
                wsdlPortTypeOperation = WSDLUtil.getFirstOperation((WsdlDefinitions)this.modifiedWorkflow.getWorkflowWSDL());
            }
            catch (UtilsException e) {
                throw new MonitorException((Throwable)e);
            }
            XmlElement part = soapBody.element(wsdlPortTypeOperation.getName());
            XmlElement parameter = part.element(nodeID);
            String value = parameter.requiredText();
            return value;
        }
        String message = "Couldn't find a notification of about the input with nodeID, " + nodeID;
        throw new MonitorException(message);
    }

    private String getOutput(String nodeID, String messageName, String parameterName) throws MonitorException {
        List events = this.eventData.getEvents();
        for (EventData event : events) {
            String id;
            MonitorUtil.EventType type = event.getType();
            if (type != MonitorUtil.EventType.SENDING_RESULT && type != MonitorUtil.EventType.RECEIVED_RESULT || !nodeID.equals(id = event.getNodeID())) continue;
            XmlElement eventElement = event.getEvent();
            XmlElement result = eventElement.element("result");
            XmlElement body = result.element("body");
            XmlElement soapBody = body.element("Body");
            XmlElement part = soapBody.element(messageName);
            XmlElement parameter = part.element(parameterName);
            String value = parameter.requiredText();
            return value;
        }
        String message = "Couldn't find a notification of the output from the service with nodeID, " + nodeID;
        throw new MonitorException(message);
    }
}

