/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.model.registrybrowser;

import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.registry.api.workflow.InputData;
import org.apache.airavata.registry.api.workflow.NodeExecutionData;
import org.apache.airavata.registry.api.workflow.OutputData;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNodePortData;
import org.apache.airavata.schemas.gfac.Parameter;
import org.apache.airavata.xbaya.model.registrybrowser.InputParameters;
import org.apache.airavata.xbaya.model.registrybrowser.NodeParameter;
import org.apache.airavata.xbaya.model.registrybrowser.OutputParameters;

public class XBayaWorkflowNodeElement {
    private InputParameters inputParameters;
    private OutputParameters outputParameters;
    private NodeExecutionData nodeData;
    private String nodeId;

    public XBayaWorkflowNodeElement(String nodeId, NodeExecutionData nodeData) {
        this.setNodeId(nodeId);
        this.setNodeData(nodeData);
    }

    public OutputParameters getOutputParameters() {
        if (this.outputParameters == null) {
            this.outputParameters = new OutputParameters((NodeParameter[])null);
            this.outputParameters.getParameters().addAll(this.generateParameterListForOutput(this.nodeData.getOutputData()));
        }
        return this.outputParameters;
    }

    private List<NodeParameter> generateParameterListForInput(List<InputData> list) {
        ArrayList<NodeParameter> params = new ArrayList<NodeParameter>();
        for (WorkflowInstanceNodePortData workflowInstanceNodePortData : list) {
            Parameter parameter = Parameter.Factory.newInstance();
            parameter.setParameterName(workflowInstanceNodePortData.getName());
            NodeParameter serviceParameter = new NodeParameter(parameter, workflowInstanceNodePortData.getValue());
            params.add(serviceParameter);
        }
        return params;
    }

    private List<NodeParameter> generateParameterListForOutput(List<OutputData> list) {
        ArrayList<NodeParameter> params = new ArrayList<NodeParameter>();
        for (WorkflowInstanceNodePortData workflowInstanceNodePortData : list) {
            Parameter parameter = Parameter.Factory.newInstance();
            parameter.setParameterName(workflowInstanceNodePortData.getName());
            NodeParameter serviceParameter = new NodeParameter(parameter, workflowInstanceNodePortData.getValue());
            params.add(serviceParameter);
        }
        return params;
    }

    public void setOutputParameters(OutputParameters outputParameters) {
        this.outputParameters = outputParameters;
    }

    public InputParameters getInputParameters() {
        if (this.inputParameters == null) {
            this.inputParameters = new InputParameters((NodeParameter[])null);
            this.inputParameters.getParameters().addAll(this.generateParameterListForInput(this.nodeData.getInputData()));
        }
        return this.inputParameters;
    }

    public void setInputParameters(InputParameters inputParameters) {
        this.inputParameters = inputParameters;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public NodeExecutionData getNodeData() {
        return this.nodeData;
    }

    public void setNodeData(NodeExecutionData nodeData) {
        this.nodeData = nodeData;
    }
}

