/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.model.registrybrowser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.xbaya.model.registrybrowser.XBayaWorkflowExperiment;

public class XBayaWorkflowExperiments {
    private AiravataAPI airavataAPI;

    public XBayaWorkflowExperiments(AiravataAPI airavataAPI) {
        this.setAiravataAPI(airavataAPI);
    }

    public List<XBayaWorkflowExperiment> getAllExperiments() {
        HashMap<String, XBayaWorkflowExperiment> experiments = new HashMap<String, XBayaWorkflowExperiment>();
        try {
            this.initializeExperimentMap(experiments);
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
        }
        return Arrays.asList(experiments.values().toArray(new XBayaWorkflowExperiment[0]));
    }

    public void initializeExperimentMap(Map<String, XBayaWorkflowExperiment> experiments) throws AiravataAPIInvocationException {
        List experimentIdByUser = this.getAiravataAPI().getProvenanceManager().getExperimentIdList();
        for (String id : experimentIdByUser) {
            experiments.put(id, new XBayaWorkflowExperiment(id, this.getAiravataAPI()));
        }
    }

    public AiravataAPI getAiravataAPI() {
        return this.airavataAPI;
    }

    public void setAiravataAPI(AiravataAPI airavataAPI) {
        this.airavataAPI = airavataAPI;
    }
}

