/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.model.registrybrowser;

import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.registry.api.workflow.WorkflowExecution;
import org.apache.airavata.xbaya.model.registrybrowser.XBayaWorkflow;

public class XBayaWorkflowExperiment {
    private List<XBayaWorkflow> workflows;
    private String experimentId;
    private AiravataAPI airavataAPI;

    public XBayaWorkflowExperiment(String experimentId, AiravataAPI airavataAPI) {
        this.setExperimentId(experimentId);
        this.setAiravataAPI(airavataAPI);
    }

    public List<XBayaWorkflow> getWorkflows() {
        if (this.workflows == null) {
            this.workflows = new ArrayList<XBayaWorkflow>();
            try {
                List experimentWorkflowInstances = this.getAiravataAPI().getProvenanceManager().getExperimentWorkflowInstances(this.getExperimentId());
                for (WorkflowExecution workflowInstance : experimentWorkflowInstances) {
                    this.workflows.add(new XBayaWorkflow(workflowInstance, this.getAiravataAPI()));
                }
            }
            catch (AiravataAPIInvocationException e) {
                e.printStackTrace();
            }
        }
        return this.workflows;
    }

    public void setWorkflows(List<XBayaWorkflow> workflows) {
        this.workflows = workflows;
    }

    public void add(XBayaWorkflow workflow) {
        this.getWorkflows().add(workflow);
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public AiravataAPI getAiravataAPI() {
        return this.airavataAPI;
    }

    public void setAiravataAPI(AiravataAPI airavataAPI) {
        this.airavataAPI = airavataAPI;
    }
}

