/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.model.registrybrowser;

import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.registry.api.exception.worker.ExperimentLazyLoadedException;
import org.apache.airavata.registry.api.workflow.NodeExecutionData;
import org.apache.airavata.registry.api.workflow.WorkflowExecution;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionData;
import org.apache.airavata.xbaya.model.registrybrowser.XBayaWorkflowNodeElement;

public class XBayaWorkflow {
    private List<XBayaWorkflowNodeElement> workflowServices;
    private WorkflowExecution workflowInstance;
    private AiravataAPI airavataAPI;

    public XBayaWorkflow(WorkflowExecution workflowInstance, AiravataAPI airavataAPI) {
        this.setWorkflowInstance(workflowInstance);
        this.setAiravataAPI(airavataAPI);
    }

    public List<XBayaWorkflowNodeElement> getWorkflowServices() {
        if (this.workflowServices == null) {
            this.workflowServices = new ArrayList<XBayaWorkflowNodeElement>();
            try {
                WorkflowExecutionData workflowInstanceData = this.getAiravataAPI().getProvenanceManager().getWorkflowInstanceData(this.getWorkflowId(), this.getWorkflowId());
                List nodeDataList = workflowInstanceData.getNodeDataList();
                for (NodeExecutionData nodeData : nodeDataList) {
                    this.workflowServices.add(new XBayaWorkflowNodeElement(nodeData.getWorkflowInstanceNode().getNodeId(), nodeData));
                }
            }
            catch (AiravataAPIInvocationException e) {
                e.printStackTrace();
            }
            catch (ExperimentLazyLoadedException e) {
                e.printStackTrace();
            }
        }
        return this.workflowServices;
    }

    public void setWorkflowNodes(List<XBayaWorkflowNodeElement> workflowServices) {
        this.workflowServices = workflowServices;
    }

    public void add(XBayaWorkflowNodeElement workflowService) {
        this.getWorkflowServices().add(workflowService);
    }

    public String getWorkflowName() {
        return this.getWorkflowInstance().getTemplateName();
    }

    public String getWorkflowId() {
        return this.getWorkflowInstance().getWorkflowExecutionId();
    }

    public AiravataAPI getAiravataAPI() {
        return this.airavataAPI;
    }

    public void setAiravataAPI(AiravataAPI airavataAPI) {
        this.airavataAPI = airavataAPI;
    }

    public WorkflowExecution getWorkflowInstance() {
        return this.workflowInstance;
    }

    public void setWorkflowInstance(WorkflowExecution workflowInstance) {
        this.workflowInstance = workflowInstance;
    }
}

