/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.model.registrybrowser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.ApplicationManager;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.registry.api.exception.RegistryException;
import org.apache.airavata.xbaya.model.registrybrowser.ApplicationDeploymentDescriptionWrap;

public class ApplicationDeploymentDescriptions {
    private AiravataAPI airavataAPI;
    private String serviceName;

    public AiravataAPI getAiravataAPI() {
        return this.airavataAPI;
    }

    public void setAiravataAPI(AiravataAPI airavataAPI) {
        this.airavataAPI = airavataAPI;
    }

    public ApplicationDeploymentDescriptions(AiravataAPI airavataAPI, String serviceName) {
        this.setAiravataAPI(airavataAPI);
        this.setServiceName(serviceName);
    }

    public ApplicationDeploymentDescriptions(AiravataAPI airavataAPI) {
        this(airavataAPI, null);
    }

    public List<ApplicationDeploymentDescriptionWrap> getDescriptions() throws RegistryException, AiravataAPIInvocationException {
        ArrayList<ApplicationDeploymentDescriptionWrap> list = new ArrayList<ApplicationDeploymentDescriptionWrap>();
        if (this.getServiceName() == null) {
            ApplicationManager applicationManager = this.getAiravataAPI().getApplicationManager();
            List serviceDescriptors = applicationManager.getAllServiceDescriptions();
            for (ServiceDescription serviceDescription : serviceDescriptors) {
                String serviceName = serviceDescription.getType().getName();
                Map deploymentDescriptions = applicationManager.getApplicationDescriptors(serviceName);
                for (String hostName : deploymentDescriptions.keySet()) {
                    ApplicationDescription descriptionWrap = (ApplicationDescription)deploymentDescriptions.get(hostName);
                    list.add(new ApplicationDeploymentDescriptionWrap(this.getAiravataAPI(), descriptionWrap, serviceName, hostName));
                }
            }
        } else {
            Map deploymentDescriptions = this.getAiravataAPI().getApplicationManager().getApplicationDescriptors(this.serviceName);
            for (String hostName : deploymentDescriptions.keySet()) {
                ApplicationDescription descriptionWrap = (ApplicationDescription)deploymentDescriptions.get(hostName);
                list.add(new ApplicationDeploymentDescriptionWrap(this.getAiravataAPI(), descriptionWrap, this.getServiceName(), hostName));
            }
        }
        return list;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

