/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.model.registrybrowser;

import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;

public class ApplicationDeploymentDescriptionWrap {
    private ApplicationDescription applicationDescription;
    private String service;
    private String host;
    private AiravataAPI airavataAPI;

    public ApplicationDeploymentDescriptionWrap(AiravataAPI airavataAPI, ApplicationDescription applicationDescription, String service, String host) {
        this.setApplicationDescription(applicationDescription);
        this.setService(service);
        this.setHost(host);
        this.setAiravataAPI(airavataAPI);
    }

    public ApplicationDescription getDescription() {
        return this.applicationDescription;
    }

    public void setApplicationDescription(ApplicationDescription applicationDescription) {
        this.applicationDescription = applicationDescription;
    }

    public String getService() {
        return this.service;
    }

    public ServiceDescription getServiceDescription() throws AiravataAPIInvocationException {
        ServiceDescription desc = this.getAiravataAPI().getApplicationManager().getServiceDescription(this.getService());
        if (desc != null) {
            return desc;
        }
        throw new AiravataAPIInvocationException((Throwable)new Exception("Service Description not found in registry."));
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getHost() {
        return this.host;
    }

    public HostDescription getHostDescription() throws AiravataAPIInvocationException {
        return this.getAiravataAPI().getApplicationManager().getHostDescription(this.getHost());
    }

    public void setHost(String host) {
        this.host = host;
    }

    public AiravataAPI getAiravataAPI() {
        return this.airavataAPI;
    }

    public void setAiravataAPI(AiravataAPI airavataAPI) {
        this.airavataAPI = airavataAPI;
    }
}

