/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.menues.tools;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.GlobusFileTransferWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolsMenuItem {
    private XBayaEngine engine;
    private JMenu toolsMenu;
    private JMenuItem globusFileTransferItem;
    private static final Logger logger = LoggerFactory.getLogger(ToolsMenuItem.class);

    public ToolsMenuItem(XBayaEngine engine) {
        this.engine = engine;
        this.createWorkflowMenu();
    }

    public JMenu getMenu() {
        return this.toolsMenu;
    }

    private void createWorkflowMenu() {
        this.globusFileTransferItem = this.createGlobusFileTransferItem();
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(84);
        this.toolsMenu.add(this.globusFileTransferItem);
    }

    private JMenuItem createGlobusFileTransferItem() {
        JMenuItem item = new JMenuItem("Globus File Transfer...");
        item.setMnemonic(74);
        item.addActionListener(new AbstractAction(){
            private GlobusFileTransferWindow window;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.window == null) {
                    this.window = new GlobusFileTransferWindow(ToolsMenuItem.this.engine);
                }
                this.window.show();
            }
        });
        return item;
    }
}

