/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.lead;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.common.workflow.execution.context.WorkflowContextHeaderBuilder;
import org.apache.airavata.workflow.tracking.NotifierFactory;
import org.apache.airavata.workflow.tracking.WorkflowNotifier;
import org.apache.airavata.workflow.tracking.common.InvocationContext;
import org.apache.airavata.workflow.tracking.common.InvocationEntity;
import org.apache.airavata.workflow.tracking.common.WorkflowTrackingContext;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.invoker.DynamicInfosetInvokerException;
import xsul.lead.LeadContextHeader;
import xsul.message_router.MessageContext;
import xsul.xbeans_util.XBeansUtil;
import xsul.xhandler.BaseHandler;

public class NotificationHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(NotificationHandler.class);
    private static final String INVOKING_MESSAGE = "Invoking a workflow";
    private static final String RECEIVE_RESULT_MESSAGE = "A workflow finished successfully.";
    private static final String RECEIVE_FAULT_MESSAGE = "A workflow failed.";
    private LeadContextHeader leadContext;
    private WorkflowNotifier notifier;
    private WorkflowTrackingContext context;
    private InvocationContext invocationContext;
    private InvocationEntity invocationEntity;
    private WorkflowContextHeaderBuilder builder;

    public NotificationHandler(LeadContextHeader leadContext) {
        super(NotificationHandler.class.getName());
        this.leadContext = leadContext;
        this.notifier = NotifierFactory.createNotifier();
        URI myWorkflowID = null;
        URI myServiceID = URI.create("XBaya");
        String userDN = this.leadContext.getUserDn();
        if (userDN != null && userDN.trim().length() == 0) {
            String serviceIDAsString = "XBaya:" + userDN.trim();
            try {
                myServiceID = new URI(null, null, serviceIDAsString, null);
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        String myNodeID = null;
        Integer myTimestep = null;
        EndpointReference epr = new EndpointReference(leadContext.getEventSink().getAddress().toString());
        this.invocationEntity = this.notifier.createEntity(myWorkflowID, myServiceID, myNodeID, myTimestep);
        this.context = this.notifier.createTrackingContext(new Properties(), epr.getAddress().toString(), myWorkflowID, myServiceID, myNodeID, myTimestep);
    }

    public NotificationHandler(WorkflowContextHeaderBuilder builder) {
        super(NotificationHandler.class.getName());
        this.builder = builder;
        this.notifier = NotifierFactory.createNotifier();
        URI myWorkflowID = null;
        URI myServiceID = URI.create("XBaya");
        String userDN = this.builder.getUserIdentifier();
        if (userDN != null && userDN.trim().length() == 0) {
            String serviceIDAsString = "XBaya:" + userDN.trim();
            try {
                myServiceID = new URI(null, null, serviceIDAsString, null);
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        String myNodeID = null;
        Integer myTimestep = null;
        EndpointReference epr = new EndpointReference(builder.getWorkflowMonitoringContext().getEventPublishEpr());
        this.invocationEntity = this.notifier.createEntity(myWorkflowID, myServiceID, myNodeID, myTimestep);
        this.context = this.notifier.createTrackingContext(new Properties(), epr.getAddress().toString(), myWorkflowID, myServiceID, myNodeID, myTimestep);
    }

    public boolean processOutgoingXml(XmlElement soapEnvelope, MessageContext context) throws DynamicInfosetInvokerException {
        logger.debug("soapEnvelope: " + XMLUtil.xmlElementToString((XmlElement)soapEnvelope));
        Object serviceWorkflowID = null;
        URI serviceServiceID = URI.create(this.builder.getWorkflowMonitoringContext().getServiceInstanceId());
        if (serviceServiceID == null) {
            serviceServiceID = URI.create("NoWorkflowIDSet");
        }
        XmlElement soapHeader = soapEnvelope.element(null, "Header");
        XmlElement soapBody = soapEnvelope.element(null, "Body");
        XmlObject headerObject = null;
        if (soapHeader != null) {
            headerObject = XBeansUtil.xmlElementToXmlObject((XmlElement)soapHeader);
        }
        XmlObject bodyObject = XBeansUtil.xmlElementToXmlObject((XmlElement)soapBody);
        this.invocationContext = this.notifier.invokingService(this.context, this.invocationEntity, headerObject, bodyObject, new String[]{INVOKING_MESSAGE});
        return super.processOutgoingXml(soapEnvelope, context);
    }

    public boolean processIncomingXml(XmlElement soapEnvelope, MessageContext context) throws DynamicInfosetInvokerException {
        logger.info("soapEnvelope: " + XMLUtil.xmlElementToString((XmlElement)soapEnvelope));
        XmlElement soapHeader = soapEnvelope.element(null, "Header");
        XmlObject headerObject = null;
        if (soapHeader != null) {
            headerObject = XBeansUtil.xmlElementToXmlObject((XmlElement)soapHeader);
        }
        XmlElement soapBody = soapEnvelope.element(null, "Body");
        XmlObject bodyObject = XBeansUtil.xmlElementToXmlObject((XmlElement)soapBody);
        XmlElement faultElement = soapBody.element(null, "Fault");
        if (faultElement == null) {
            this.notifier.receivedResult(this.context, this.invocationContext, headerObject, bodyObject, new String[]{RECEIVE_RESULT_MESSAGE});
        } else {
            this.notifier.receivedFault(this.context, this.invocationContext, headerObject, bodyObject, new String[]{RECEIVE_FAULT_MESSAGE});
        }
        return super.processIncomingXml(soapEnvelope, context);
    }
}

