/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.lead;

import java.net.URI;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.MonitorConfiguration;
import org.apache.airavata.wsmg.client.WseMsgBrokerClient;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.axis2.addressing.EndpointReference;
import xsul.lead.LeadContextHeader;
import xsul.ws_addressing.WsaEndpointReference;

public class LeadContextHeaderHelper {
    private static final String DEFAULT_USER = "xbaya-user";
    private static final String DEFAULT_EXPERIMENT = "xbaya-experiment";
    private LeadContextHeader leadContextHeader = new LeadContextHeader("xbaya-experiment", "xbaya-user");

    public LeadContextHeader getLeadContextHeader() {
        return this.leadContextHeader;
    }

    public void setUser(String user) {
        if (user == null || user.length() == 0) {
            user = DEFAULT_USER;
        }
        this.leadContextHeader.setUserDn(user);
    }

    public void setWorkflowTemplateID(URI workflowTemplateID) {
        if (workflowTemplateID != null) {
            this.leadContextHeader.setWorkflowTemplateId(workflowTemplateID);
        }
    }

    public void setWorkflowInstanceID(URI workflowInstanceID) {
        if (workflowInstanceID != null) {
            this.leadContextHeader.setWorkflowInstanceId(workflowInstanceID);
        }
    }

    public void setEventSink(URI brokerURL, String topic) {
        if (brokerURL != null) {
            if (topic == null || topic.length() == 0) {
                topic = "xbaya-topic";
            }
            EndpointReference eventSink = WseMsgBrokerClient.createEndpointReference((String)brokerURL.toString(), (String)topic);
            WsaEndpointReference eprReference = new WsaEndpointReference(URI.create(eventSink.getAddress()));
            this.leadContextHeader.setEventSink(eprReference);
        }
    }

    public void setGFacURL(URI gFacURL) {
        if (gFacURL != null) {
            this.leadContextHeader.setGfacUrl(WSDLUtil.appendWSDLQuary((URI)gFacURL));
        }
    }

    public void setWorkflow(Workflow workflow) {
        if (workflow != null) {
            this.setWorkflowTemplateID(workflow.getGPELTemplateID());
            this.setWorkflowInstanceID(workflow.getGPELInstanceID());
        }
    }

    public void setMonitorConfiguration(MonitorConfiguration monitorConfiguration) {
        this.setEventSink(monitorConfiguration.getBrokerURL(), monitorConfiguration.getTopic());
    }

    public void setXBayaConfiguration(XBayaConfiguration xbayaConfiguration) {
        this.setGFacURL(xbayaConfiguration.getGFacURL());
        this.setWorkflowTemplateID(xbayaConfiguration.getGPELTemplateID());
        this.setWorkflowInstanceID(xbayaConfiguration.getGPELInstanceID());
        this.setEventSink(xbayaConfiguration.getBrokerURL(), xbayaConfiguration.getTopic());
    }
}

