/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.lead;

import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.component.ws.WSComponentFactory;
import org.apache.airavata.workflow.model.component.ws.WSComponentPort;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.lead.LEADTypes;
import org.apache.airavata.xbaya.lead.NotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.XmlConstants;
import xsul.invoker.puretls.PuretlsInvoker;
import xsul.invoker.soap_over_http.SoapHttpDynamicInfosetInvoker;
import xsul.lead.LeadContextHeader;
import xsul.wsif.WSIFMessage;
import xsul.wsif.WSIFOperation;
import xsul.wsif.WSIFPort;
import xsul.wsif.WSIFService;
import xsul.wsif.WSIFServiceFactory;
import xsul.wsif.impl.WSIFMessageElement;
import xsul.wsif.spi.WSIFProvider;
import xsul.wsif.spi.WSIFProviderManager;
import xsul.wsif_xsul_soap_gsi.Provider;
import xsul.xhandler.XHandler;
import xsul.xhandler_soap_sticky_header.StickySoapHeaderHandler;
import xsul.xwsif_runtime.WSIFClient;
import xsul.xwsif_runtime.WSIFRuntime;
import xsul.xwsif_runtime_async.WSIFAsyncResponsesCorrelator;
import xsul.xwsif_runtime_async_http.XsulSoapHttpWsaResponsesCorrelator;
import xsul.xwsif_runtime_async_msgbox.XsulMsgBoxWsaResponsesCorrelator;
import xsul5.wsdl.WsdlDefinitions;

public class LEADWorkflowInvoker {
    private static final Logger logger = LoggerFactory.getLogger(LEADWorkflowInvoker.class);
    private WsdlDefinitions definitions;
    private WSIFClient client;
    private WSIFOperation operation;
    private boolean success;
    private WSIFMessage inputMessage;
    private WSIFMessage outputMessage;
    private WSIFMessage faultMessage;
    private WSComponent component;
    private LeadContextHeader leadContext;
    private URI messageBoxURL;
    private PuretlsInvoker secureInvoker;
    private String operationName;

    public LEADWorkflowInvoker(WsdlDefinitions definitions, LeadContextHeader leadContext) throws ComponentException {
        this(definitions, leadContext, null, null);
    }

    public LEADWorkflowInvoker(WsdlDefinitions definitions, LeadContextHeader leadContext, URI messageBoxURL) throws ComponentException {
        this(definitions, leadContext, messageBoxURL, null);
    }

    public LEADWorkflowInvoker(WsdlDefinitions definitions, LeadContextHeader leadContext, URI messageBoxURL, PuretlsInvoker secureInvoker) throws ComponentException {
        this(definitions, leadContext, messageBoxURL, secureInvoker, null);
    }

    public LEADWorkflowInvoker(WsdlDefinitions definitions, LeadContextHeader leadContext, URI messageBoxURL, PuretlsInvoker secureInvoker, String operationName) throws ComponentException {
        this.definitions = definitions;
        this.leadContext = leadContext;
        this.messageBoxURL = messageBoxURL;
        this.secureInvoker = secureInvoker;
        this.operationName = operationName;
        this.init();
    }

    public LeadContextHeader getLeadContext() {
        return this.leadContext;
    }

    public List<WSComponentPort> getInputs() {
        return this.component.getInputPorts();
    }

    public void setInputs(List<WSComponentPort> inputs) {
        for (WSComponentPort input : inputs) {
            QName type;
            String name = input.getName();
            Object value = input.getValue();
            if (this.inputMessage instanceof WSIFMessageElement && LEADTypes.isArrayType(type = ((WSIFMessageElement)this.inputMessage).getPartType(name))) {
                Pattern pattern = Pattern.compile("[,\\s]+");
                String[] result = pattern.split((String)value);
                XmlElement arrayEl = XmlConstants.BUILDER.newFragment(name);
                for (int i = 0; i < result.length; ++i) {
                    logger.debug("split=" + result[i]);
                    arrayEl.addElement("value").addChild((Object)result[i]);
                }
                this.inputMessage.setObjectPart(name, (Object)arrayEl);
                value = null;
            }
            if (value == null) continue;
            this.inputMessage.setObjectPart(name, value);
        }
    }

    public boolean invoke() throws WorkflowException {
        try {
            logger.debug("leadContext: " + XMLUtil.xmlElementToString((XmlElement)this.leadContext));
            logger.debug("inputMessage: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)this.inputMessage)));
            this.success = this.operation.executeRequestResponseOperation(this.inputMessage, this.outputMessage, this.faultMessage);
            if (this.success) {
                logger.debug("outputMessage: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)this.outputMessage)));
            } else {
                logger.debug("faultMessage: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)this.faultMessage)));
            }
            return this.success;
        }
        catch (RuntimeException e) {
            String message = "Error in invoking a service.";
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    public List<WSComponentPort> getOutputs() {
        List outputs = this.component.getOutputPorts();
        for (WSComponentPort output : outputs) {
            String name = output.getName();
            String value = this.outputMessage.getObjectPart(name).toString();
            output.setValue((Object)value);
        }
        return outputs;
    }

    public WSIFMessage getFault() {
        return this.getFaultMessage();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public WSIFMessage getInputMessage() {
        return this.inputMessage;
    }

    public WSIFMessage getOutputMessage() {
        return this.outputMessage;
    }

    public WSIFMessage getFaultMessage() {
        return this.faultMessage;
    }

    private void init() throws ComponentException {
        XsulMsgBoxWsaResponsesCorrelator correlator;
        logger.debug("wsdl: " + this.definitions.xmlStringPretty());
        this.component = WSComponentFactory.createComponent((WsdlDefinitions)this.definitions);
        WSIFServiceFactory factory = WSIFServiceFactory.newInstance();
        WSIFService service = factory.getService(WSDLUtil.wsdlDefinitions5ToWsdlDefintions3((WsdlDefinitions)this.definitions));
        if (this.secureInvoker != null) {
            Provider secureProvider = new Provider((SoapHttpDynamicInfosetInvoker)this.secureInvoker);
            service.addLocalProvider((WSIFProvider)secureProvider);
        }
        this.client = WSIFRuntime.getDefault().newClientFor(service, null);
        int clientPort = 0;
        if (this.messageBoxURL == null) {
            logger.debug("starting response correlator using local port " + clientPort);
            XsulSoapHttpWsaResponsesCorrelator wasCorrelator = new XsulSoapHttpWsaResponsesCorrelator(clientPort);
            String serverLoc = wasCorrelator.getServerLocation();
            logger.debug("client is waiting at " + serverLoc);
            correlator = wasCorrelator;
        } else {
            logger.debug("starting reponse correlator using message box " + this.messageBoxURL);
            correlator = new XsulMsgBoxWsaResponsesCorrelator(this.messageBoxURL.toString());
        }
        this.client.useAsyncMessaging((WSIFAsyncResponsesCorrelator)correlator);
        StickySoapHeaderHandler handler = new StickySoapHeaderHandler("use-lead-header", (XmlElement)this.leadContext);
        this.client.addHandler((XHandler)handler);
        NotificationHandler notificationHandler = new NotificationHandler(this.leadContext);
        this.client.addHandler((XHandler)notificationHandler);
        WSIFPort port = this.client.getPort();
        if (this.operationName == null) {
            this.operationName = this.component.getOperationName();
        }
        logger.debug("operationName: " + this.operationName);
        this.operation = port.createOperation(this.operationName);
        this.inputMessage = this.operation.createInputMessage();
        this.outputMessage = this.operation.createOutputMessage();
        this.faultMessage = this.operation.createFaultMessage();
    }

    static {
        WSIFProviderManager.getInstance().addProvider((WSIFProvider)new xsul.wsif_xsul_soap_http.Provider());
    }
}

