/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.lead;

import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.WSConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LEADTypes {
    private static final Logger logger = LoggerFactory.getLogger(LEADTypes.class);
    public static final String LEAD_XSD_NS_URI = "http://airavata.apache.org/schemas/gfac/2012/12";
    public static final QName LEAD_FILE_ID_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "LEADFileIDType");
    public static final QName DATA_ID_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "DataIDType");
    public static final QName LEAD_WORKFLOW_ID_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "LEADWorkflowIDType");
    public static final QName LEAD_NAME_LIST_FILE_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "LEADNameListFileType");
    public static final QName LEAD_NAME_LIST_PROPERTIES_FILE_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "LEADNameListPropertiesFileType");
    public static final QName HOST_NAME_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "HostNameType");
    public static final QName STRING_ARRAY_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "StringArrayType");
    public static final QName INTEGER_ARRAY_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "IntegerArrayType");
    public static final QName FLOAT_ARRAY_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "FloatArrayType");
    public static final QName DOUBLE_ARRAY_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "DoubleArrayType");
    public static final QName BOOLEAN_ARRAY_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "BooleanArrayType");
    public static final QName QNAME_ARRAY_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "QNameArrayType");
    public static final QName URI_ARRAY_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "URIArrayType");
    public static final QName LEAD_FILE_ID_ARRAY_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "LEADFileIDArrayType");
    public static final QName DATA_ID_ARRAY_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "DataIDArrayType");
    public static final QName STRING_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "StringParameterType");
    public static final QName INTEGER_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "IntegerParameterType");
    public static final QName FLOAT_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "FloatParameterType");
    public static final QName DOUBLE_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "DoubleParameterType");
    public static final QName BOOLEAN_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "BooleanParameterType");
    public static final QName URI_TYPE = new QName("http://airavata.apache.org/schemas/gfac/2012/12", "URIParameterType");

    public static boolean isKnownType(QName type) {
        if (WSConstants.XSD_ANY_TYPE.equals(type)) {
            return false;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespaceURI())) {
            return true;
        }
        if (LEAD_FILE_ID_TYPE.equals(type) || DATA_ID_TYPE.equals(type) || LEAD_WORKFLOW_ID_TYPE.equals(type) || LEAD_NAME_LIST_FILE_TYPE.equals(type) || LEAD_NAME_LIST_PROPERTIES_FILE_TYPE.equals(type) || HOST_NAME_TYPE.equals(type) || STRING_ARRAY_TYPE.equals(type) || INTEGER_ARRAY_TYPE.equals(type) || FLOAT_ARRAY_TYPE.equals(type) || DOUBLE_ARRAY_TYPE.equals(type) || BOOLEAN_ARRAY_TYPE.equals(type) || QNAME_ARRAY_TYPE.equals(type) || URI_ARRAY_TYPE.equals(type) || LEAD_FILE_ID_ARRAY_TYPE.equals(type) || DATA_ID_ARRAY_TYPE.equals(type) || STRING_TYPE.equals(type) || URI_TYPE.equals(type) || INTEGER_TYPE.equals(type) || FLOAT_TYPE.equals(type) || DOUBLE_TYPE.equals(type) || BOOLEAN_TYPE.equals(type)) {
            return true;
        }
        if (DATA_ID_TYPE.getLocalPart().equals(type.getLocalPart())) {
            logger.warn("The name space of " + type.getLocalPart() + " should be " + DATA_ID_TYPE.getNamespaceURI() + ", not " + type.getNamespaceURI() + ".");
            return true;
        }
        return false;
    }

    public static boolean isURIType(QName type) {
        return WSConstants.XSD_ANY_URI.equals(type) || LEAD_NAME_LIST_PROPERTIES_FILE_TYPE.equals(type) || LEAD_FILE_ID_TYPE.equals(type) || LEAD_NAME_LIST_FILE_TYPE.equals(type) || LEAD_WORKFLOW_ID_TYPE.equals(type) || URI_TYPE.equals(type);
    }

    public static boolean isArrayType(QName type) {
        if (STRING_ARRAY_TYPE.equals(type) || INTEGER_ARRAY_TYPE.equals(type) || FLOAT_ARRAY_TYPE.equals(type) || DOUBLE_ARRAY_TYPE.equals(type) || BOOLEAN_ARRAY_TYPE.equals(type) || QNAME_ARRAY_TYPE.equals(type) || URI_ARRAY_TYPE.equals(type) || LEAD_FILE_ID_ARRAY_TYPE.equals(type) || DATA_ID_ARRAY_TYPE.equals(type)) {
            return true;
        }
        if (LEAD_FILE_ID_ARRAY_TYPE.getLocalPart().equals(type.getLocalPart())) {
            logger.warn("The name space of " + type.getLocalPart() + " should be " + LEAD_FILE_ID_ARRAY_TYPE.getNamespaceURI() + ", not " + type.getNamespaceURI() + ".");
            return true;
        }
        return false;
    }

    public static boolean isURIArrayType(QName type) {
        return URI_ARRAY_TYPE.equals(type) || LEAD_FILE_ID_ARRAY_TYPE.equals(type);
    }
}

