/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.jython.script;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.system.ConstantNode;
import org.apache.airavata.workflow.model.graph.system.EndifNode;
import org.apache.airavata.workflow.model.graph.system.IfNode;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.MemoNode;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.workflow.model.graph.system.SystemDataPort;
import org.apache.airavata.workflow.model.graph.util.GraphUtil;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaConstants;
import org.apache.airavata.xbaya.XBayaVersion;
import org.apache.airavata.xbaya.invoker.GenericInvoker;
import org.apache.airavata.xbaya.jython.lib.NotificationSender;

public class JythonScript {
    public static final String GFAC_VARIABLE = "gfacURL";
    public static final String BROKER_URL_VARIABLE = "brokerURL";
    public static final String MESSAGE_BOX_URL_VARIABLE = "msgBoxURL";
    public static final String TOPIC_VARIABLE = "topic";
    private static final String INVOKER_CLASS = StringUtil.getClassName(GenericInvoker.class);
    private static final String NOTIFICATION_CLASS = StringUtil.getClassName(NotificationSender.class);
    private static final String WORKFLOW_STARTED_METHOD = "workflowStarted";
    private static final String WORKFLOW_COMPLETED_METHOD = "workflowFinished";
    private static final String WORKFLOW_INCOMPLETED_METHOD = "workflowFailed";
    private static final String SETUP_METHOD = "setup";
    private static final String SET_OPERATION_METHOD = "setOperation";
    private static final String SET_INPUT_METHOD = "setInput";
    private static final String GET_OUTPUT_METHOD = "getOutput";
    private static final String WAIT_METHOD = "waitToFinish";
    private static final String INVOKE_METHOD = "invoke";
    private static final String GET_PROPERTY_METHOD = "getProperty";
    private static final String NOTIFICATION_VARIABLE = "notifier";
    private static final String PROPERTIES_VARIABLE = "properties";
    private static final String INVOKER_SUFFIX = "_invoker";
    private static final String QNAME_SUFFIX = "_qname";
    private static final String VALUE_SUFFIX = "_value";
    private static final String TAB = "    ";
    private static final String WSDL_SUFFIX = "_wsdl";
    private XBayaConfiguration configuration;
    private Workflow workflow;
    private Graph graph;
    private Collection<Node> notYetInvokedNodes;
    private Collection<Node> executingNodes;
    private Collection<InputNode> inputNodes;
    private Collection<OutputNode> outputNodes;
    private List<String> arguments;
    private String scriptString;

    public JythonScript(Workflow workflow, XBayaConfiguration configuration) {
        this.workflow = workflow;
        this.configuration = configuration;
        this.graph = this.workflow.getGraph();
        this.arguments = new ArrayList<String>();
        this.notYetInvokedNodes = new LinkedList<Node>();
        for (Node node : this.graph.getNodes()) {
            if (node instanceof MemoNode) continue;
            this.notYetInvokedNodes.add(node);
        }
        this.executingNodes = new LinkedList<Node>();
        this.inputNodes = GraphUtil.getInputNodes((Graph)this.graph);
        this.outputNodes = GraphUtil.getOutputNodes((Graph)this.graph);
    }

    public static String getWSDLID(Node node) {
        return node.getID() + WSDL_SUFFIX;
    }

    public String getJythonString() {
        return this.scriptString;
    }

    public String getJythonString(List<String> parameters) {
        int index = this.scriptString.indexOf("# Process command-line arguments.");
        StringBuilder builder = new StringBuilder(this.scriptString.substring(0, index));
        builder.append("sys.argv = [");
        for (String string : parameters) {
            builder.append("'");
            builder.append(string);
            builder.append("',");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        builder.append("\n");
        builder.append(this.scriptString.substring(index));
        return builder.toString();
    }

    public boolean validate(List<String> warnings) {
        List constantNodes;
        if (this.graph.getNodes().size() == 0) {
            String message = "The workflow is empty.";
            warnings.add(message);
        }
        Collection inputPorts = GraphUtil.getPorts((Graph)this.graph, (Port.Kind)Port.Kind.DATA_IN);
        for (Port inputPort : inputPorts) {
            Collection fromPorts = inputPort.getFromPorts();
            if (fromPorts.size() != 0) continue;
            Node node = inputPort.getNode();
            String message = node.getID() + " has an unconnected input " + inputPort.getName();
            warnings.add(message);
        }
        for (InputNode inputNode : this.inputNodes) {
            if (inputNode.getPort().getToPorts().size() != 0) continue;
            String message = inputNode.getID() + " is not connected to any service.";
            warnings.add(message);
        }
        if (GraphUtil.containsCycle((Graph)this.graph)) {
            String message = "There is a cycle in the workflow, only acyclic workflows are supported";
            warnings.add(message);
        }
        if ((constantNodes = GraphUtil.getNodes((Graph)this.graph, ConstantNode.class)).size() > 0) {
            String message = "Constants are not supported for Jython scripts.";
            warnings.add(message);
        }
        List ifNodes = GraphUtil.getNodes((Graph)this.graph, IfNode.class);
        List endifNodes = GraphUtil.getNodes((Graph)this.graph, EndifNode.class);
        if (ifNodes.size() > 0 || endifNodes.size() > 0) {
            String message = "If/endif are not supported for Jython scripts.";
            warnings.add(message);
        }
        return warnings.size() <= 0;
    }

    public void create() throws GraphException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.writeHeader(printWriter);
        this.writeParameters(printWriter);
        this.writeWSDLLocations(printWriter);
        this.writeCommandLineArguments(printWriter);
        this.writeSetup(printWriter);
        this.writeInvocations(printWriter);
        this.writeOutputs(printWriter);
        this.writeWaitAll(printWriter);
        this.writeFooter(printWriter);
        printWriter.close();
        this.scriptString = stringWriter.toString();
    }

    private void writeCommandLineArguments(PrintWriter pw) {
        pw.println("def usage():");
        pw.println("    print '''");
        pw.println("Options: -help");
        pw.println("         -f properties_file");
        for (String argument : this.arguments) {
            pw.println("         -" + argument + " value");
        }
        pw.println("'''");
        pw.println("    sys.exit(0)");
        pw.println();
        pw.println("# Process command-line arguments.");
        pw.println("if sys.argv[0][0] != '-':");
        pw.println("    sys.argv = sys.argv[1:]");
        pw.println("while sys.argv:");
        pw.println("    if sys.argv[0] == '-f':");
        pw.println("        # Read parameters from a file.");
        pw.println("        propertyFilename = sys.argv[1]");
        pw.println("        inputStream = FileInputStream(propertyFilename)");
        pw.println("        properties.load(inputStream)");
        for (String argument : this.arguments) {
            pw.println("    elif sys.argv[0] == '-" + argument + "':");
            pw.println("        properties.put('" + argument + "', sys.argv[1])");
        }
        pw.println("    else:");
        pw.println("        usage()");
        pw.println("    sys.argv = sys.argv[2:]");
        pw.println();
    }

    private void writeHeader(PrintWriter pw) {
        pw.println("#");
        pw.println("# This script is automatically generated by XBaya Dashboard " + XBayaVersion.VERSION + ".");
        pw.println("#");
        pw.println();
        pw.println("import sys, thread");
        pw.println("from java.lang import Throwable");
        pw.println("from java.util import Properties");
        pw.println("from java.io import FileInputStream");
        pw.println("from javax.xml.namespace import QName");
        pw.println("from " + GenericInvoker.class.getPackage().getName() + " import " + INVOKER_CLASS);
        pw.println("from " + NotificationSender.class.getPackage().getName() + " import " + NOTIFICATION_CLASS);
        pw.println();
    }

    private void writeParameters(PrintWriter pw) {
        pw.println("properties = Properties()");
        pw.println();
        pw.println("# Set up defaut parameter values.");
        this.writeSetProperty(BROKER_URL_VARIABLE, XBayaConstants.DEFAULT_BROKER_URL, pw);
        this.writeSetProperty(MESSAGE_BOX_URL_VARIABLE, this.configuration.getMessageBoxURL(), pw);
        this.writeSetProperty(TOPIC_VARIABLE, "xbaya-topic", pw);
        this.writeSetProperty(GFAC_VARIABLE, this.configuration.getGFacURL(), pw);
        for (InputNode paramNode : this.inputNodes) {
            this.writeParameter(paramNode, pw);
            this.notYetInvokedNodes.remove(paramNode);
        }
        pw.println();
    }

    private void writeParameter(InputNode inputNode, PrintWriter pw) {
        String id = inputNode.getID();
        Object value = inputNode.getDefaultValue();
        String valueString = "";
        if (value instanceof String) {
            valueString = (String)value;
        }
        this.writeSetProperty(id, valueString, pw);
    }

    private void writeWSDLLocations(PrintWriter pw) {
        pw.println("# Set up default WSDL URLs.");
        for (WSNode node : GraphUtil.getWSNodes((Graph)this.graph)) {
            this.writeWSDLLocation(node, pw);
        }
        pw.println();
    }

    private void writeWSDLLocation(WSNode node, PrintWriter pw) {
        String defaultWsdlLocation = "";
        this.writeSetProperty(JythonScript.getWSDLID((Node)node), defaultWsdlLocation, pw);
    }

    private void writeSetProperty(String name, URI uri, PrintWriter pw) {
        this.writeSetProperty(name, StringUtil.toString((Object)uri), pw);
    }

    private void writeSetProperty(String name, String value, PrintWriter pw) {
        if (value == null) {
            value = "";
        }
        pw.println("properties.setProperty(");
        pw.println("        '" + name + "',");
        pw.println("        '" + value + "')");
        this.arguments.add(name);
    }

    private void writeSetup(PrintWriter pw) {
        pw.println("gfacURL = properties.getProperty('gfacURL')");
        pw.println("topic = properties.getProperty('topic')");
        pw.println("brokerURL = properties.getProperty('brokerURL')");
        pw.println("msgBoxURL = properties.getProperty('msgBoxURL')");
        pw.println("notifier = " + NOTIFICATION_CLASS + "(" + BROKER_URL_VARIABLE + ", " + TOPIC_VARIABLE + ")");
        pw.println("notifier.workflowStarted(");
        boolean first = true;
        for (InputNode inputNode : this.inputNodes) {
            String id = inputNode.getID();
            if (first) {
                first = false;
            } else {
                pw.println(",");
            }
            pw.print(TAB + id + "=" + PROPERTIES_VARIABLE + "." + GET_PROPERTY_METHOD + "('" + id + "')");
        }
        pw.println(")");
        pw.println();
        pw.println("try:");
    }

    private void writeInvocations(PrintWriter pw) throws GraphException {
        Collection<Node> nextNodes = this.getNextNodes();
        while (nextNodes.size() > 0) {
            boolean thread = nextNodes.size() > 1;
            for (Node node : nextNodes) {
                if (node instanceof WSNode) {
                    WSNode wsNode = (WSNode)node;
                    this.writeInvocation(wsNode, thread, pw);
                }
                this.notYetInvokedNodes.remove(node);
            }
            nextNodes = this.getNextNodes();
        }
    }

    private void writeInvocation(WSNode node, boolean thread, PrintWriter pw) {
        String id = node.getID();
        String wsdlID = JythonScript.getWSDLID((Node)node);
        WSComponent component = node.getComponent();
        QName portTypeQName = component.getPortTypeQName();
        String operation = component.getOperationName();
        pw.println("    # Invoke " + id + ".");
        pw.println(TAB + id + QNAME_SUFFIX + " = QName('" + portTypeQName.getNamespaceURI() + "', '" + portTypeQName.getLocalPart() + "')");
        pw.println(TAB + wsdlID + " = " + PROPERTIES_VARIABLE + "." + GET_PROPERTY_METHOD + "('" + wsdlID + "')");
        pw.println(TAB + id + INVOKER_SUFFIX + " = " + INVOKER_CLASS + "(" + id + QNAME_SUFFIX + ", " + wsdlID + ", '" + id + "',");
        pw.println("        msgBoxURL, gfacURL, notifier)");
        pw.println("    def invoke" + id + "():");
        pw.println("        " + id + INVOKER_SUFFIX + "." + SETUP_METHOD + "()");
        pw.println("        " + id + INVOKER_SUFFIX + "." + SET_OPERATION_METHOD + "('" + operation + "')");
        for (Port port : node.getInputPorts()) {
            String value;
            String portName = port.getName();
            Node fromNode = port.getFromNode();
            if (fromNode instanceof InputNode) {
                value = "properties.getProperty('" + fromNode.getID() + "')";
            } else {
                Port fromPort = port.getFromPort();
                value = "" + fromNode.getID() + INVOKER_SUFFIX + "." + GET_OUTPUT_METHOD + "('" + fromPort.getName() + "')";
                this.executingNodes.remove(fromNode);
            }
            pw.println("        " + portName + VALUE_SUFFIX + " = " + value);
            pw.println("        " + id + INVOKER_SUFFIX + "." + SET_INPUT_METHOD + "('" + portName + "', " + portName + VALUE_SUFFIX + ")");
        }
        pw.println("        print 'Invoking " + id + ".'");
        pw.println("        " + id + INVOKER_SUFFIX + "." + INVOKE_METHOD + "()");
        if (thread) {
            pw.println("    thread.start_new_thread(invoke" + id + ", ())");
        } else {
            pw.println("    invoke" + id + "()");
        }
        pw.println();
        this.executingNodes.add((Node)node);
    }

    private void writeOutputs(PrintWriter pw) throws GraphException {
        for (OutputNode outputNode : this.outputNodes) {
            this.writeOutput(outputNode, pw);
        }
    }

    private void writeOutput(OutputNode node, PrintWriter pw) throws GraphException {
        String id = node.getID();
        SystemDataPort port = node.getPort();
        Node fromNode = port.getFromNode();
        if (fromNode == null) {
            throw new GraphException("Output parameter has to be connected to some node.");
        }
        Port fromPort = port.getFromPort();
        if (fromNode instanceof InputNode) {
            pw.println(TAB + id + VALUE_SUFFIX + " = " + PROPERTIES_VARIABLE + "." + GET_PROPERTY_METHOD + "('" + fromNode.getID() + "')");
        } else {
            pw.println("    # Wait output " + id);
            pw.println(TAB + id + VALUE_SUFFIX + " = " + fromNode.getID() + INVOKER_SUFFIX + "." + GET_OUTPUT_METHOD + "('" + fromPort.getName() + "')");
        }
        pw.println("    print '" + id + " = ', " + id + VALUE_SUFFIX);
        this.executingNodes.remove(fromNode);
        pw.println();
    }

    private void writeWaitAll(PrintWriter pw) {
        pw.println("    # Wait all executing services.");
        for (Node node : this.executingNodes) {
            this.writeWait(node, pw);
        }
        pw.println();
    }

    private void writeWait(Node node, PrintWriter pw) {
        String id = node.getID();
        pw.println("    print 'Waiting " + id + " to be done.'");
        pw.println(TAB + id + INVOKER_SUFFIX + "." + WAIT_METHOD + "()");
    }

    private void writeFooter(PrintWriter pw) {
        pw.println("    notifier.workflowFinished(");
        boolean first = true;
        for (OutputNode node : this.outputNodes) {
            if (first) {
                first = false;
            } else {
                pw.println(",");
            }
            String id = node.getID();
            pw.print("        " + id + "=" + id + VALUE_SUFFIX);
        }
        pw.println(")");
        pw.println("    print 'Everything is done successfully.'");
        pw.println();
        pw.println("except Throwable, e:");
        pw.println("    print 'Error: ', e");
        pw.println("    notifier.workflowFailed(e)");
    }

    private Collection<Node> getNextNodes() throws GraphException {
        ArrayList<Node> nextNodes = new ArrayList<Node>();
        for (Node node : this.notYetInvokedNodes) {
            if (!this.isNextNode(node)) continue;
            nextNodes.add(node);
        }
        return nextNodes;
    }

    private boolean isNextNode(Node node) throws GraphException {
        if (node instanceof OutputNode) {
            return false;
        }
        for (Port port : node.getInputPorts()) {
            Collection fromNodes = port.getFromNodes();
            if (fromNodes.isEmpty()) {
                throw new GraphException("There is a port that is not connected to any.");
            }
            for (Node fromNode : fromNodes) {
                if (!this.notYetInvokedNodes.contains(fromNode)) continue;
                return false;
            }
        }
        ControlPort port = node.getControlInPort();
        if (port != null) {
            Collection fromNodes = port.getFromNodes();
            for (Node fromNode : fromNodes) {
                if (!this.notYetInvokedNodes.contains(fromNode)) continue;
                return false;
            }
        }
        return true;
    }
}

