/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.jython.runner;

import java.util.List;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.xbaya.jython.runner.JythonClassLoader;
import org.apache.airavata.xbaya.jython.runner.JythonOneTimeRunner;
import org.apache.airavata.xbaya.jython.runner.JythonOneTimeRunnerImpl;

public class JythonRunner {
    private JythonClassLoader loader = new JythonClassLoader(this.getClass().getClassLoader());

    public void run(String script, List<String> arguments) throws WorkflowException {
        this.run(script, arguments.toArray(new String[arguments.size()]));
    }

    public void run(String script, String[] arguments) throws WorkflowException {
        try {
            Class<?> runnerClass = this.loader.loadClass(JythonOneTimeRunnerImpl.class.getName(), true);
            JythonOneTimeRunner runner = (JythonOneTimeRunner)runnerClass.newInstance();
            runner.run(script, arguments);
        }
        catch (ClassNotFoundException e) {
            throw new WorkflowRuntimeException("Unexpected error.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new WorkflowRuntimeException("Unexpected error.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WorkflowRuntimeException("Unexpected error.", (Throwable)e);
        }
        finally {
            this.loader.cleanUp();
        }
    }
}

