/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.jython.runner;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.jython.runner.JythonClassLoader;
import org.apache.airavata.xbaya.jython.runner.JythonOneTimeRunner;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonOneTimeRunnerImpl
implements JythonOneTimeRunner {
    private static final Logger logger = LoggerFactory.getLogger(JythonOneTimeRunnerImpl.class);

    @Override
    public void run(final String script, final String[] arguments) throws WorkflowException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    ClassLoader loader = this.getClass().getClassLoader();
                    PySystemState.initialize((Properties)System.getProperties(), null, (String[])arguments, (ClassLoader)loader);
                    if (loader instanceof JythonClassLoader) {
                        logger.debug("jythonClassLoader");
                        JythonClassLoader jythonLoader = (JythonClassLoader)loader;
                        JarFile xbayaJarFile = jythonLoader.getXBayaJarFile();
                        if (xbayaJarFile != null) {
                            String jarPath = xbayaJarFile.getName();
                            logger.debug("jarPath: " + jarPath);
                            File jarFile = new File(jarPath);
                            String jarDir = jarFile.getParent();
                            logger.debug("jarDir: " + jarDir);
                            PySystemState.add_extdir((String)jarDir);
                        }
                    }
                    PythonInterpreter interpreter = new PythonInterpreter();
                    interpreter.exec(script);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowException(e.getCause());
        }
    }
}

