/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.jython.runner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.airavata.common.utils.IOUtil;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.xbaya.XBayaVersion;
import org.apache.airavata.xbaya.jython.lib.NotificationSender;
import org.apache.airavata.xbaya.jython.runner.JythonOneTimeRunnerImpl;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonClassLoader
extends SecureClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(JythonClassLoader.class);
    private ClassLoader parent;
    private Map<String, Class> classes = new HashMap<String, Class>();
    private URL jythonURL;
    private URL xbayaURL;
    private JarFile jythonJarFile;
    private JarFile xbayaJarFile;
    private File tmpJarDirectory;

    public JythonClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
        this.jythonURL = this.getBaseURL(PythonInterpreter.class);
        this.xbayaURL = this.getBaseURL(XBayaVersion.class);
    }

    public JarFile getXBayaJarFile() {
        if (this.xbayaJarFile == null) {
            this.xbayaJarFile = this.maybeGetJarFile(this.xbayaURL);
        }
        return this.xbayaJarFile;
    }

    public void cleanUp() {
        this.jythonJarFile = null;
        this.xbayaJarFile = null;
        if (this.tmpJarDirectory != null) {
            try {
                IOUtil.deleteDirectory((File)this.tmpJarDirectory);
            }
            catch (RuntimeException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, false);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolveIt) throws ClassNotFoundException {
        Class<?> klass = null;
        try {
            klass = this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                klass = super.loadClass(name, false);
            }
            catch (ClassNotFoundException e2) {
                klass = this.parent.loadClass(name);
                logger.debug("found from parent, klass: " + klass);
            }
        }
        if (resolveIt) {
            this.resolveClass(klass);
        }
        return klass;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class klass;
        if (this.jythonJarFile == null) {
            this.jythonJarFile = this.maybeGetJarFile(this.jythonURL);
        }
        if (this.jythonJarFile == null) {
            this.xbayaJarFile = this.maybeGetJarFile(this.xbayaURL);
        }
        if ((klass = this.classes.get(name)) != null) {
            return klass;
        }
        if (name.startsWith("org.python.")) {
            klass = this.findClassFromURL(name, this.jythonURL, this.jythonJarFile);
        } else if (name.startsWith(NotificationSender.class.getPackage().getName()) || name.startsWith(JythonOneTimeRunnerImpl.class.getName())) {
            klass = this.findClassFromURL(name, this.xbayaURL, this.xbayaJarFile);
        }
        if (klass != null) {
            this.classes.put(name, klass);
            return klass;
        }
        throw new ClassNotFoundException();
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        Permissions permissions = new Permissions();
        AllPermission permission = new AllPermission();
        permissions.add(permission);
        return permissions;
    }

    private URL getBaseURL(Class klass) {
        String jarURLString;
        String file;
        String path = klass.getName().replace('.', '/').concat(".class");
        URL classURL = this.parent.getResource(path);
        if ("jar".equals(classURL.getProtocol())) {
            file = classURL.getFile();
            logger.debug("file: " + file);
            jarURLString = file.substring(0, file.lastIndexOf(33));
        } else {
            file = classURL.getFile();
            int index = file.lastIndexOf(path);
            jarURLString = "file:" + file.substring(0, index);
        }
        try {
            URL jarURL = new URL(jarURLString);
            return jarURL;
        }
        catch (MalformedURLException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    private JarFile maybeGetJarFile(URL url) {
        String path;
        try {
            path = URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        logger.debug("path: " + path);
        if (path.endsWith("/")) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            try {
                JarFile jarFile = new JarFile(path);
                return jarFile;
            }
            catch (IOException e) {
                throw new WorkflowRuntimeException((Throwable)e);
            }
        }
        try {
            if (this.tmpJarDirectory == null) {
                Date date = new Date();
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss-S");
                String time = format.format(date);
                String fileName = ".xbaya-jars-" + time;
                String tmpdir = System.getProperty("java.io.tmpdir");
                this.tmpJarDirectory = new File(tmpdir, fileName);
                this.tmpJarDirectory.mkdir();
            }
            int i = path.lastIndexOf(47);
            File file = new File(this.tmpJarDirectory, path.substring(i + 1));
            logger.debug("file: " + file);
            InputStream stream = url.openStream();
            IOUtil.writeToFile((InputStream)stream, (File)file);
            JarFile jarFile = new JarFile(file);
            return jarFile;
        }
        catch (IOException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    private Class findClassFromURL(String name, URL url, JarFile jarFile) throws ClassNotFoundException {
        String classPath = name.replace('.', '/').concat(".class");
        try {
            byte[] classBytes;
            CodeSource codeSource = null;
            if (jarFile == null) {
                String dirPath = URLDecoder.decode(url.getPath(), "UTF-8");
                File classFile = new File(dirPath, classPath);
                classBytes = IOUtil.readToByteArray((File)classFile);
            } else {
                JarEntry jarEntry = jarFile.getJarEntry(classPath);
                CodeSigner[] codeSigners = jarEntry.getCodeSigners();
                if (codeSigners != null) {
                    for (CodeSigner signer : codeSigners) {
                        logger.debug("signer: " + signer);
                    }
                }
                codeSource = new CodeSource(this.xbayaURL, codeSigners);
                InputStream classInputStream = jarFile.getInputStream(jarEntry);
                classBytes = IOUtil.readToByteArray((InputStream)classInputStream);
            }
            Class<?> klass = this.defineClass(name, classBytes, 0, classBytes.length, codeSource);
            this.classes.put(name, klass);
            return klass;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ClassNotFoundException();
        }
    }

    @Override
    public synchronized void clearAssertionStatus() {
        super.clearAssertionStatus();
    }

    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    protected String findLibrary(String libname) {
        return super.findLibrary(libname);
    }

    @Override
    protected URL findResource(String name) {
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(name);
    }

    @Override
    protected Package getPackage(String name) {
        return super.getPackage(name);
    }

    @Override
    protected Package[] getPackages() {
        return super.getPackages();
    }

    @Override
    public URL getResource(String name) {
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return super.getResources(name);
    }

    @Override
    public synchronized void setClassAssertionStatus(String className, boolean enabled) {
        super.setClassAssertionStatus(className, enabled);
    }

    @Override
    public synchronized void setDefaultAssertionStatus(boolean enabled) {
        super.setDefaultAssertionStatus(enabled);
    }

    @Override
    public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
        super.setPackageAssertionStatus(packageName, enabled);
    }
}

