/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.jython.lib;

import java.net.URI;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaConstants;
import org.apache.airavata.xbaya.jython.lib.ServiceNotifiable;
import org.apache.axis2.addressing.EndpointReference;
import xsul.wsif.WSIFMessage;

public class StandaloneServiceNotificationSender
implements ServiceNotifiable {
    private Workflow workflow;
    private String serviceID;
    private URI workflowID;

    public StandaloneServiceNotificationSender(Workflow workflow, URI workflowID) {
        this.workflow = workflow;
        this.workflowID = workflowID;
    }

    @Override
    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
        System.out.println(serviceID);
    }

    @Override
    public EndpointReference getEventSink() {
        return new EndpointReference(XBayaConstants.DEFAULT_BROKER_URL.toString());
    }

    @Override
    public URI getWorkflowID() {
        return this.workflowID;
    }

    @Override
    public void invokingService(WSIFMessage inputs) {
        this.getNode().setState(Node.NodeExecutionState.EXECUTING);
    }

    @Override
    public void serviceFinished(WSIFMessage outputs) {
        this.getNode().setState(Node.NodeExecutionState.FINISHED);
    }

    @Override
    public void invocationFailed(String message, Throwable e) {
        this.getNode().setState(Node.NodeExecutionState.FAILED);
    }

    @Override
    public void receivedFault(String message) {
        this.getNode().setState(Node.NodeExecutionState.FAILED);
    }

    @Override
    public void receivedFault(WSIFMessage fault) {
        this.getNode().setState(Node.NodeExecutionState.FAILED);
    }

    private Node getNode() {
        return this.workflow.getGraph().getNode(this.serviceID);
    }
}

