/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.jython.lib;

import java.net.URI;
import java.util.Iterator;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.tracking.WorkflowNotifier;
import org.apache.airavata.workflow.tracking.common.InvocationContext;
import org.apache.airavata.workflow.tracking.common.InvocationEntity;
import org.apache.airavata.workflow.tracking.common.WorkflowTrackingContext;
import org.apache.airavata.workflow.tracking.impl.state.InvocationContextImpl;
import org.apache.airavata.xbaya.jython.lib.ServiceNotifiable;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.wsif.WSIFMessage;

public class ServiceNotificationSender
implements ServiceNotifiable {
    private static final Logger logger = LoggerFactory.getLogger(ServiceNotificationSender.class);
    private WorkflowNotifier notifier;
    private URI workflowID;
    private String nodeID;
    private String serviceID;
    private InvocationEntity receiver;
    private InvocationEntity initiator;
    private InvocationContext invocationContext;
    private WorkflowTrackingContext context;
    private EndpointReference eventSink;

    protected ServiceNotificationSender(WorkflowNotifier notifier, EndpointReference eventSink, InvocationEntity initiator, URI workflowID, String nodeID, WorkflowTrackingContext context, InvocationContext invocationContext) {
        this.notifier = notifier;
        this.eventSink = eventSink;
        this.initiator = initiator;
        this.workflowID = workflowID;
        this.nodeID = nodeID;
        this.context = context;
        this.serviceID = "";
        this.invocationContext = invocationContext;
        URI receiverWorkflowID = this.workflowID;
        URI receiverServiceID = URI.create(this.serviceID);
        String receiverWorkflowNodeID = this.nodeID;
        Integer workflowTimeStep = new Integer(0);
        this.receiver = this.notifier.createEntity(receiverWorkflowID, receiverServiceID, receiverWorkflowNodeID, workflowTimeStep);
    }

    @Override
    public void setServiceID(String serviceID) {
        logger.debug("SerivceID:" + serviceID);
        this.serviceID = serviceID;
        URI receiverWorkflowID = this.workflowID;
        URI receiverServiceID = URI.create(this.serviceID);
        String receiverWorkflowNodeID = this.nodeID;
        Integer workflowTimeStep = new Integer(0);
        this.receiver = this.notifier.createEntity(receiverWorkflowID, receiverServiceID, receiverWorkflowNodeID, workflowTimeStep);
    }

    @Override
    public EndpointReference getEventSink() {
        return this.eventSink;
    }

    @Override
    public URI getWorkflowID() {
        return this.workflowID;
    }

    @Override
    public void invokingService(WSIFMessage inputs) {
        XmlObject body;
        String message = "";
        Iterator partIt = inputs.partNames().iterator();
        boolean first = true;
        while (partIt.hasNext()) {
            if (first) {
                first = false;
            } else {
                message = message + ", ";
            }
            String name = (String)partIt.next();
            Object value = inputs.getObjectPart(name);
            if (value instanceof XmlElement) {
                message = message + name + "=";
                Iterator children = ((XmlElement)value).children();
                while (children.hasNext()) {
                    message = message + children.next();
                }
                continue;
            }
            message = message + name + "=" + value;
        }
        XmlObject header = null;
        try {
            body = XmlObject.Factory.parse((String)inputs.toString());
        }
        catch (XmlException e) {
            logger.warn("Failed to parse " + inputs.toString(), (Throwable)e);
            body = null;
        }
        this.invocationContext = this.notifier.invokingService(this.context, this.receiver, header, body, new String[]{message});
    }

    @Override
    public void serviceFinished(WSIFMessage outputs) {
        XmlObject body;
        String message = "";
        Iterator partIt = outputs.partNames().iterator();
        boolean first = true;
        while (partIt.hasNext()) {
            if (first) {
                first = false;
            } else {
                message = message + ", ";
            }
            String name = (String)partIt.next();
            Object value = outputs.getObjectPart(name);
            if (value instanceof XmlElement) {
                message = message + name + "=";
                Iterator children = ((XmlElement)value).children();
                while (children.hasNext()) {
                    message = message + children.next();
                }
                continue;
            }
            message = message + name + "=" + value;
        }
        XmlObject header = null;
        try {
            body = XmlObject.Factory.parse((String)outputs.toString());
        }
        catch (XmlException e) {
            logger.warn("Failed to parse " + outputs.toString(), (Throwable)e);
            body = null;
        }
        this.notifier.receivedResult(this.context, this.invocationContext, header, body, new String[]{message});
    }

    @Override
    public void invocationFailed(String message, Throwable e) {
        if (this.invocationContext == null) {
            this.invocationContext = new InvocationContextImpl(this.initiator, this.receiver);
        }
        logger.error(e.getMessage(), e);
        if (message == null || "".equals(message)) {
            message = "Error";
        }
        if (e != null) {
            message = message + ": " + e.toString();
        }
        if (e != null) {
            String stackTrace = StringUtil.getStackTraceInString((Throwable)e);
            org.xmlpull.infoset.XmlElement stackTraceElement = XMLUtil.BUILDER.newFragment("stackTrace");
            stackTraceElement.addChild((Object)stackTrace);
            String annotation = XMLUtil.xmlElementToString((org.xmlpull.infoset.XmlElement)stackTraceElement);
            this.notifier.invokingServiceFailed(this.context, this.invocationContext, e, new String[]{message, annotation});
        } else {
            this.notifier.invokingServiceFailed(this.context, this.invocationContext, new String[]{message});
        }
    }

    @Override
    @Deprecated
    public void receivedFault(String message) {
        if (this.invocationContext == null) {
            this.invocationContext = new InvocationContextImpl(this.initiator, this.receiver);
        }
        if (message == null || "".equals(message)) {
            message = "Error";
        }
        this.notifier.receivedFault(this.context, this.invocationContext, new String[]{message});
    }

    @Override
    public void receivedFault(WSIFMessage fault) {
        XmlObject body;
        if (this.invocationContext == null) {
            this.invocationContext = new InvocationContextImpl(this.initiator, this.receiver);
        }
        String message = "Received a fault message from the service";
        XmlObject header = null;
        try {
            body = XmlObject.Factory.parse((String)fault.toString());
        }
        catch (XmlException e) {
            logger.warn("Failed to parse " + fault.toString(), (Throwable)e);
            body = null;
        }
        this.notifier.receivedFault(this.context, this.invocationContext, header, body, new String[]{message});
    }
}

