/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.jython.lib;

import java.net.URI;
import java.util.Properties;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.tracking.NotifierFactory;
import org.apache.airavata.workflow.tracking.WorkflowNotifier;
import org.apache.airavata.workflow.tracking.common.InvocationContext;
import org.apache.airavata.workflow.tracking.common.InvocationEntity;
import org.apache.airavata.workflow.tracking.common.WorkflowTrackingContext;
import org.apache.airavata.xbaya.jython.lib.ServiceNotifiable;
import org.apache.airavata.xbaya.jython.lib.ServiceNotificationSender;
import org.apache.airavata.xbaya.jython.lib.WorkflowNotifiable;
import org.apache.axis2.addressing.EndpointReference;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;

public class NotificationSender
implements WorkflowNotifiable {
    protected static final Logger logger = LoggerFactory.getLogger(NotificationSender.class);
    protected WorkflowNotifier notifier;
    protected String brokerURL;
    protected String topic;
    protected URI workflowID;
    protected InvocationEntity initiator;
    protected InvocationEntity receiver;
    protected InvocationContext invocationContext;
    protected EndpointReference eventSink;
    protected WorkflowTrackingContext context;

    public NotificationSender(URI brokerURL, String topic) {
        this(brokerURL.toString(), topic);
    }

    public NotificationSender(String brokerURL, String topic) {
        logger.debug("brokerURL:" + brokerURL + "topic:" + topic);
        this.topic = topic;
        this.brokerURL = brokerURL;
        this.workflowID = URI.create(StringUtil.convertToJavaIdentifier((String)this.topic));
        this.eventSink = new EndpointReference(this.brokerURL);
        Properties props = new Properties();
        this.notifier = NotifierFactory.createNotifier();
        URI initiatorWorkflowID = null;
        URI initiatorServiceID = URI.create(StringUtil.convertToJavaIdentifier((String)topic));
        String initiatorWorkflowNodeID = null;
        Integer initiatorWorkflowTimeStep = null;
        this.context = this.notifier.createTrackingContext(props, brokerURL, initiatorWorkflowID, initiatorServiceID, initiatorWorkflowNodeID, initiatorWorkflowTimeStep);
        this.context.setTopic(topic);
        this.initiator = this.notifier.createEntity(initiatorWorkflowID, initiatorServiceID, initiatorWorkflowNodeID, initiatorWorkflowTimeStep);
        URI receiverWorkflowID = this.workflowID;
        URI receiverServiceID = this.workflowID;
        String receiverWorkflowNodeID = null;
        Integer receiverWorkflowTimeStep = null;
        this.receiver = this.notifier.createEntity(receiverWorkflowID, receiverServiceID, receiverWorkflowNodeID, receiverWorkflowTimeStep);
    }

    @Override
    public EndpointReference getEventSink() {
        return this.eventSink;
    }

    @Override
    public void workflowStarted(PyObject[] args, String[] keywords) {
        String message = "";
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                message = message + ", ";
            }
            message = message + keywords[i] + "=" + args[i];
        }
        this.invocationContext = this.notifier.workflowInvoked(this.context, this.initiator, new String[]{message});
    }

    @Override
    public void workflowStarted(Object[] args, String[] keywords) {
        String message = "";
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                message = message + ", ";
            }
            message = message + keywords[i] + "=" + args[i];
        }
        this.invocationContext = this.notifier.workflowInvoked(this.context, this.initiator, new String[]{message});
    }

    @Override
    public void workflowFinished(Object[] args, String[] keywords) {
        String message = "";
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                message = message + ", ";
            }
            message = message + keywords[i] + "=" + args[i];
        }
        this.notifier.sendingResult(this.context, this.invocationContext, new String[]{message});
        this.notifier.workflowTerminated(this.context, this.workflowID, new String[]{"Workflow finished successfully."});
    }

    @Override
    public void sendingPartialResults(Object[] args, String[] keywords) {
        String message = "";
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                message = message + ", ";
            }
            message = message + keywords[i] + "=" + args[i];
        }
        this.notifier.sendingResult(this.context, this.invocationContext, new String[]{message});
    }

    @Override
    public void workflowFinished(PyObject[] args, String[] keywords) {
        String message = "";
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                message = message + ", ";
            }
            message = message + keywords[i] + "=" + args[i];
        }
        this.notifier.sendingResult(this.context, this.invocationContext, new String[]{message});
        this.notifier.workflowTerminated(this.context, this.workflowID, new String[]{"Workflow finished successfully."});
    }

    @Override
    public void workflowTerminated() {
        this.notifier.workflowTerminated(this.context, this.workflowID, new String[]{"Workflow finished successfully."});
    }

    @Override
    public void workflowFailed(String message) {
        this.workflowFailed(message, null);
    }

    @Override
    public void workflowFailed(Throwable e) {
        this.workflowFailed(null, e);
    }

    @Override
    public void workflowFailed(String message, Throwable e) {
        if (e != null) {
            logger.error(e.getMessage(), e);
        }
        if (message == null || "".equals(message)) {
            message = "Error";
        }
        if (e != null) {
            message = message + ": " + e.toString();
        }
        if (e != null) {
            String stackTrace = StringUtil.getStackTraceInString((Throwable)e);
            XmlElement stackTraceElement = XMLUtil.BUILDER.newFragment("stackTrace");
            stackTraceElement.addChild((Object)stackTrace);
            this.notifier.sendingFault(this.context, this.invocationContext, new String[]{message, XMLUtil.xmlElementToString((XmlElement)stackTraceElement)});
        } else {
            this.notifier.sendingFault(this.context, this.invocationContext, new String[]{message});
        }
    }

    public void info(String message) {
        this.notifier.info(this.context, new String[]{message});
    }

    @Override
    public ServiceNotifiable createServiceNotificationSender(String nodeID) {
        return new ServiceNotificationSender(this.notifier, this.eventSink, this.initiator, this.workflowID, nodeID, this.context, this.invocationContext);
    }

    @Override
    public void cleanup() {
        this.notifier.delete();
    }

    @Override
    public String getTopic() {
        return this.topic;
    }
}

