/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.jython.lib;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.wsdl.WsdlDefinitions;
import xsul.wsdl.WsdlResolver;
import xsul.wsif.WSIFMessage;
import xsul.wsif.WSIFOperation;
import xsul.wsif.WSIFPort;
import xsul.wsif.WSIFService;
import xsul.wsif.WSIFServiceFactory;
import xsul.wsif.spi.WSIFProvider;
import xsul.wsif.spi.WSIFProviderManager;
import xsul.wsif_xsul_soap_http.Provider;

public class GFacServiceCreator {
    private static final String CREATE_SERVICE_OPERATION = "CreateService";
    private static final String SHUTDOWN_OPERATION = "Shutdown";
    private static final String SERVICE_QNAME_PART = "serviceQName";
    private static final String SECURITY_PART = "security";
    private static final String WSDL_PART = "WSDL";
    private static final String SECURITY_NONE = "None";
    private static final Logger logger = LoggerFactory.getLogger(GFacServiceCreator.class);
    private WSIFOperation gFacOperation;
    private WsdlDefinitions serviceDefinitions;

    public GFacServiceCreator(String wsdlURL) throws URISyntaxException, WorkflowException {
        this(new URI(wsdlURL));
    }

    public GFacServiceCreator(URI wsdlURI) throws WorkflowException {
        try {
            WsdlDefinitions definitions = WsdlResolver.getInstance().loadWsdl(wsdlURI);
            WSIFService service = WSIFServiceFactory.newInstance().getService(definitions);
            WSIFPort port = service.getPort();
            this.gFacOperation = port.createOperation(CREATE_SERVICE_OPERATION);
        }
        catch (RuntimeException e) {
            String message = "Failed to connect to the Generic Factory: " + wsdlURI;
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    public WsdlDefinitions createService(QName serviceQName) throws WorkflowException {
        return this.createService(serviceQName.toString());
    }

    public WsdlDefinitions createService(String serviceQName) throws WorkflowException {
        logger.debug(serviceQName);
        try {
            WSIFMessage inputMessage = this.gFacOperation.createInputMessage();
            WSIFMessage outputMessage = this.gFacOperation.createOutputMessage();
            WSIFMessage faultMessage = this.gFacOperation.createFaultMessage();
            inputMessage.setObjectPart(SERVICE_QNAME_PART, (Object)serviceQName);
            inputMessage.setObjectPart(SECURITY_PART, (Object)SECURITY_NONE);
            logger.debug("inputMessage: " + inputMessage);
            boolean success = this.gFacOperation.executeRequestResponseOperation(inputMessage, outputMessage, faultMessage);
            if (!success) {
                String message = "Failed to create a service: " + faultMessage.toString();
                throw new WorkflowException(message);
            }
            String wsdl = (String)outputMessage.getObjectPart(WSDL_PART);
            logger.debug("WSDL: " + wsdl);
            XmlElement definitionsElement = XMLUtil.stringToXmlElement3((String)wsdl);
            this.serviceDefinitions = new WsdlDefinitions(definitionsElement);
            return this.serviceDefinitions;
        }
        catch (RuntimeException e) {
            String message = "Failed to create a service";
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    public void shutdownService() throws WorkflowException {
        WSIFMessage faultMessage;
        WSIFMessage outputMessage;
        WSIFMessage inputMessage;
        WSIFService service = WSIFServiceFactory.newInstance().getService(this.serviceDefinitions);
        WSIFPort port = service.getPort();
        WSIFOperation operation = port.createOperation(SHUTDOWN_OPERATION);
        boolean success = operation.executeRequestResponseOperation(inputMessage = operation.createInputMessage(), outputMessage = operation.createOutputMessage(), faultMessage = operation.createFaultMessage());
        if (!success) {
            String message = "Failed to shutdown the service: " + faultMessage.toString();
            throw new WorkflowException(message);
        }
    }

    static {
        WSIFProviderManager.getInstance().addProvider((WSIFProvider)new Provider());
    }
}

