/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker.factory;

import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.common.workflow.execution.context.WorkflowContextHeaderBuilder;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.invoker.AsynchronousInvoker;
import org.apache.airavata.xbaya.invoker.GFacInvoker;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.invoker.SimpleInvoker;
import xsul.lead.LeadContextHeader;
import xsul5.wsdl.WsdlDefinitions;

public class InvokerFactory {
    public static Invoker createInvoker(QName portTypeQName, xsul.wsdl.WsdlDefinitions definitions, String gfacURL, String messageBoxURL, LeadContextHeader leadContext) throws WorkflowException {
        Invoker invoker = null;
        if (definitions != null && definitions.getServices().iterator().hasNext()) {
            invoker = WSDLUtil.isAsynchronousSupported((WsdlDefinitions)WSDLUtil.wsdlDefinitions3ToWsdlDefintions5((xsul.wsdl.WsdlDefinitions)definitions)) ? new AsynchronousInvoker(definitions, messageBoxURL) : new SimpleInvoker(definitions);
        } else if (gfacURL != null && gfacURL.length() != 0) {
            invoker = new GFacInvoker(portTypeQName, gfacURL, messageBoxURL, leadContext);
        }
        if (invoker == null) {
            String message = "Cannot find an appropriate way to invoke the service";
            throw new WorkflowException(message);
        }
        return invoker;
    }

    public static Invoker createInvoker(QName portTypeQName, xsul.wsdl.WsdlDefinitions definitions, String gfacURL, String messageBoxURL, WorkflowContextHeaderBuilder builder, boolean differ) throws WorkflowException {
        Invoker invoker = null;
        if (definitions != null && definitions.getServices().iterator().hasNext()) {
            invoker = WSDLUtil.isAsynchronousSupported((WsdlDefinitions)WSDLUtil.wsdlDefinitions3ToWsdlDefintions5((xsul.wsdl.WsdlDefinitions)definitions)) ? new AsynchronousInvoker(definitions, messageBoxURL) : new SimpleInvoker(definitions);
        } else if (gfacURL != null && gfacURL.length() != 0) {
            invoker = new GFacInvoker(portTypeQName, gfacURL, messageBoxURL, builder);
        }
        if (invoker == null) {
            String message = "Cannot find an appropriate way to invoke the service";
            throw new WorkflowException(message);
        }
        return invoker;
    }
}

