/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.xbaya.invoker.GFacInvoker;
import org.apache.airavata.xbaya.jython.lib.ServiceNotifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.lead.LeadContextHeader;
import xsul.wsif.WSIFMessage;

public class WorkflowInvokerWrapperForGFacInvoker
extends GFacInvoker {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowInvokerWrapperForGFacInvoker.class);
    private ServiceNotifiable notifier;
    private String serviceInformation;
    private Future<Boolean> result;
    protected boolean failerSent = false;

    public WorkflowInvokerWrapperForGFacInvoker(QName portTypeQName, String gfacURL, String messageBoxURL, LeadContextHeader leadcontext, ServiceNotifiable serviceNotificationSender) {
        super(portTypeQName, gfacURL, messageBoxURL, leadcontext);
        this.notifier = serviceNotificationSender;
        this.serviceInformation = portTypeQName.toString();
    }

    @Override
    public synchronized boolean invoke() throws WorkflowException {
        try {
            WSIFMessage inputMessage = super.getInputs();
            logger.debug("inputMessage: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)inputMessage)));
            this.notifier.invokingService(inputMessage);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            this.result = executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        boolean success = WorkflowInvokerWrapperForGFacInvoker.super.invoke();
                        if (success) {
                            WSIFMessage outputMessage = WorkflowInvokerWrapperForGFacInvoker.super.getOutputs();
                            logger.debug("outputMessage: " + outputMessage);
                            WorkflowInvokerWrapperForGFacInvoker.this.notifier.serviceFinished(outputMessage);
                        } else {
                            WSIFMessage faultMessage = WorkflowInvokerWrapperForGFacInvoker.super.getFault();
                            logger.debug("received fault: " + faultMessage);
                            WorkflowInvokerWrapperForGFacInvoker.this.notifier.receivedFault(faultMessage);
                            WorkflowInvokerWrapperForGFacInvoker.this.failerSent = true;
                        }
                        return success;
                    }
                    catch (WorkflowException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        WorkflowInvokerWrapperForGFacInvoker.this.notifier.invocationFailed(e.getMessage(), e);
                        WorkflowInvokerWrapperForGFacInvoker.this.failerSent = true;
                        throw new WorkflowRuntimeException((Throwable)e);
                    }
                    catch (RuntimeException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        String message = "Error in invoking a service: " + WorkflowInvokerWrapperForGFacInvoker.this.serviceInformation;
                        WorkflowInvokerWrapperForGFacInvoker.this.notifier.invocationFailed(message, e);
                        WorkflowInvokerWrapperForGFacInvoker.this.failerSent = true;
                        throw e;
                    }
                }
            });
            executor.shutdown();
            this.notifyAll();
            try {
                this.result.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (TimeoutException e) {
                return true;
            }
            catch (ExecutionException e) {
                logger.error(e.getMessage(), (Throwable)e);
                String message = "Error in invoking a service: " + this.serviceInformation;
                throw new WorkflowException(message, (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error in invoking a service: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        boolean success = super.invoke();
        if (!success) {
            try {
                throw new Exception("Failed invoking GFac");
            }
            catch (Exception e) {
                this.notifier.invocationFailed(super.getFault().toString(), e);
            }
        } else {
            this.notifier.serviceFinished(super.getOutputs());
        }
        return success;
    }

    public synchronized void waitToFinish() throws WorkflowException {
        try {
            while (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            Boolean success = this.result.get();
            if (!success.booleanValue()) {
                WSIFMessage faultMessage = super.getFault();
                String message = "Error in a service: ";
                message = message + faultMessage.toString();
                throw new WorkflowException(message);
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error in invoking a service: " + this.serviceInformation;
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error while waiting for a service to finish: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public Object getOutput(String name) throws WorkflowException {
        try {
            this.waitToFinish();
            Object output = super.getOutput(name);
            if (output instanceof XmlElement) {
                logger.debug("output: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)output)));
            }
            return output;
        }
        catch (WorkflowException e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (!this.failerSent) {
                this.notifier.invocationFailed(e.getMessage(), e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error while waiting for a output: " + name;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
    }
}

