/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker;

import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.ws.WSComponentPort;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.xbaya.lead.LEADTypes;

public class WorkflowInputUtil {
    public static String createInputForGFacService(WSComponentPort port, String input) {
        String paramType = port.getType().getLocalPart();
        StringBuffer inputString = new StringBuffer("<");
        if ("StringParameterType".equals(paramType) || "URIParameterType".equals(paramType) || "DoubleParameterType".equals(paramType) || "IntegerParameterType".equals(paramType) || "FloatParameterType".equals(paramType) || "BooleanParameterType".equals(paramType) || "FileParameterType".equals(paramType)) {
            inputString.append(port.getName()).append(">").append(WorkflowInputUtil.getValueElement(input)).append("</").append(port.getName()).append(">");
        } else if (paramType.endsWith("ArrayType")) {
            String[] valueList;
            inputString.append(port.getName()).append(">");
            for (String inputValue : valueList = input.split(",")) {
                inputString.append(WorkflowInputUtil.getValueElement(inputValue));
            }
            inputString.append(WorkflowInputUtil.getValueElement(port.getName()));
        }
        inputString.append(">");
        return inputString.toString();
    }

    private static String getValueElement(String value) {
        return "<value>" + value + "</value>";
    }

    public static Object parseValue(WSComponentPort input, String valueString) {
        String value;
        String name = input.getName();
        QName type = input.getType();
        if (LEADTypes.isKnownType(type)) {
            value = valueString;
        } else {
            try {
                if (!"http://airavata.apache.org/schemas/gfac/2012/12".equals(input.getType().getNamespaceURI())) {
                    throw new WorkflowRuntimeException("Input parameter, " + name + ", Unkown Type");
                }
                value = XMLUtil.stringToXmlElement3((String)WorkflowInputUtil.createInputForGFacService(input, valueString));
            }
            catch (RuntimeException e) {
                throw new WorkflowRuntimeException("Input parameter, " + name + ", is not valid XML", (Throwable)e);
            }
        }
        return value;
    }
}

