/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker;

import java.util.Iterator;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.invoker.GenericInvoker;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.wsdl.WsdlDefinitions;
import xsul.wsif.WSIFMessage;
import xsul.wsif.WSIFOperation;
import xsul.wsif.WSIFPort;
import xsul.wsif.WSIFService;
import xsul.wsif.WSIFServiceFactory;
import xsul.wsif.spi.WSIFProvider;
import xsul.wsif.spi.WSIFProviderManager;
import xsul.wsif_xsul_soap_http.Provider;
import xsul.xwsif_runtime.WSIFClient;
import xsul.xwsif_runtime.WSIFRuntime;

public class SimpleInvoker
implements Invoker {
    private static final Logger log = LoggerFactory.getLogger(GenericInvoker.class);
    protected WSIFClient client;
    private WsdlDefinitions definitions;
    private WSIFOperation operation;
    private WSIFMessage inputMessage;
    private volatile WSIFMessage outputMessage;
    private WSIFMessage faultMessage;
    private boolean lock = false;

    public SimpleInvoker(WsdlDefinitions definitions) {
        this.definitions = definitions;
    }

    @Override
    public void setup() throws WorkflowException {
        try {
            WSIFService service = WSIFServiceFactory.newInstance().getService(this.definitions);
            WSIFPort port = service.getPort();
            this.client = WSIFRuntime.getDefault().newClientFor(port);
            this.client.setAsyncResponseTimeoutInMs(999999999L);
        }
        catch (RuntimeException e) {
            String message = "The WSDL is in the wrong format";
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public WSIFClient getClient() {
        return this.client;
    }

    @Override
    public void setOperation(String operationName) throws WorkflowException {
        try {
            WSIFPort port = this.client.getPort();
            this.operation = port.createOperation(operationName);
            this.inputMessage = this.operation.createInputMessage();
            this.outputMessage = this.operation.createOutputMessage();
            this.faultMessage = this.operation.createFaultMessage();
        }
        catch (RuntimeException e) {
            String message = "The WSDL does not conform to the invoking service.";
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public void setInput(String name, Object value) throws WorkflowException {
        try {
            if (value instanceof XmlElement) {
                XmlElement valueElement = (XmlElement)value;
                valueElement.setName(name);
            } else if (value instanceof String) {
                if (XMLUtil.isXML((String)((String)value))) {
                    XmlElement valueElement = XMLUtil.stringToXmlElement3((String)((String)value));
                    valueElement.setName(name);
                    value = valueElement;
                }
            } else {
                value = "" + value;
            }
            this.inputMessage.setObjectPart(name, value);
        }
        catch (RuntimeException e) {
            String message = "Error in setting an input. name: " + name + " value: " + value;
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public WSIFMessage getInputs() {
        return this.inputMessage;
    }

    @Override
    public boolean invoke() throws WorkflowException {
        try {
            boolean success = this.operation.executeRequestResponseOperation(this.inputMessage, this.outputMessage, this.faultMessage);
            while (this.outputMessage == null) {
            }
            return success;
        }
        catch (RuntimeException e) {
            String message = "Error in invoking a service.";
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public WSIFMessage getOutputs() {
        if (this.lock) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.outputMessage;
    }

    @Override
    public Object getOutput(String name) throws WorkflowException {
        try {
            XmlElement outputElement = (XmlElement)this.outputMessage;
            XmlElement valueElement = outputElement.element(null, name);
            Iterator childIt = valueElement.children();
            int numberOfChildren = 0;
            while (childIt.hasNext()) {
                childIt.next();
                ++numberOfChildren;
            }
            if (numberOfChildren == 1) {
                Object child = valueElement.children().next();
                if (child instanceof String) {
                    String value = (String)child;
                    return value;
                }
                if (child instanceof XmlElement) {
                    log.debug("output: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)child)));
                    Object child1 = ((XmlElement)child).children().next();
                    if (child1 instanceof String) {
                        String value = (String)child1;
                        return value;
                    }
                }
            }
            return valueElement;
        }
        catch (RuntimeException e) {
            String message = "Error in getting output. name: " + name;
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public WSIFMessage getFault() {
        return this.faultMessage;
    }

    public WsdlDefinitions getDefinitions() {
        return this.definitions;
    }

    public WSIFOperation getOperation() {
        return this.operation;
    }

    public WSIFMessage getInputMessage() {
        return this.inputMessage;
    }

    public synchronized WSIFMessage getOutputMessage() {
        return this.outputMessage;
    }

    public WSIFMessage getFaultMessage() {
        return this.faultMessage;
    }

    public synchronized void setOutputMessage(WSIFMessage outputMessage) {
        log.debug("Setting output message");
        this.outputMessage = outputMessage;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public boolean isLock() {
        return this.lock;
    }

    static {
        WSIFProviderManager.getInstance().addProvider((WSIFProvider)new Provider());
    }
}

