/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.common.workflow.execution.context.WorkflowContextHeaderBuilder;
import org.apache.airavata.schemas.wec.ContextHeaderDocument;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.invoker.factory.InvokerFactory;
import org.apache.airavata.xbaya.jython.lib.ServiceNotifiable;
import org.apache.airavata.xbaya.jython.lib.WorkflowNotifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.XmlConstants;
import xsul.wsdl.WsdlDefinitions;
import xsul.wsdl.WsdlException;
import xsul.wsdl.WsdlResolver;
import xsul.wsif.WSIFMessage;
import xsul.xhandler.XHandler;
import xsul.xhandler_soap_sticky_header.StickySoapHeaderHandler;
import xsul.xwsif_runtime.WSIFClient;

public class GenericInvoker
implements Invoker {
    private static final Logger logger = LoggerFactory.getLogger(GenericInvoker.class);
    private String nodeID;
    private QName portTypeQName;
    private String wsdlLocation;
    private String serviceInformation;
    private String messageBoxURL;
    private String gfacURL;
    private Invoker invoker;
    private Future<Boolean> result;
    private ServiceNotifiable notifier;
    private ContextHeaderDocument.ContextHeader contextHeader;
    private String topic;
    private List<Object> inputValues = new ArrayList<Object>();
    private List<String> inputNames = new ArrayList<String>();
    boolean failerSent;
    private WsdlDefinitions wsdlDefinitionObject;

    public GenericInvoker(QName portTypeQName, String wsdlLocation, String nodeID, WorkflowNotifiable notifier) {
        this(portTypeQName, wsdlLocation, nodeID, null, notifier);
    }

    public GenericInvoker(QName portTypeQName, String wsdlLocation, String nodeID, String gfacURL, WorkflowNotifiable notifier) {
        this(portTypeQName, wsdlLocation, nodeID, null, gfacURL, notifier);
    }

    public GenericInvoker(QName portTypeQName, String wsdlLocation, String nodeID, String messageBoxURL, String gfacURL, WorkflowNotifiable notifier) {
        this.nodeID = nodeID;
        this.portTypeQName = portTypeQName;
        this.wsdlLocation = wsdlLocation;
        this.serviceInformation = wsdlLocation;
        this.messageBoxURL = messageBoxURL;
        this.gfacURL = gfacURL;
        this.notifier = notifier.createServiceNotificationSender(nodeID);
        this.failerSent = false;
        this.contextHeader = WorkflowContextHeaderBuilder.removeOtherSchedulingConfig((String)nodeID, (ContextHeaderDocument.ContextHeader)WorkflowContextHeaderBuilder.getCurrentContextHeader());
        this.topic = notifier.getTopic();
    }

    public GenericInvoker(QName portTypeQName, WsdlDefinitions wsdl, String nodeID, String messageBoxURL, String gfacURL, WorkflowNotifiable notifier) {
        String wsdlStr = XmlConstants.BUILDER.serializeToString((Object)wsdl);
        this.nodeID = nodeID;
        this.portTypeQName = portTypeQName;
        this.wsdlDefinitionObject = wsdl;
        this.messageBoxURL = messageBoxURL;
        this.serviceInformation = wsdlStr;
        this.gfacURL = gfacURL;
        this.notifier = notifier.createServiceNotificationSender(nodeID);
        this.failerSent = false;
        this.contextHeader = WorkflowContextHeaderBuilder.removeOtherSchedulingConfig((String)nodeID, (ContextHeaderDocument.ContextHeader)WorkflowContextHeaderBuilder.getCurrentContextHeader());
        this.topic = notifier.getTopic();
    }

    @Override
    public void setup() throws WorkflowException {
        try {
            WsdlDefinitions definitions = null;
            if (this.wsdlLocation != null && !this.wsdlLocation.equals("")) {
                WsdlResolver resolver = WsdlResolver.getInstance();
                definitions = resolver.loadWsdl(new File(".").toURI(), new URI(this.wsdlLocation));
            } else {
                definitions = this.wsdlDefinitionObject;
            }
            this.setup(definitions);
        }
        catch (WorkflowException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.notifier.invocationFailed(e.getMessage(), e);
            throw e;
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "The location of the WSDL has to be a valid URL or file path: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (WsdlException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error in processing the WSDL: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error in processing the WSDL: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    private void setup(WsdlDefinitions definitions) throws WorkflowException {
        WorkflowContextHeaderBuilder builder = this.contextHeader == null ? new WorkflowContextHeaderBuilder(this.notifier.getEventSink().getAddress(), this.gfacURL, null, this.topic, "xbaya-experiment", this.messageBoxURL) : new WorkflowContextHeaderBuilder(this.contextHeader);
        if (builder.getWorkflowMonitoringContext() == null) {
            builder.addWorkflowMonitoringContext(this.notifier.getEventSink().getAddress(), this.topic, this.nodeID, this.messageBoxURL);
        } else {
            builder.getWorkflowMonitoringContext().setWorkflowInstanceId(this.notifier.getWorkflowID().toASCIIString());
        }
        builder.getWorkflowMonitoringContext().setWorkflowNodeId(this.nodeID);
        builder.getWorkflowMonitoringContext().setServiceInstanceId(this.nodeID);
        builder.getWorkflowMonitoringContext().setWorkflowTimeStep(1);
        builder.setUserIdentifier("xbaya-user");
        StickySoapHeaderHandler handler = new StickySoapHeaderHandler("use-workflowcontext-header", builder.getXml());
        this.invoker = InvokerFactory.createInvoker(this.portTypeQName, definitions, this.gfacURL, this.messageBoxURL, builder, true);
        this.invoker.setup();
        WSIFClient client = this.invoker.getClient();
        client.addHandler((XHandler)handler);
        WsdlResolver resolver = WsdlResolver.getInstance();
        this.notifier.setServiceID(this.nodeID);
    }

    @Override
    public void setOperation(String operationName) throws WorkflowException {
        try {
            this.invoker.setOperation(operationName);
        }
        catch (WorkflowException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.notifier.invocationFailed(e.getMessage(), e);
            throw e;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "The WSDL does not conform to the invoking service: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public void setInput(String name, Object value) throws WorkflowException {
        try {
            if (value instanceof XmlElement) {
                logger.debug("value: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)value)));
            }
            this.inputNames.add(name);
            this.inputValues.add(value);
            this.invoker.setInput(name, value);
        }
        catch (WorkflowException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.notifier.invocationFailed(e.getMessage(), e);
            throw e;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error in setting an input. name: " + name + " value: " + value;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public synchronized boolean invoke() throws WorkflowException {
        try {
            WSIFMessage inputMessage = this.invoker.getInputs();
            logger.debug("inputMessage: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)inputMessage)));
            this.notifier.invokingService(inputMessage);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            this.result = executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        boolean success = GenericInvoker.this.invoker.invoke();
                        if (success) {
                            WSIFMessage outputMessage = GenericInvoker.this.invoker.getOutputs();
                            logger.debug("outputMessage: " + outputMessage);
                            GenericInvoker.this.notifier.serviceFinished(outputMessage);
                        } else {
                            WSIFMessage faultMessage = GenericInvoker.this.invoker.getOutputs();
                            logger.debug("received fault: " + faultMessage);
                            GenericInvoker.this.notifier.receivedFault(faultMessage);
                            GenericInvoker.this.failerSent = true;
                        }
                        return success;
                    }
                    catch (WorkflowException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        GenericInvoker.this.notifier.invocationFailed(e.getMessage(), e);
                        GenericInvoker.this.failerSent = true;
                        throw new WorkflowRuntimeException((Throwable)e);
                    }
                    catch (RuntimeException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        String message = "Error in invoking a service: " + GenericInvoker.this.serviceInformation;
                        GenericInvoker.this.notifier.invocationFailed(message, e);
                        GenericInvoker.this.failerSent = true;
                        throw e;
                    }
                }
            });
            executor.shutdown();
            this.notifyAll();
            try {
                this.result.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (TimeoutException e) {
                return true;
            }
            catch (ExecutionException e) {
                logger.error(e.getMessage(), (Throwable)e);
                String message = "Error in invoking a service: " + this.serviceInformation;
                throw new WorkflowException(message, (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error in invoking a service: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        return true;
    }

    public synchronized void waitToFinish() throws WorkflowException {
        try {
            while (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            Boolean success = this.result.get();
            if (!success.booleanValue()) {
                WSIFMessage faultMessage = this.invoker.getFault();
                String message = "Error in a service: ";
                message = message + faultMessage.toString();
                throw new WorkflowException(message);
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error in invoking a service: " + this.serviceInformation;
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error while waiting for a service to finish: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public Object getOutput(String name) throws WorkflowException {
        try {
            this.waitToFinish();
            Object output = this.invoker.getOutput(name);
            if (output instanceof XmlElement) {
                logger.debug("output: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)output)));
            }
            return output;
        }
        catch (WorkflowException e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (!this.failerSent) {
                this.notifier.invocationFailed(e.getMessage(), e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error while waiting for a output: " + name;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public WSIFMessage getOutputs() throws WorkflowException {
        return this.invoker.getOutputs();
    }

    @Override
    public WSIFClient getClient() {
        return null;
    }

    @Override
    public WSIFMessage getInputs() throws WorkflowException {
        return null;
    }

    @Override
    public WSIFMessage getFault() throws WorkflowException {
        return null;
    }
}

