/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker;

import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.airavata.common.workflow.execution.context.WorkflowContextHeaderBuilder;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.invoker.factory.InvokerFactory;
import org.apache.airavata.xbaya.lead.NotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xsul.lead.LeadContextHeader;
import xsul.wsdl.WsdlDefinitions;
import xsul.wsdl.WsdlResolver;
import xsul.wsif.WSIFMessage;
import xsul.xhandler.XHandler;
import xsul.xwsif_runtime.WSIFClient;

public class GFacInvoker
implements Invoker {
    private static final Logger logger = LoggerFactory.getLogger(GFacInvoker.class);
    private String gfacURL;
    private String messageBoxURL;
    private QName portTypeQName;
    private Invoker invoker;
    private LeadContextHeader leadContext;
    private WorkflowContextHeaderBuilder builder;

    public GFacInvoker(QName portTypeQName, String gfacURL, String messageBoxURL, LeadContextHeader context) {
        this.portTypeQName = portTypeQName;
        this.gfacURL = gfacURL;
        this.messageBoxURL = messageBoxURL;
        this.leadContext = context;
    }

    public GFacInvoker(QName portTypeQName, String gfacURL, String messageBoxURL, WorkflowContextHeaderBuilder context) {
        this.portTypeQName = portTypeQName;
        this.gfacURL = gfacURL;
        this.messageBoxURL = messageBoxURL;
        this.builder = context;
    }

    @Override
    public void setup() throws WorkflowException {
        if (this.gfacURL == null) {
            String message = "The location of the Generic Factory is not specified.";
            throw new WorkflowException(message);
        }
        if (this.portTypeQName == null) {
            String message = "Error in finding the service name";
            throw new WorkflowException(message);
        }
        try {
            URI uri = new URI(this.gfacURL);
            String gfacPath = uri.getPath();
            if (gfacPath != null && gfacPath.contains("/")) {
                gfacPath = gfacPath.substring(0, gfacPath.lastIndexOf(47) + 1) + this.portTypeQName.getLocalPart();
            }
            URI getWsdlURI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), gfacPath + "/getWSDL", uri.getQuery(), uri.getFragment());
            logger.debug("getWSDL service:" + getWsdlURI.toString());
            WsdlDefinitions concreteWSDL = WsdlResolver.getInstance().loadWsdl(getWsdlURI);
            this.invoker = InvokerFactory.createInvoker(this.portTypeQName, concreteWSDL, null, this.messageBoxURL, null, true);
            this.invoker.setup();
        }
        catch (WorkflowException xe) {
            throw xe;
        }
        catch (Exception e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public WSIFClient getClient() {
        return this.invoker.getClient();
    }

    @Override
    public void setOperation(String operationName) throws WorkflowException {
        this.invoker.setOperation(operationName);
    }

    @Override
    public void setInput(String name, Object value) throws WorkflowException {
        this.invoker.setInput(name, value);
    }

    @Override
    public WSIFMessage getInputs() throws WorkflowException {
        return this.invoker.getInputs();
    }

    @Override
    public boolean invoke() throws WorkflowException {
        WSIFClient client = this.invoker.getClient();
        NotificationHandler notificationHandler = new NotificationHandler(this.builder);
        client.addHandler((XHandler)notificationHandler);
        return this.invoker.invoke();
    }

    @Override
    public WSIFMessage getOutputs() throws WorkflowException {
        return this.invoker.getOutputs();
    }

    @Override
    public Object getOutput(String name) throws WorkflowException {
        return this.invoker.getOutput(name);
    }

    @Override
    public WSIFMessage getFault() throws WorkflowException {
        return this.invoker.getFault();
    }
}

