/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker;

import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.common.workflow.execution.context.WorkflowContextHeaderBuilder;
import org.apache.airavata.commons.gfac.type.ActualParameter;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.gfac.GFacAPI;
import org.apache.airavata.gfac.GFacConfiguration;
import org.apache.airavata.gfac.context.ApplicationContext;
import org.apache.airavata.gfac.context.JobExecutionContext;
import org.apache.airavata.gfac.context.MessageContext;
import org.apache.airavata.gfac.context.security.GSISecurityContext;
import org.apache.airavata.gfac.context.security.SSHSecurityContext;
import org.apache.airavata.gfac.context.security.SecurityContext;
import org.apache.airavata.gfac.scheduler.HostScheduler;
import org.apache.airavata.gfac.utils.GFacUtils;
import org.apache.airavata.registry.api.exception.RegistryException;
import org.apache.airavata.schemas.gfac.BooleanArrayType;
import org.apache.airavata.schemas.gfac.BooleanParameterType;
import org.apache.airavata.schemas.gfac.DoubleArrayType;
import org.apache.airavata.schemas.gfac.DoubleParameterType;
import org.apache.airavata.schemas.gfac.Ec2HostType;
import org.apache.airavata.schemas.gfac.FileArrayType;
import org.apache.airavata.schemas.gfac.FileParameterType;
import org.apache.airavata.schemas.gfac.FloatArrayType;
import org.apache.airavata.schemas.gfac.FloatParameterType;
import org.apache.airavata.schemas.gfac.GlobusHostType;
import org.apache.airavata.schemas.gfac.InputParameterType;
import org.apache.airavata.schemas.gfac.IntegerArrayType;
import org.apache.airavata.schemas.gfac.IntegerParameterType;
import org.apache.airavata.schemas.gfac.OutputParameterType;
import org.apache.airavata.schemas.gfac.Parameter;
import org.apache.airavata.schemas.gfac.SSHHostType;
import org.apache.airavata.schemas.gfac.ServiceDescriptionType;
import org.apache.airavata.schemas.gfac.StdErrParameterType;
import org.apache.airavata.schemas.gfac.StdOutParameterType;
import org.apache.airavata.schemas.gfac.StringArrayType;
import org.apache.airavata.schemas.gfac.StringParameterType;
import org.apache.airavata.schemas.gfac.URIArrayType;
import org.apache.airavata.schemas.gfac.URIParameterType;
import org.apache.airavata.schemas.gfac.UnicoreHostType;
import org.apache.airavata.schemas.wec.ContextHeaderDocument;
import org.apache.airavata.schemas.wec.SecurityContextDocument;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.jython.lib.ServiceNotifiable;
import org.apache.airavata.xbaya.jython.lib.WorkflowNotifiable;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import xsul.XmlConstants;
import xsul.wsdl.WsdlDefinitions;
import xsul.wsif.WSIFMessage;
import xsul.wsif.impl.WSIFMessageElement;
import xsul.xwsif_runtime.WSIFClient;

public class EmbeddedGFacInvoker
implements Invoker {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedGFacInvoker.class);
    private String nodeID;
    private QName portTypeQName;
    private String wsdlLocation;
    private String serviceInformation;
    private String messageBoxURL;
    private String gfacURL;
    private Invoker invoker;
    private XBayaConfiguration configuration;
    private Boolean result;
    private ServiceNotifiable notifier;
    private String topic;
    private String serviceName;
    private AiravataAPI airavataAPI;
    private List<Object> inputValues = new ArrayList<Object>();
    private List<String> inputNames = new ArrayList<String>();
    boolean failerSent;
    private WsdlDefinitions wsdlDefinitionObject;
    private Object outPut;
    Map<String, Object> actualParameters = new LinkedHashMap<String, Object>();

    public EmbeddedGFacInvoker(QName portTypeQName, String wsdlLocation, String nodeID, WorkflowNotifiable notifier) {
        this(portTypeQName, wsdlLocation, nodeID, null, notifier);
    }

    public EmbeddedGFacInvoker(QName portTypeQName, String wsdlLocation, String nodeID, String gfacURL, WorkflowNotifiable notifier) {
        this(portTypeQName, wsdlLocation, nodeID, null, gfacURL, notifier);
    }

    public EmbeddedGFacInvoker(QName portTypeQName, String wsdlLocation, String nodeID, String messageBoxURL, String gfacURL, WorkflowNotifiable notifier) {
        this.nodeID = nodeID;
        this.portTypeQName = portTypeQName;
        this.wsdlLocation = wsdlLocation;
        this.serviceInformation = wsdlLocation;
        this.messageBoxURL = messageBoxURL;
        this.gfacURL = gfacURL;
        this.notifier = notifier.createServiceNotificationSender(nodeID);
        this.failerSent = false;
    }

    public EmbeddedGFacInvoker(QName portTypeQName, WsdlDefinitions wsdl, String nodeID, String messageBoxURL, String gfacURL, WorkflowNotifiable notifier, String topic, AiravataAPI airavataAPI, String serviceName, XBayaConfiguration config) {
        String wsdlStr = XmlConstants.BUILDER.serializeToString((Object)wsdl);
        this.nodeID = nodeID;
        this.portTypeQName = portTypeQName;
        this.wsdlDefinitionObject = wsdl;
        this.messageBoxURL = messageBoxURL;
        this.serviceInformation = wsdlStr;
        this.gfacURL = gfacURL;
        this.notifier = notifier.createServiceNotificationSender(nodeID);
        this.airavataAPI = airavataAPI;
        this.topic = topic;
        this.serviceName = serviceName;
        this.failerSent = false;
        this.configuration = config;
    }

    @Override
    public void setup() throws WorkflowException {
        this.notifier.setServiceID(this.nodeID);
    }

    private void setup(WsdlDefinitions definitions) throws WorkflowException {
    }

    @Override
    public void setOperation(String operationName) throws WorkflowException {
    }

    @Override
    public void setInput(String name, Object value) throws WorkflowException {
        try {
            if (value instanceof XmlElement) {
                logger.debug("value: " + XMLUtil.xmlElementToString((XmlElement)((XmlElement)value)));
            }
            this.inputNames.add(name);
            this.inputValues.add(value);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error in setting an input. name: " + name + " value: " + value;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized boolean invoke() throws WorkflowException {
        try {
            HostDescription registeredHost;
            ContextHeaderDocument.ContextHeader contextHeader = WorkflowContextHeaderBuilder.removeOtherSchedulingConfig((String)this.nodeID, (ContextHeaderDocument.ContextHeader)this.configuration.getContextHeader());
            String hostName = null;
            if (contextHeader != null && contextHeader.getWorkflowSchedulingContext() != null && contextHeader.getWorkflowSchedulingContext().getApplicationSchedulingContextArray().length > 0 && contextHeader.getWorkflowSchedulingContext().getApplicationSchedulingContextArray(0).getHostName() != null) {
                hostName = contextHeader.getWorkflowSchedulingContext().getApplicationSchedulingContextArray(0).getHostName();
            }
            ServiceDescription serviceDescription = this.airavataAPI.getApplicationManager().getServiceDescription(this.serviceName);
            if (hostName == null) {
                ArrayList<HostDescription> registeredHosts = new ArrayList<HostDescription>();
                Map applicationDescriptors = this.airavataAPI.getApplicationManager().getApplicationDescriptors(this.serviceName);
                for (String hostDescName : applicationDescriptors.keySet()) {
                    registeredHosts.add(this.airavataAPI.getApplicationManager().getHostDescription(hostDescName));
                }
                Class<HostScheduler> aClass = Class.forName(ServerSettings.getHostScheduler()).asSubclass(HostScheduler.class);
                HostScheduler hostScheduler = aClass.newInstance();
                registeredHost = hostScheduler.schedule(registeredHosts);
            } else {
                registeredHost = this.airavataAPI.getApplicationManager().getHostDescription(hostName);
            }
            ApplicationDescription applicationDescription = this.airavataAPI.getApplicationManager().getApplicationDescription(this.serviceName, registeredHost.getType().getHostName());
            URL resource = EmbeddedGFacInvoker.class.getClassLoader().getResource("gfac-config.xml");
            OMElement inputMessage = this.getInParameters();
            WSIFMessageElement wsifMessageElement = new WSIFMessageElement(XMLUtil.stringToXmlElement3((String)inputMessage.toStringWithConsume()));
            this.notifier.invokingService((WSIFMessage)new WSIFMessageElement((XmlElement)wsifMessageElement));
            Properties configurationProperties = ServerSettings.getProperties();
            GFacConfiguration gFacConfiguration = GFacConfiguration.create((File)new File(resource.getPath()), (AiravataAPI)this.airavataAPI, (Properties)configurationProperties);
            JobExecutionContext jobExecutionContext = new JobExecutionContext(gFacConfiguration, this.serviceName);
            this.addSecurityContext(registeredHost, configurationProperties, jobExecutionContext, this.configuration.getContextHeader());
            jobExecutionContext.setContextHeader(WorkflowContextHeaderBuilder.removeOtherSchedulingConfig((String)this.nodeID, (ContextHeaderDocument.ContextHeader)this.configuration.getContextHeader()));
            jobExecutionContext.setProperty("workflow.node.id", (Object)this.nodeID);
            jobExecutionContext.setProperty("topic", (Object)this.configuration.getTopic());
            jobExecutionContext.setProperty("broker.url", (Object)this.configuration.getBrokerURL().toASCIIString());
            jobExecutionContext.setProperty("workflow.instance.id", (Object)this.configuration.getTopic());
            ApplicationContext applicationContext = new ApplicationContext();
            applicationContext.setApplicationDeploymentDescription(applicationDescription);
            applicationContext.setHostDescription(registeredHost);
            applicationContext.setServiceDescription(serviceDescription);
            jobExecutionContext.setApplicationContext(applicationContext);
            jobExecutionContext.setOutMessageContext(this.getOutParameters(serviceDescription));
            jobExecutionContext.setInMessageContext(new MessageContext(this.actualParameters));
            GFacAPI gfacAPI1 = new GFacAPI();
            gfacAPI1.submitJob(jobExecutionContext);
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace("http://ws.apache.org/axis2/xsd", "ns1");
            OMElement outputElement = fac.createOMElement("invokeResponse", omNs);
            MessageContext outMessageContext = jobExecutionContext.getOutMessageContext();
            Set paramNames = outMessageContext.getParameters().keySet();
            for (String paramName : paramNames) {
                String outputString = ((ActualParameter)outMessageContext.getParameter(paramName)).toXML().replaceAll("GFacParameter", paramName);
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(outputString));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                outputElement.addChild((OMNode)builder.getDocumentElement());
            }
            logger.debug("outputMessage: " + outputElement.toString());
            this.outPut = new WSIFMessageElement(XMLUtil.stringToXmlElement3((String)outputElement.toStringWithConsume()));
            this.result = true;
            this.notifier.serviceFinished((WSIFMessage)new WSIFMessageElement((XmlElement)this.outPut));
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error in invoking a service: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Exception e) {
            this.notifier.invocationFailed(e.getMessage(), e);
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private SecurityContextDocument.SecurityContext.CredentialManagementService getCredentialManagementService(ContextHeaderDocument.ContextHeader contextHeader) {
        if (contextHeader != null) {
            SecurityContextDocument.SecurityContext.CredentialManagementService credentialManagementService = contextHeader.getSecurityContext().getCredentialManagementService();
            if (credentialManagementService != null) {
                if (credentialManagementService.getTokenId() != null && credentialManagementService.getPortalUser() != null) {
                    return credentialManagementService;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private void addSecurityContext(HostDescription registeredHost, Properties configurationProperties, JobExecutionContext jobExecutionContext, ContextHeaderDocument.ContextHeader contextHeader) {
        if (registeredHost.getType() instanceof GlobusHostType || registeredHost.getType() instanceof UnicoreHostType) {
            GSISecurityContext context;
            SecurityContextDocument.SecurityContext.CredentialManagementService credentialManagementService = this.getCredentialManagementService(contextHeader);
            if (credentialManagementService != null) {
                String tokenId = credentialManagementService.getTokenId();
                String gatewayUser = credentialManagementService.getPortalUser();
                String gatewayId = jobExecutionContext.getGFacConfiguration().getAiravataAPI().getGateway();
                context = new GSISecurityContext(configurationProperties, tokenId, gatewayId, gatewayUser);
            } else {
                context = new GSISecurityContext(configurationProperties);
            }
            jobExecutionContext.addSecurityContext("gsi", (SecurityContext)context);
        } else if (registeredHost.getType() instanceof Ec2HostType) {
            if (this.configuration.getAmazonSecurityContext() != null) {
                jobExecutionContext.addSecurityContext("amazon", (SecurityContext)this.configuration.getAmazonSecurityContext());
            }
        } else if (registeredHost.getType() instanceof SSHHostType) {
            SSHSecurityContext context = new SSHSecurityContext();
            context.setUsername(configurationProperties.getProperty("ssh.username"));
            context.setPrivateKeyLoc(configurationProperties.getProperty("ssh.key"));
            context.setKeyPass(configurationProperties.getProperty("ssh.keypass"));
            jobExecutionContext.addSecurityContext("ssh", (SecurityContext)context);
        }
    }

    public synchronized void waitToFinish() throws WorkflowException {
        try {
            while (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            Boolean success = this.result;
            if (!success.booleanValue()) {
                WSIFMessage faultMessage = this.invoker.getFault();
                String message = "Error in a service: ";
                message = message + faultMessage.toString();
                throw new WorkflowException(message);
            }
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error while waiting for a service to finish: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public Object getOutput(String name) throws WorkflowException {
        try {
            this.waitToFinish();
            if (this.outPut instanceof XmlElement) {
                return ((XmlElement)((XmlElement)((XmlElement)this.outPut).children().next()).children().next()).children().next();
            }
            return this.outPut;
        }
        catch (WorkflowException e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (!this.failerSent) {
                this.notifier.invocationFailed(e.getMessage(), e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Error while waiting for a output: " + name;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            String message = "Unexpected error: " + this.serviceInformation;
            this.notifier.invocationFailed(message, e);
            throw new WorkflowException(message, (Throwable)e);
        }
    }

    @Override
    public WSIFMessage getOutputs() throws WorkflowException {
        return this.invoker.getOutputs();
    }

    @Override
    public WSIFClient getClient() {
        return null;
    }

    @Override
    public WSIFMessage getInputs() throws WorkflowException {
        return null;
    }

    @Override
    public WSIFMessage getFault() throws WorkflowException {
        return null;
    }

    private OMElement getInParameters() throws AiravataAPIInvocationException, RegistryException, XMLStreamException {
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement invoke_inputParams = omFactory.createOMElement(new QName("invoke_InputParams"));
        ServiceDescription serviceDescription = this.airavataAPI.getApplicationManager().getServiceDescription(this.serviceName);
        if (serviceDescription == null) {
            throw new RegistryException((Throwable)new Exception("Service Description not found in registry."));
        }
        ServiceDescriptionType serviceDescriptionType = serviceDescription.getType();
        for (String inputName : this.inputNames) {
            OMElement omElement = omFactory.createOMElement(new QName(inputName));
            int index = this.inputNames.indexOf(inputName);
            Object value = this.inputValues.get(index);
            InputParameterType parameter = serviceDescriptionType.getInputParametersArray(index);
            if (value instanceof XmlElement) {
                omElement.setText((String)((XmlElement)((XmlElement)((XmlElement)value).children().next()).children().next()).children().next());
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(XMLUtil.xmlElementToString((XmlElement)((XmlElement)value))));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                OMElement input = builder.getDocumentElement();
                this.actualParameters.put(parameter.getParameterName(), GFacUtils.getInputActualParameter((Parameter)parameter, (OMElement)input));
            } else if (value instanceof String) {
                omElement.setText((String)value);
                this.actualParameters.put(parameter.getParameterName(), GFacUtils.getInputActualParameter((Parameter)parameter, (OMElement)AXIOMUtil.stringToOM((String)("<value>" + value + "</value>"))));
            }
            invoke_inputParams.addChild((OMNode)omElement);
        }
        return invoke_inputParams;
    }

    private MessageContext getOutParameters(ServiceDescription serviceDescription) {
        MessageContext outContext = new MessageContext();
        for (OutputParameterType parameter : serviceDescription.getType().getOutputParametersArray()) {
            ActualParameter actualParameter = new ActualParameter();
            if ("String".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(StringParameterType.type);
            } else if ("Double".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(DoubleParameterType.type);
            } else if ("Integer".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(IntegerParameterType.type);
            } else if ("Float".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(FloatParameterType.type);
            } else if ("Boolean".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(BooleanParameterType.type);
            } else if ("File".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(FileParameterType.type);
            } else if ("URI".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(URIParameterType.type);
            } else if ("StringArray".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(StringArrayType.type);
            } else if ("DoubleArray".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(DoubleArrayType.type);
            } else if ("IntegerArray".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(IntegerArrayType.type);
            } else if ("FloatArray".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(FloatArrayType.type);
            } else if ("BooleanArray".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(BooleanArrayType.type);
            } else if ("FileArray".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(FileArrayType.type);
            } else if ("URIArray".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(URIArrayType.type);
            } else if ("StdOut".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(StdOutParameterType.type);
            } else if ("StdErr".equals(parameter.getParameterType().getName())) {
                actualParameter.getType().changeType(StdErrParameterType.type);
            }
            outContext.addParameter(parameter.getParameterName(), (Object)actualParameter);
        }
        return outContext;
    }
}

