/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker;

import java.io.File;
import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.invoker.factory.InvokerFactory;
import xsul.wsdl.WsdlDefinitions;
import xsul.wsdl.WsdlResolver;

public class DynamicServiceCreator {
    private String dynamicFactoryWSDLLocation;
    private static String classStr = "package org.apache.airavata.xbaya;public class DefaultClassName{public int operationName(String[] stringArray0){return 8;}}";

    public DynamicServiceCreator(String dynamicFactoryWSDLLocation) {
        this.dynamicFactoryWSDLLocation = dynamicFactoryWSDLLocation;
    }

    public void createService(String code) throws WorkflowException {
        try {
            WsdlDefinitions definitions = null;
            if (this.dynamicFactoryWSDLLocation != null && !this.dynamicFactoryWSDLLocation.equals("")) {
                definitions = WsdlResolver.getInstance().loadWsdl(new File(".").toURI(), new URI(this.dynamicFactoryWSDLLocation));
            }
            Invoker invoker = InvokerFactory.createInvoker(new QName("http://extreme.indiana.edu", "ServiceCreatorPortType"), definitions, null, null, null);
            invoker.setup();
            invoker.setOperation("deployServiceFromClass");
            invoker.setInput("classAsString", code);
            invoker.invoke();
            invoker.getOutput("return");
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public static void main(String[] args) throws WorkflowException {
        DynamicServiceCreator c = new DynamicServiceCreator("http://127.0.0.1:8080/axis2/services/ServiceCreator?wsdl");
        c.createService(classStr);
    }
}

