/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.invoker.Invoker;
import xsul.wsif.WSIFMessage;
import xsul.xwsif_runtime.WSIFClient;

public class DynamicInvoker
implements Invoker {
    private URL jarUrl;
    private String className;
    private String operationName;
    private Object[] inputs;
    private Object result;

    public DynamicInvoker(String className, URL jarUrl, String operationName, Object[] inputs) {
        this.className = className;
        this.jarUrl = jarUrl;
        this.operationName = operationName;
        this.inputs = inputs;
    }

    @Override
    public Object getOutput(String name) throws WorkflowException {
        this.waitToFinish();
        return this.result;
    }

    @Override
    public boolean invoke() throws WorkflowException {
        try {
            Class<?> targetClass = Class.forName(this.className);
            Object obj = targetClass.newInstance();
            Method[] methods = targetClass.getDeclaredMethods();
            Method targetMethod = null;
            for (Method method : methods) {
                if (!this.operationName.equals(method.getName())) continue;
                targetMethod = method;
                break;
            }
            if (targetMethod == null) {
                throw new WorkflowException("Could not find the method using reflection: " + this.operationName);
            }
            targetMethod.setAccessible(true);
            this.result = targetMethod.invoke(obj, this.inputs);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
        return true;
    }

    @Override
    public void setInput(String name, Object value) throws WorkflowException {
    }

    @Override
    public void setOperation(String operationName) throws WorkflowException {
        this.operationName = operationName;
    }

    @Override
    public void setup() throws WorkflowException {
        Class[] parameters = new Class[]{URL.class};
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, this.jarUrl);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new WorkflowException("Error, could not add URL to system classloader");
        }
    }

    public void waitToFinish() throws WorkflowException {
        while (this.result == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public WSIFMessage getOutputs() throws WorkflowException {
        this.waitToFinish();
        return (WSIFMessage)this.result;
    }

    @Override
    public WSIFClient getClient() {
        return null;
    }

    @Override
    public WSIFMessage getInputs() throws WorkflowException {
        return null;
    }

    @Override
    public WSIFMessage getFault() throws WorkflowException {
        return null;
    }
}

