/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.invoker;

import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.invoker.MsgBoxWsaResponsesCorrelator;
import org.apache.airavata.xbaya.invoker.SimpleInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xsul.wsdl.WsdlDefinitions;
import xsul.wsif.WSIFMessage;
import xsul.wsif.WSIFOperation;
import xsul.xwsif_runtime_async.WSIFAsyncResponsesCorrelator;
import xsul.xwsif_runtime_async_http.XsulSoapHttpWsaResponsesCorrelator;

public class AsynchronousInvoker
extends SimpleInvoker {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousInvoker.class);
    private String messageBoxURL;

    public AsynchronousInvoker(WsdlDefinitions definitions) {
        this(definitions, null);
    }

    public AsynchronousInvoker(WsdlDefinitions definitions, String messageBoxURL) {
        super(definitions);
        this.messageBoxURL = messageBoxURL;
    }

    @Override
    public void setup() throws WorkflowException {
        Object correlator;
        super.setup();
        if (this.messageBoxURL == null || this.messageBoxURL.length() == 0) {
            correlator = new XsulSoapHttpWsaResponsesCorrelator();
            String serverLoc = correlator.getServerLocation();
            logger.debug("using async correlator at " + serverLoc);
        } else {
            correlator = new MsgBoxWsaResponsesCorrelator(this.messageBoxURL, this);
            logger.debug("using message box at " + this.messageBoxURL);
        }
        this.client.useAsyncMessaging((WSIFAsyncResponsesCorrelator)correlator);
    }

    @Override
    public boolean invoke() throws WorkflowException {
        final WSIFOperation operation = this.getOperation();
        final WSIFMessage inputMessage = this.getInputMessage();
        this.setOutputMessage(null);
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        operation.executeInputOnlyOperation(inputMessage);
                    }
                    catch (Exception e) {
                        logger.error("Error invoking GFac Service", (Throwable)e);
                    }
                }
            }.start();
            while (this.getOutputMessage() == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.error("Error Waiting for the response from backend");
                }
            }
            return !"ErrorResponse".equals(XMLUtil.stringToXmlElement3((String)this.getOutputMessage().toString()).getName());
        }
        catch (RuntimeException e) {
            String message = "Error in invoking a service.";
            throw new WorkflowException(message, (Throwable)e);
        }
    }
}

