/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.interpretor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.airavata.client.AiravataAPIFactory;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.client.api.exception.DescriptorAlreadyExistsException;
import org.apache.airavata.client.stub.interpretor.NameValue;
import org.apache.airavata.client.tools.PeriodicExecutorThread;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ServiceUtils;
import org.apache.airavata.common.workflow.execution.context.WorkflowContextHeaderBuilder;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.registry.api.exception.RegistryException;
import org.apache.airavata.schemas.gfac.GlobusHostType;
import org.apache.airavata.schemas.gfac.HostDescriptionType;
import org.apache.airavata.schemas.wec.ContextHeaderDocument;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.ode.ODEClient;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.MonitorException;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaConstants;
import org.apache.airavata.xbaya.concurrent.PredicatedTaskRunner;
import org.apache.airavata.xbaya.interpretor.SSWorkflowInterpreterInteractorImpl;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreter;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreterConfiguration;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpretorEventListener;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowInterpretorSkeleton
implements ServiceLifeCycle {
    private static final Logger log = LoggerFactory.getLogger(WorkflowInterpretorSkeleton.class);
    public static final String MSGBOX = "msgbox";
    public static final String GFAC = "gfac";
    public static final String BROKER = "broker";
    public static final String MYPROXY_USER = "myproxy.user";
    public static final String MYPROXY_PASS = "myproxy.pass";
    public static final String MYPROXY_SERVER = "myproxy.server";
    public static final String MYPROXY_LIFETIME = "myproxy.life";
    public static final String TRUSTED_CERT_LOCATION = "trusted.cert.location";
    public static boolean provenance = false;
    public static final String PROVENANCE = "provenance";
    public static String systemUserName = "";
    public static String systemUserPW = "";
    public static boolean runInThread = false;
    public static final String RUN_IN_THREAD = "runInThread";
    public static Boolean gfacEmbeddedMode = false;
    private static PredicatedTaskRunner runner = null;
    private static AiravataAPI airavataAPI = null;
    public static int provenanceWriterThreadPoolSize = 1;
    public static final String PROVENANCE_WRITER_THREAD_POOL_SIZE = "provenanceWriterThreadPoolSize";
    public static final int JCR_AVAIALABILITY_WAIT_INTERVAL = 10000;
    public static final String GFAC_EMBEDDED = "gfac.embedded";
    public static ConfigurationContext configurationContext;
    public static final String SERVICE_NAME = "WorkflowInterpretor";
    public static boolean notInterrupted;
    private String gateway;
    protected static final String SERVICE_URL = "interpreter_service_url";
    protected static final String JCR_REG = "jcr_registry";
    protected WIServiceThread thread;
    public static final int URL_UPDATE_INTERVAL = 10800000;

    private AiravataAPI getAiravataAPI() {
        if (airavataAPI == null) {
            try {
                systemUserName = ServerSettings.getSystemUser();
                systemUserPW = ServerSettings.getSystemUserPassword();
                this.gateway = ServerSettings.getSystemUserGateway();
                airavataAPI = AiravataAPIFactory.getAPI((String)this.gateway, (String)systemUserName);
            }
            catch (ApplicationSettingsException e) {
                log.error("Unable to read the properties file", (Throwable)e);
            }
            catch (AiravataAPIInvocationException e) {
                log.error("Unable to create Airavata API", (Throwable)e);
            }
        }
        return airavataAPI;
    }

    public void startUp(final ConfigurationContext configctx, AxisService service) {
        AiravataUtils.setExecutionAsServer();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                try {
                    configctx.setProperty(WorkflowInterpretorSkeleton.MYPROXY_PASS, (Object)ServerSettings.getSetting((String)WorkflowInterpretorSkeleton.MYPROXY_PASS));
                    configctx.setProperty(WorkflowInterpretorSkeleton.MYPROXY_USER, (Object)ServerSettings.getSetting((String)WorkflowInterpretorSkeleton.MYPROXY_USER));
                    configctx.setProperty(WorkflowInterpretorSkeleton.MYPROXY_LIFETIME, (Object)ServerSettings.getSetting((String)WorkflowInterpretorSkeleton.MYPROXY_LIFETIME));
                    configctx.setProperty(WorkflowInterpretorSkeleton.TRUSTED_CERT_LOCATION, (Object)ServerSettings.getSetting((String)WorkflowInterpretorSkeleton.TRUSTED_CERT_LOCATION));
                    configctx.setProperty(WorkflowInterpretorSkeleton.MYPROXY_SERVER, (Object)ServerSettings.getSetting((String)WorkflowInterpretorSkeleton.MYPROXY_SERVER));
                    provenanceWriterThreadPoolSize = Integer.parseInt(ServerSettings.getSetting((String)WorkflowInterpretorSkeleton.PROVENANCE_WRITER_THREAD_POOL_SIZE));
                    if ("true".equals(ServerSettings.getSetting((String)WorkflowInterpretorSkeleton.PROVENANCE))) {
                        provenance = true;
                        runner = new PredicatedTaskRunner(provenanceWriterThreadPoolSize);
                        try {
                            List hostList = WorkflowInterpretorSkeleton.this.getDefinedHostDescriptions();
                            for (HostDescription host : hostList) {
                                AiravataAPI registry = WorkflowInterpretorSkeleton.this.getAiravataAPI();
                                if (registry.getApplicationManager().isHostDescriptorExists(host.getType().getHostName())) continue;
                                log.debug("Saving the predefined Host: " + host.getType().getHostName());
                                registry.getApplicationManager().addHostDescription(host);
                            }
                        }
                        catch (DescriptorAlreadyExistsException e) {
                            e.printStackTrace();
                        }
                        catch (AiravataAPIInvocationException e) {
                            e.printStackTrace();
                        }
                    } else {
                        provenance = false;
                    }
                    runInThread = "true".equals(ServerSettings.getSetting((String)WorkflowInterpretorSkeleton.RUN_IN_THREAD));
                    gfacEmbeddedMode = "true".equals(ServerSettings.getSetting((String)WorkflowInterpretorSkeleton.GFAC_EMBEDDED)) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    String localAddress = ServiceUtils.generateServiceURLFromConfigurationContext((ConfigurationContext)configctx, (String)WorkflowInterpretorSkeleton.SERVICE_NAME);
                    configctx.setProperty(WorkflowInterpretorSkeleton.SERVICE_URL, (Object)new URI(localAddress));
                    configctx.setProperty(WorkflowInterpretorSkeleton.JCR_REG, (Object)WorkflowInterpretorSkeleton.this.getAiravataAPI());
                    WorkflowInterpretorSkeleton.this.thread = new WIServiceThread(WorkflowInterpretorSkeleton.this.getAiravataAPI(), configctx);
                    WorkflowInterpretorSkeleton.this.thread.start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                catch (ApplicationSettingsException e) {
                    e.printStackTrace();
                }
                configurationContext = configctx;
            }
        }.start();
    }

    public String launchWorkflow(String workflowAsString, String topic, NameValue[] inputs) throws XMLStreamException {
        OMElement workflowContext = this.getWorkflowContextHeader();
        if (workflowContext == null) {
            workflowContext = AXIOMUtil.stringToOM((String)"<wor:context-header xmlns:wor=\"http://airavata.apache.org/schemas/wec/2012/05\">\n    <wor:soa-service-eprs>\n        <wor:gfac-url></wor:gfac-url>\n        <wor:registry-url></wor:registry-url>\n    </wor:soa-service-eprs>\n    <wor:workflow-monitoring-context>\n        <wor:experiment-id></wor:experiment-id>\n        <wor:workflow-instance-id xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=\"true\" />\n        <wor:event-publish-epr></wor:event-publish-epr>\n        <wor:msg-box-epr></wor:msg-box-epr>\n    </wor:workflow-monitoring-context>\n    <wor:workflow-scheduling-context />\n    <wor:security-context />\n</wor:context-header>");
        }
        HashMap<String, String> configuration = new HashMap<String, String>();
        WorkflowContextHeaderBuilder workflowContextHeaderBuilder = this.parseContextHeader(workflowContext, configuration);
        String user = workflowContextHeaderBuilder.getUserIdentifier();
        String s = null;
        try {
            s = this.setupAndLaunch(workflowAsString, topic, ServerSettings.getDefaultGatewayId(), user, inputs, configuration, runInThread, workflowContextHeaderBuilder);
        }
        catch (XMLStreamException e) {
            log.error(e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage());
        }
        catch (RegistryException e) {
            log.error(e.getMessage());
        }
        catch (AiravataAPIInvocationException e) {
            log.error(e.getMessage());
        }
        catch (ApplicationSettingsException e) {
            log.error(e.getMessage());
        }
        return s;
    }

    private OMElement getWorkflowContextHeader() {
        MessageContext currentMessageContext = MessageContext.getCurrentMessageContext();
        SOAPHeader header = currentMessageContext.getEnvelope().getHeader();
        Iterator childrenWithName = header.getChildrenWithName(new QName("http://airavata.apache.org/schemas/wec/2012/05", "context-header"));
        if (childrenWithName.hasNext()) {
            return (OMElement)childrenWithName.next();
        }
        return null;
    }

    private WorkflowContextHeaderBuilder parseContextHeader(OMElement workflowContext, Map<String, String> configuration) throws XMLStreamException {
        ContextHeaderDocument parse = null;
        try {
            String msgBroker;
            parse = ContextHeaderDocument.Factory.parse((String)workflowContext.toStringWithConsume());
            String msgBox = parse.getContextHeader().getWorkflowMonitoringContext().getMsgBoxEpr();
            if (msgBox == null || "".equals(msgBox)) {
                msgBox = this.getAiravataAPI().getAiravataManager().getMessageBoxServiceURL().toASCIIString();
            }
            if ((msgBroker = parse.getContextHeader().getWorkflowMonitoringContext().getEventPublishEpr()) == null || "".equals(msgBroker)) {
                msgBroker = this.getAiravataAPI().getAiravataManager().getEventingServiceURL().toASCIIString();
            }
            String gfac = parse.getContextHeader().getSoaServiceEprs().getGfacUrl();
            configuration.put(BROKER, msgBroker);
            configuration.put(GFAC, gfac);
            configuration.put(MSGBOX, msgBox);
        }
        catch (XmlException e) {
            log.error(e.getMessage());
        }
        catch (AiravataAPIInvocationException e) {
            log.error(e.getMessage());
        }
        return new WorkflowContextHeaderBuilder(parse.getContextHeader());
    }

    private String setupAndLaunch(String workflowAsString, String topic, String gatewayId, String username, NameValue[] inputs, Map<String, String> configurations, boolean inNewThread, WorkflowContextHeaderBuilder builder) throws XMLStreamException, MalformedURLException, RepositoryException, RegistryException, AiravataAPIInvocationException {
        log.debug("Launch is called for topic:" + topic);
        Workflow workflow = null;
        try {
            workflow = new Workflow(workflowAsString);
            log.debug("Workflow Object created");
        }
        catch (GraphException e1) {
            e1.printStackTrace();
        }
        catch (ComponentException e1) {
            e1.printStackTrace();
        }
        log.debug("Setting Input values");
        List inputNodes = new ODEClient().getInputNodes(workflow);
        for (InputNode inputNode : inputNodes) {
            for (NameValue input : inputs) {
                if (!inputNode.getName().equals(input.getName())) continue;
                inputNode.setDefaultValue((Object)input.getValue());
                break;
            }
            if (inputNode.getDefaultValue() != null) continue;
            throw new WorkflowRuntimeException("Could not find a input value for component with name :" + inputNode.getName());
        }
        log.debug("Input all set");
        XBayaConfiguration conf = null;
        try {
            conf = this.getConfiguration(configurations);
            conf.setTopic(topic);
            conf.setRunWithCrossProduct(true);
        }
        catch (URISyntaxException e1) {
            throw new WorkflowRuntimeException((Throwable)e1);
        }
        WorkflowInterpretorEventListener listener = null;
        WorkflowInterpreter interpreter = null;
        AiravataAPI airavataAPI = AiravataAPIFactory.getAPI((String)gatewayId, (String)username);
        WorkflowInterpreterConfiguration workflowInterpreterConfiguration = new WorkflowInterpreterConfiguration(workflow, topic, conf.getMessageBoxURL(), conf.getBrokerURL(), airavataAPI, conf, null, null);
        workflowInterpreterConfiguration.setGfacEmbeddedMode(gfacEmbeddedMode);
        workflowInterpreterConfiguration.setActOnProvenance(provenance);
        if (builder.getSecurityContext().getAmazonWebservices() != null) {
            workflowInterpreterConfiguration.setAwsSecretKey(builder.getSecurityContext().getAmazonWebservices().getSecretAccessKey());
            workflowInterpreterConfiguration.setAwsAccessKey(builder.getSecurityContext().getAmazonWebservices().getAccessKeyId());
        }
        interpreter = new WorkflowInterpreter(workflowInterpreterConfiguration, new SSWorkflowInterpreterInteractorImpl());
        listener = new WorkflowInterpretorEventListener(workflow, conf);
        try {
            log.debug("start listener set");
            listener.start();
        }
        catch (MonitorException e1) {
            e1.printStackTrace();
        }
        WorkflowContextHeaderBuilder.setCurrentContextHeader((ContextHeaderDocument.ContextHeader)builder.getContextHeader());
        WorkflowInterpretorEventListener finalListener = listener;
        conf.setAiravataAPI(this.getAiravataAPI());
        WorkflowInterpreter finalInterpreter = interpreter;
        interpreter.setProvenanceWriter(runner);
        String experimentId = topic;
        log.debug("Created the interpreter");
        if (inNewThread) {
            this.runInThread(finalInterpreter, finalListener, experimentId, builder);
        } else {
            this.executeWorkflow(finalInterpreter, finalListener, experimentId);
        }
        log.info("Experiment launched :" + topic);
        return topic;
    }

    private void runInThread(final WorkflowInterpreter interpreter, final WorkflowInterpretorEventListener listener, final String experimentId, final WorkflowContextHeaderBuilder builder) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WorkflowContextHeaderBuilder.setCurrentContextHeader((ContextHeaderDocument.ContextHeader)builder.getContextHeader());
                WorkflowInterpretorSkeleton.this.executeWorkflow(interpreter, listener, experimentId);
            }
        }).start();
    }

    private void executeWorkflow(WorkflowInterpreter interpreter, WorkflowInterpretorEventListener listener, String experimentId) {
        try {
            interpreter.scheduleDynamically();
            log.debug("Interpreter invoked...");
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public XBayaConfiguration getConfiguration(Map<String, String> vals) throws URISyntaxException {
        XBayaConfiguration configuration = new XBayaConfiguration();
        configuration.setBrokerURL(new URI(this.findValue(vals, BROKER, XBayaConstants.DEFAULT_BROKER_URL.toString())));
        configuration.setGFacURL(new URI(this.findValue(vals, GFAC, XBayaConstants.DEFAULT_GFAC_URL.toString())));
        configuration.setMessageBoxURL(new URI(this.findValue(vals, MSGBOX, XBayaConstants.DEFAULT_MESSAGE_BOX_URL.toString())));
        configuration.setMyProxyLifetime(3600);
        configuration.setMyProxyPort(7512);
        if (configurationContext != null) {
            configuration.setMyProxyServer(this.findValue(vals, MYPROXY_SERVER, (String)configurationContext.getProperty(MYPROXY_SERVER)));
            configuration.setMyProxyPassphrase(this.findValue(vals, MYPROXY_PASS, (String)configurationContext.getProperty(MYPROXY_PASS)));
            configuration.setMyProxyUsername(this.findValue(vals, MYPROXY_USER, (String)configurationContext.getProperty(MYPROXY_USER)));
            configuration.setTrustedCertLocation(this.findValue(vals, TRUSTED_CERT_LOCATION, (String)configurationContext.getProperty(TRUSTED_CERT_LOCATION)));
            configuration.setTrustedCertLocation(this.findValue(vals, MYPROXY_LIFETIME, (String)configurationContext.getProperty(MYPROXY_LIFETIME)));
        }
        return configuration;
    }

    public String findValue(Map<String, String> vals, String key, String defaultVal) {
        if (vals.get(key) != null) {
            return vals.get(key);
        }
        return defaultVal;
    }

    public void shutDown(ConfigurationContext configctx, AxisService service) {
        URI gfacURL = (URI)configctx.getProperty(SERVICE_URL);
        if (this.getAiravataAPI() != null && this.thread != null) {
            AiravataAPI registry = this.getAiravataAPI();
            try {
                registry.getAiravataManager().removeWorkflowInterpreterURI(gfacURL);
            }
            catch (AiravataAPIInvocationException e) {
                e.printStackTrace();
            }
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                log.warn("GFacURL update thread is interrupted");
            }
        }
        if (runner != null) {
            runner.shutDown();
        }
        notInterrupted = false;
    }

    private List<HostDescription> getDefinedHostDescriptions() {
        URL url = this.getClass().getClassLoader().getResource("host.xml");
        ArrayList<HostDescription> hostDescriptions = new ArrayList<HostDescription>();
        XMLStreamReader reader = null;
        try {
            if (url == null) {
                throw new RuntimeException("Error retrieving host.xml file. Should reside in $SERVER_HOME/webapps/axis2/WEB-INF/classes/host.xml");
            }
            reader = XMLInputFactory.newInstance().createXMLStreamReader(url.openStream());
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement documentElement = builder.getDocumentElement();
        Iterator server = documentElement.getChildrenWithName(new QName("server"));
        while (server.hasNext()) {
            HostDescription hostDescription;
            OMElement next = (OMElement)server.next();
            if (next.getFirstChildWithName(new QName("gram.endpoint")) != null) {
                hostDescription = new HostDescription(GlobusHostType.type);
                ((GlobusHostType)hostDescription.getType()).addGlobusGateKeeperEndPoint(next.getFirstChildWithName(new QName("gram.endpoint")).getText());
                ((GlobusHostType)hostDescription.getType()).addGridFTPEndPoint(next.getFirstChildWithName(new QName("gridftp.endpoint")).getText());
            } else {
                hostDescription = new HostDescription(HostDescriptionType.type);
            }
            hostDescription.getType().setHostName(next.getFirstChildWithName(new QName("name")).getText());
            hostDescription.getType().setHostAddress(next.getFirstChildWithName(new QName("host")).getText());
            hostDescriptions.add(hostDescription);
        }
        return hostDescriptions;
    }

    static {
        notInterrupted = true;
    }

    class WIServiceThread
    extends PeriodicExecutorThread {
        private ConfigurationContext context;

        WIServiceThread(AiravataAPI registry, ConfigurationContext context) {
            super(registry);
            this.context = null;
            this.context = context;
        }

        protected void updateRegistry(AiravataAPI registry) throws Exception {
            URI localAddress = (URI)this.context.getProperty(WorkflowInterpretorSkeleton.SERVICE_URL);
            registry.getAiravataManager().addWorkflowInterpreterURI(localAddress);
            log.debug("Updated Workflow Interpreter service URL in to Repository");
        }
    }
}

