/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.interpretor;

import java.net.URI;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.Monitor;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.interpretor.StandaloneNotificationSender;
import org.apache.airavata.xbaya.jython.lib.NotificationSender;
import org.apache.airavata.xbaya.jython.lib.WorkflowNotifiable;
import org.apache.airavata.xbaya.ui.XBayaGUI;

public class WorkflowInterpreterConfiguration {
    private URI messageBoxURL;
    private URI messageBrokerURL;
    private AiravataAPI registry;
    private XBayaConfiguration configuration;
    private XBayaGUI gui;
    private Monitor monitor;
    private boolean offline = false;
    private boolean runWithCrossProduct = false;
    private Workflow workflow;
    private WorkflowNotifiable notifier;
    private String topic;
    private boolean gfacEmbeddedMode = false;
    private Boolean actOnProvenance = null;
    private boolean subWorkflow;
    private boolean testMode = false;
    private AiravataAPI airavataAPI;
    private String awsAccessKey;
    private String awsSecretKey;

    public WorkflowInterpreterConfiguration(Workflow workflow, String topic, URI messageBoxURL, URI messageBrokerURL, AiravataAPI registry, XBayaConfiguration configuration, XBayaGUI gui, Monitor monitor) {
        this(workflow, topic, messageBoxURL, messageBrokerURL, registry, configuration, gui, monitor, true);
    }

    public WorkflowInterpreterConfiguration(Workflow workflow, String topic, URI messageBoxURL, URI messageBrokerURL, AiravataAPI airavataAPI, XBayaConfiguration configuration, XBayaGUI gui, Monitor monitor, boolean offline) {
        this.messageBoxURL = messageBoxURL;
        this.messageBrokerURL = messageBrokerURL;
        this.airavataAPI = airavataAPI;
        this.configuration = configuration;
        this.gui = gui;
        this.monitor = monitor;
        this.offline = offline;
        this.workflow = workflow;
        this.topic = topic;
    }

    public URI getMessageBoxURL() {
        return this.messageBoxURL;
    }

    public void setMessageBoxURL(URI messageBoxURL) {
        this.messageBoxURL = messageBoxURL;
    }

    public URI getMessageBrokerURL() {
        return this.messageBrokerURL;
    }

    public void setMessageBrokerURL(URI messageBrokerURL) {
        this.messageBrokerURL = messageBrokerURL;
    }

    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }

    public XBayaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(XBayaConfiguration configuration) {
        this.configuration = configuration;
    }

    public XBayaGUI getGUI() {
        return this.gui;
    }

    public void setGUI(XBayaGUI gui) {
        this.gui = gui;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isRunWithCrossProduct() {
        return this.runWithCrossProduct;
    }

    public void setRunWithCrossProduct(boolean runWithCrossProduct) {
        this.runWithCrossProduct = runWithCrossProduct;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    public WorkflowNotifiable getNotifier() {
        if (this.notifier == null) {
            this.notifier = new NotificationSender(this.getMessageBrokerURL(), this.getTopic());
        }
        return this.notifier;
    }

    public void validateNotifier() {
        this.getNotifier();
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public boolean isGfacEmbeddedMode() {
        return this.gfacEmbeddedMode;
    }

    public void setGfacEmbeddedMode(boolean gfacEmbeddedMode) {
        this.gfacEmbeddedMode = gfacEmbeddedMode;
    }

    public Boolean isActOnProvenance() {
        return this.actOnProvenance;
    }

    public void setActOnProvenance(Boolean actOnProvenance) {
        this.actOnProvenance = actOnProvenance;
    }

    public boolean isSubWorkflow() {
        return this.subWorkflow;
    }

    public void setSubWorkflow(boolean subWorkflow) {
        this.subWorkflow = subWorkflow;
    }

    public void setNotifier(WorkflowNotifiable notifier) {
        this.notifier = notifier;
        this.setTestMode(notifier instanceof StandaloneNotificationSender);
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    private void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public AiravataAPI getAiravataAPI() {
        return this.airavataAPI;
    }

    public void setAiravataAPI(AiravataAPI airavataAPI) {
        this.airavataAPI = airavataAPI;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }
}

