/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.interpretor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.Pair;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.common.workflow.execution.context.WorkflowContextHeaderBuilder;
import org.apache.airavata.gfac.context.security.AmazonSecurityContext;
import org.apache.airavata.registry.api.workflow.WorkflowExecution;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionStatus;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNode;
import org.apache.airavata.registry.api.workflow.WorkflowNodeType;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.amazon.InstanceComponent;
import org.apache.airavata.workflow.model.component.amazon.TerminateInstanceComponent;
import org.apache.airavata.workflow.model.component.dynamic.DynamicComponent;
import org.apache.airavata.workflow.model.component.system.DoWhileComponent;
import org.apache.airavata.workflow.model.component.system.EndDoWhileComponent;
import org.apache.airavata.workflow.model.component.system.EndForEachComponent;
import org.apache.airavata.workflow.model.component.system.EndifComponent;
import org.apache.airavata.workflow.model.component.system.ForEachComponent;
import org.apache.airavata.workflow.model.component.system.IfComponent;
import org.apache.airavata.workflow.model.component.system.SubWorkflowComponent;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.component.ws.WSComponentPort;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.amazon.InstanceNode;
import org.apache.airavata.workflow.model.graph.dynamic.BasicTypeMapping;
import org.apache.airavata.workflow.model.graph.dynamic.DynamicNode;
import org.apache.airavata.workflow.model.graph.impl.EdgeImpl;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.subworkflow.SubWorkflowNode;
import org.apache.airavata.workflow.model.graph.system.ConstantNode;
import org.apache.airavata.workflow.model.graph.system.DoWhileNode;
import org.apache.airavata.workflow.model.graph.system.EndForEachNode;
import org.apache.airavata.workflow.model.graph.system.EndifNode;
import org.apache.airavata.workflow.model.graph.system.ForEachNode;
import org.apache.airavata.workflow.model.graph.system.IfNode;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.workflow.model.graph.ws.WSPort;
import org.apache.airavata.workflow.model.ode.ODEClient;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.workflow.model.wf.WorkflowExecutionState;
import org.apache.airavata.ws.monitor.MonitorException;
import org.apache.airavata.xbaya.concurrent.PredicatedTaskRunner;
import org.apache.airavata.xbaya.interpretor.DoWhileHandler;
import org.apache.airavata.xbaya.interpretor.SystemComponentInvoker;
import org.apache.airavata.xbaya.interpretor.WorkFlowInterpreterException;
import org.apache.airavata.xbaya.interpretor.WorkflowExecutionMessage;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreterConfiguration;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreterInteractor;
import org.apache.airavata.xbaya.invoker.DynamicInvoker;
import org.apache.airavata.xbaya.invoker.EmbeddedGFacInvoker;
import org.apache.airavata.xbaya.invoker.GenericInvoker;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.invoker.WorkflowInputUtil;
import org.apache.airavata.xbaya.provenance.ProvenanceReader;
import org.apache.airavata.xbaya.provenance.ProvenanceWrite;
import org.apache.airavata.xbaya.util.AmazonUtil;
import org.apache.airavata.xbaya.util.InterpreterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;
import xsul.lead.LeadResourceMapping;
import xsul5.XmlConstants;
import xsul5.wsdl.WsdlDefinitions;

public class WorkflowInterpreter {
    private static final Logger log = LoggerFactory.getLogger(WorkflowInterpreter.class);
    public static final String WORKFLOW_STARTED = "Workflow Running";
    public static final String WORKFLOW_FINISHED = "Workflow Finished";
    private WorkflowInterpreterConfiguration config;
    private Map<Node, Invoker> invokerMap = new HashMap<Node, Invoker>();
    private LeadResourceMapping resourceMapping;
    private PredicatedTaskRunner provenanceWriter;
    private WorkflowInterpreterInteractor interactor;
    public static ThreadLocal<WorkflowInterpreterConfiguration> workflowInterpreterConfigurationThreadLocal = new ThreadLocal();

    public WorkflowInterpreter(WorkflowInterpreterConfiguration config, WorkflowInterpreterInteractor interactor) {
        this.setConfig(config);
        config.validateNotifier();
        this.interactor = interactor;
        if (config.isActOnProvenance() == null) {
            config.setActOnProvenance(config.getConfiguration().isCollectProvenance());
        }
        config.setSubWorkflow(false);
        WorkflowInterpreter.setWorkflowInterpreterConfigurationThreadLocal(config);
    }

    public void setResourceMapping(LeadResourceMapping resourceMapping) {
        this.resourceMapping = resourceMapping;
    }

    private void notifyViaInteractor(WorkflowExecutionMessage messageType, Object data) {
        this.interactor.notify(messageType, this.config, data);
    }

    private Object getInputViaInteractor(WorkflowExecutionMessage messageType, Object data) throws Exception {
        return this.interactor.retrieveData(messageType, this.config, data);
    }

    public void scheduleDynamically() throws WorkflowException {
        try {
            if (!this.config.isSubWorkflow() && this.getWorkflow().getExecutionState() != WorkflowExecutionState.NONE) {
                throw new WorkFlowInterpreterException("XBaya is already running a workflow");
            }
            this.getWorkflow().setExecutionState(WorkflowExecutionState.RUNNING);
            ArrayList<Node> inputNodes = this.getInputNodesDynamically();
            Object[] values = new Object[inputNodes.size()];
            String[] keywords = new String[inputNodes.size()];
            for (int i = 0; i < inputNodes.size(); ++i) {
                Node node = inputNodes.get(i);
                node.setState(Node.NodeExecutionState.FINISHED);
                this.notifyViaInteractor(WorkflowExecutionMessage.NODE_STATE_CHANGED, null);
                keywords[i] = ((InputNode)node).getName();
                values[i] = ((InputNode)node).getDefaultValue();
                WorkflowNodeType workflowNodeType = new WorkflowNodeType();
                workflowNodeType.setNodeType(WorkflowNodeType.WorkflowNode.INPUTNODE);
                WorkflowInstanceNode workflowInstanceNode = new WorkflowInstanceNode(new WorkflowExecution(this.getConfig().getTopic(), this.getConfig().getTopic()), node.getID());
                this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().setWorkflowInstanceNodeInput(workflowInstanceNode, keywords[i] + "=" + (String)values[i]);
                this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().setWorkflowNodeType(workflowInstanceNode, workflowNodeType);
            }
            this.config.getNotifier().workflowStarted(values, keywords);
            this.config.getConfiguration().setContextHeader(WorkflowContextHeaderBuilder.getCurrentContextHeader());
            while (this.getWorkflow().getExecutionState() != WorkflowExecutionState.STOPPED) {
                ArrayList<Node> readyNodes = this.getReadyNodesDynamically();
                ArrayList<1> threadList = new ArrayList<1>();
                if (this.getRemainNodesDynamically() == 0) {
                    this.notifyViaInteractor(WorkflowExecutionMessage.EXECUTION_STATE_CHANGED, WorkflowExecutionState.PAUSED);
                }
                while (this.getWorkflow().getExecutionState() == WorkflowExecutionState.PAUSED) {
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                for (final Node node : readyNodes) {
                    if (node.isBreak()) {
                        this.notifyPause();
                        break;
                    }
                    if (this.getWorkflow().getExecutionState() == WorkflowExecutionState.PAUSED || this.getWorkflow().getExecutionState() == WorkflowExecutionState.STOPPED) break;
                    Thread th = new Thread(){

                        @Override
                        public synchronized void run() {
                            try {
                                WorkflowInterpreter.this.executeDynamically(node);
                            }
                            catch (WorkflowException e) {
                                log.error("Error execution workflow Node : " + node.getID());
                                return;
                            }
                        }
                    };
                    threadList.add(th);
                    th.start();
                    if (this.getWorkflow().getExecutionState() != WorkflowExecutionState.STEP) continue;
                    this.getWorkflow().setExecutionState(WorkflowExecutionState.PAUSED);
                    break;
                }
                for (Thread thread : threadList) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.sendOutputsDynamically();
                if (readyNodes.size() != 0) continue;
                if (InterpreterUtil.getRunningNodeCountDynamically(this.getGraph()) == 0 && InterpreterUtil.getFailedNodeCountDynamically(this.getGraph()) != 0) {
                    this.getWorkflow().setExecutionState(WorkflowExecutionState.STOPPED);
                }
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException e) {
                    log.error("Workflow Excecution is interrupted !");
                    return;
                }
            }
            if (InterpreterUtil.getFailedNodeCountDynamically(this.getGraph()) == 0) {
                if (this.config.isActOnProvenance().booleanValue()) {
                    try {
                        this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().setWorkflowInstanceStatus(this.config.getTopic(), this.config.getTopic(), WorkflowExecutionStatus.State.FINISHED);
                    }
                    catch (Exception e) {
                        throw new WorkflowException((Throwable)e);
                    }
                }
            } else if (this.config.isActOnProvenance().booleanValue()) {
                try {
                    this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().setWorkflowInstanceStatus(this.config.getTopic(), this.config.getTopic(), WorkflowExecutionStatus.State.FAILED);
                }
                catch (AiravataAPIInvocationException e) {
                    throw new WorkflowException((Throwable)e);
                }
            }
            this.config.getNotifier().workflowTerminated();
            UUID uuid = UUID.randomUUID();
            this.notifyViaInteractor(WorkflowExecutionMessage.EXECUTION_TASK_START, new WorkflowInterpreterInteractor.TaskNotification("Stop Workflow", "Cleaning up resources for Workflow", uuid.toString()));
            this.finish();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.cleanup();
            if (this.config.getNotifier() != null) {
                this.config.getNotifier().cleanup();
            }
            this.notifyViaInteractor(WorkflowExecutionMessage.EXECUTION_TASK_END, new WorkflowInterpreterInteractor.TaskNotification("Stop Workflow", "Cleaning up resources for Workflow", uuid.toString()));
            this.getWorkflow().setExecutionState(WorkflowExecutionState.NONE);
        }
        catch (RuntimeException e) {
            this.cleanup();
            this.config.getNotifier().workflowFailed(e.getMessage());
            this.config.getNotifier().cleanup();
            this.getWorkflow().setExecutionState(WorkflowExecutionState.NONE);
            this.raiseException(e);
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
        }
    }

    private boolean readProvenance(Node node) {
        try {
            String output;
            List inputPorts = node.getInputPorts();
            Pair[] inputs = new Pair[inputPorts.size()];
            for (int i = 0; i < inputPorts.size(); ++i) {
                String inputTagname = ((DataPort)inputPorts.get(i)).getName();
                if (node instanceof DoWhileNode) {
                    inputs[i] = new Pair((Object)inputTagname, (Object)("<" + inputTagname + ">" + InterpreterUtil.findInputFromPort((DataPort)inputPorts.get(i), this.invokerMap).toString() + "</" + inputTagname + ">"));
                    break;
                }
                inputs[i] = new Pair((Object)inputTagname, (Object)("<" + inputTagname + ">" + InterpreterUtil.findInputFromPort((DataPort)inputPorts.get(i), this.invokerMap).toString() + "</" + inputTagname + ">"));
            }
            if ((output = (String)new ProvenanceReader(node, this.config.getTopic(), this.config.getAiravataAPI()).read()) != null) {
                XmlElement result = XMLUtil.stringToXmlElement((String)output);
                SystemComponentInvoker invoker = new SystemComponentInvoker();
                List outPorts = node.getOutputPorts();
                for (DataPort dataPort : outPorts) {
                    Iterable itr = result.children();
                    for (Object outputElem : itr) {
                        if (!(outputElem instanceof XmlElement) || !((XmlElement)outputElem).getName().equals(dataPort.getName())) continue;
                        invoker.addOutput(dataPort.getName(), ((XmlElement)outputElem).children().iterator().next());
                    }
                }
                this.invokerMap.put(node, invoker);
                node.setState(Node.NodeExecutionState.FINISHED);
                return true;
            }
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        return false;
    }

    private void writeProvenanceLater(Node node) throws WorkflowException {
        if (node instanceof ForEachNode) {
            node = InterpreterUtil.findEndForEachFor((ForEachNode)node);
        }
        if (this.provenanceWriter == null) {
            this.provenanceWriter = new PredicatedTaskRunner(1);
        }
        this.provenanceWriter.scedule(new ProvenanceWrite(node, this.getWorkflow().getName(), this.invokerMap, this.config.getTopic(), this.getConfig().getConfiguration().getAiravataAPI()));
    }

    public void raiseException(Throwable e) {
        this.notifyViaInteractor(WorkflowExecutionMessage.EXECUTION_ERROR, e);
    }

    private void notifyPause() {
        if (this.getWorkflow().getExecutionState() != WorkflowExecutionState.RUNNING && this.getWorkflow().getExecutionState() != WorkflowExecutionState.STEP) {
            throw new WorkflowRuntimeException("Cannot pause when not running");
        }
        this.notifyViaInteractor(WorkflowExecutionMessage.EXECUTION_STATE_CHANGED, WorkflowExecutionState.PAUSED);
    }

    public void cleanup() throws MonitorException {
        this.getWorkflow().setExecutionState(WorkflowExecutionState.STOPPED);
        this.notifyViaInteractor(WorkflowExecutionMessage.EXECUTION_CLEANUP, null);
    }

    private void sendOutputsDynamically() throws WorkflowException, AiravataAPIInvocationException {
        ArrayList<Node> outputNodes = this.getReadyOutputNodesDynamically();
        if (outputNodes.size() != 0) {
            LinkedList outputValues = new LinkedList();
            LinkedList outputKeywords = new LinkedList();
            for (Node node : outputNodes) {
                node.setState(Node.NodeExecutionState.EXECUTING);
                List inputPorts = node.getInputPorts();
                for (DataPort dataPort : inputPorts) {
                    Object val = InterpreterUtil.findInputFromPort(dataPort, this.invokerMap);
                    if (null == val) {
                        throw new WorkFlowInterpreterException("Unable to find output for the node:" + node.getID());
                    }
                    if (val instanceof org.xmlpull.v1.builder.XmlElement) {
                        ((OutputNode)node).setDescription(XMLUtil.xmlElementToString((org.xmlpull.v1.builder.XmlElement)((org.xmlpull.v1.builder.XmlElement)val)));
                    } else {
                        ((OutputNode)node).setDescription(val.toString());
                    }
                    WorkflowNodeType workflowNodeType = new WorkflowNodeType();
                    workflowNodeType.setNodeType(WorkflowNodeType.WorkflowNode.OUTPUTNODE);
                    WorkflowInstanceNode workflowInstanceNode = new WorkflowInstanceNode(new WorkflowExecution(this.config.getTopic(), this.config.getTopic()), node.getID());
                    String portname = node.getName();
                    String portValue = ((OutputNode)node).getDescription();
                    this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().setWorkflowInstanceNodeOutput(workflowInstanceNode, portname + "=" + portValue);
                    this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().setWorkflowNodeType(workflowInstanceNode, workflowNodeType);
                    if (this.config.isActOnProvenance().booleanValue()) {
                        try {
                            if (val instanceof String) {
                                this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().saveWorkflowExecutionOutput(this.config.getTopic(), node.getName(), val.toString());
                            } else if (val instanceof org.xmlpull.v1.builder.XmlElement) {
                                this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().saveWorkflowExecutionOutput(this.config.getTopic(), node.getName(), XMLUtil.xmlElementToString((org.xmlpull.v1.builder.XmlElement)((org.xmlpull.v1.builder.XmlElement)val)));
                            }
                        }
                        catch (AiravataAPIInvocationException e) {
                            e.printStackTrace();
                        }
                    }
                    node.setState(Node.NodeExecutionState.FINISHED);
                }
            }
            this.config.getNotifier().sendingPartialResults(outputValues.toArray(), outputKeywords.toArray(new String[outputKeywords.size()]));
        }
    }

    private void finish() throws WorkflowException {
        ArrayList<Node> outoutNodes = new ArrayList<Node>();
        List nodes = this.getGraph().getNodes();
        for (Node node : nodes) {
            if (!(node instanceof OutputNode)) continue;
            if (node.getInputPort(0).getFromNode().getState() == Node.NodeExecutionState.FINISHED) {
                outoutNodes.add(node);
                continue;
            }
            return;
        }
        LinkedList outputValues = new LinkedList();
        LinkedList outputKeywords = new LinkedList();
        for (Node outputNode : outoutNodes) {
            OutputNode node = (OutputNode)outputNode;
            List inputPorts = node.getInputPorts();
            for (DataPort dataPort : inputPorts) {
                Object val = InterpreterUtil.findInputFromPort(dataPort, this.invokerMap);
                if (null == val) {
                    throw new WorkFlowInterpreterException("Unable to find output for the node:" + node.getID());
                }
                if (node.getState() == Node.NodeExecutionState.FINISHED) continue;
                if (this.config.isActOnProvenance().booleanValue()) {
                    try {
                        if (val instanceof String) {
                            this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().saveWorkflowExecutionOutput(this.config.getTopic(), node.getName(), val.toString());
                        } else if (val instanceof org.xmlpull.v1.builder.XmlElement) {
                            this.getConfig().getConfiguration().getAiravataAPI().getProvenanceManager().saveWorkflowExecutionOutput(this.config.getTopic(), node.getName(), XMLUtil.xmlElementToString((org.xmlpull.v1.builder.XmlElement)((org.xmlpull.v1.builder.XmlElement)val)));
                        }
                    }
                    catch (AiravataAPIInvocationException e) {
                        e.printStackTrace();
                    }
                }
                if (val instanceof XmlElement) {
                    node.setDescription(XMLUtil.xmlElementToString((XmlElement)((XmlElement)val)));
                } else {
                    node.setDescription(val.toString());
                }
                node.setState(Node.NodeExecutionState.FINISHED);
            }
        }
        this.config.getNotifier().sendingPartialResults(outputValues.toArray(), outputKeywords.toArray(new String[outputKeywords.size()]));
        this.cleanup();
        this.config.getNotifier().cleanup();
    }

    private void executeDynamically(Node node) throws WorkflowException {
        node.setState(Node.NodeExecutionState.EXECUTING);
        Component component = node.getComponent();
        if (component instanceof SubWorkflowComponent) {
            this.handleSubWorkComponent(node);
        } else if (component instanceof WSComponent) {
            this.handleWSComponent(node);
        } else if (component instanceof DynamicComponent) {
            this.handleDynamicComponent(node);
        } else if (component instanceof ForEachComponent) {
            this.handleForEach(node);
        } else if (component instanceof IfComponent) {
            this.handleIf(node);
        } else if (component instanceof EndifComponent) {
            this.handleEndIf(node);
        } else if (component instanceof DoWhileComponent) {
            this.handleDoWhile(node);
        } else if (!(component instanceof EndDoWhileComponent)) {
            if (component instanceof InstanceComponent) {
                this.handleAmazonInstance(node);
            } else if (component instanceof TerminateInstanceComponent) {
                this.handleAmazonTerminateInstance(node);
            } else {
                throw new WorkFlowInterpreterException("Encountered Node that cannot be executed:" + node);
            }
        }
    }

    private void handleAmazonTerminateInstance(Node node) throws WorkflowException {
        Object inputVal = InterpreterUtil.findInputFromPort(node.getInputPort(0), this.invokerMap);
        String instanceId = inputVal.toString();
        AmazonUtil.terminateInstances(instanceId);
        node.setState(Node.NodeExecutionState.FINISHED);
    }

    private void handleAmazonInstance(Node node) {
        if (this.config.getAwsAccessKey().isEmpty() || this.config.getAwsSecretKey().isEmpty()) {
            throw new WorkFlowInterpreterException("Please set Amazon Credential before using EC2 Instance Component");
        }
        for (ControlPort ports : node.getControlOutPorts()) {
            ports.setConditionMet(true);
        }
    }

    private void handleDoWhile(Node node) {
        ExecutorService threadExecutor = Executors.newSingleThreadExecutor();
        DoWhileHandler doWhileHandler = new DoWhileHandler((DoWhileNode)node, this.invokerMap, this.getWaitingNodesDynamically(), this.getFinishedNodesDynamically(), this, threadExecutor);
        threadExecutor.submit(doWhileHandler);
    }

    private void handleSubWorkComponent(Node node) throws WorkflowException {
        this.notifyViaInteractor(WorkflowExecutionMessage.OPEN_SUBWORKFLOW, node);
        Workflow subWorkflow = ((SubWorkflowNode)node).getWorkflow();
        ArrayList<Node> subWorkflowInputNodes = this.getInputNodes(subWorkflow);
        List inputPorts = node.getInputPorts();
        for (DataPort dataPort : inputPorts) {
            Object inputVal = InterpreterUtil.findInputFromPort(dataPort, this.invokerMap);
            if (null == inputVal) {
                throw new WorkFlowInterpreterException("Unable to find inputs for the subworkflow node node:" + node.getID());
            }
            for (InputNode inputNode : subWorkflowInputNodes) {
                if (!inputNode.getName().equals(dataPort.getName())) continue;
                inputNode.setDefaultValue(inputVal);
            }
        }
        for (InputNode inputNode : subWorkflowInputNodes) {
            if (inputNode.getDefaultValue() != null) continue;
            throw new WorkFlowInterpreterException("Input not set for  :" + inputNode.getID());
        }
        try {
            WorkflowInterpreter subworkflowInterpreter = (WorkflowInterpreter)this.getInputViaInteractor(WorkflowExecutionMessage.INPUT_WORKFLOWINTERPRETER_FOR_WORKFLOW, subWorkflow);
            subworkflowInterpreter.scheduleDynamically();
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    protected void handleWSComponent(Node node) throws WorkflowException {
        WSComponent wsComponent = (WSComponent)node.getComponent();
        QName portTypeQName = wsComponent.getPortTypeQName();
        Invoker invoker = this.invokerMap.get(node);
        if (invoker != null) {
            this.invokerMap.remove(invoker);
        }
        WSNode wsNode = (WSNode)node;
        String wsdlLocation = InterpreterUtil.getEPR(wsNode);
        String gfacURLString = this.getConfig().getConfiguration().getGFacURL().toString();
        if (null == wsdlLocation) {
            for (Node n : wsNode.getControlInPort().getFromNodes()) {
                AmazonSecurityContext amazonSecurityContext;
                if (!(n instanceof InstanceNode)) continue;
                String awsAccessKeyId = this.config.getAwsAccessKey();
                String awsSecretKey = this.config.getAwsSecretKey();
                String username = ((InstanceNode)n).getUsername();
                if (((InstanceNode)n).isStartNewInstance()) {
                    String amiId = ((InstanceNode)n).getIdAsValue();
                    String instanceType = ((InstanceNode)n).getInstanceType();
                    amazonSecurityContext = new AmazonSecurityContext(username, awsAccessKeyId, awsSecretKey, amiId, instanceType);
                } else {
                    String instanceId = ((InstanceNode)n).getIdAsValue();
                    amazonSecurityContext = new AmazonSecurityContext(username, awsAccessKeyId, awsSecretKey, instanceId);
                }
                this.config.getConfiguration().setAmazonSecurityContext(amazonSecurityContext);
            }
            invoker = this.config.isGfacEmbeddedMode() || this.config.getAwsAccessKey() != null ? new EmbeddedGFacInvoker(portTypeQName, WSDLUtil.wsdlDefinitions5ToWsdlDefintions3((WsdlDefinitions)wsNode.getComponent().getWSDL()), node.getID(), this.config.getMessageBoxURL().toASCIIString(), this.config.getMessageBrokerURL().toASCIIString(), this.config.getNotifier(), this.config.getTopic(), this.config.getAiravataAPI(), portTypeQName.getLocalPart(), this.config.getConfiguration()) : new GenericInvoker(portTypeQName, WSDLUtil.wsdlDefinitions5ToWsdlDefintions3((WsdlDefinitions)wsNode.getComponent().getWSDL()), node.getID(), this.config.getMessageBoxURL().toASCIIString(), gfacURLString, this.config.getNotifier());
        } else {
            if (wsdlLocation.endsWith("/")) {
                wsdlLocation = wsdlLocation.substring(0, wsdlLocation.length() - 1);
            }
            if (!wsdlLocation.endsWith("?wsdl")) {
                wsdlLocation = wsdlLocation + "?wsdl";
            }
            invoker = new GenericInvoker(portTypeQName, wsdlLocation, node.getID(), this.getConfig().getConfiguration().getMessageBoxURL().toString(), gfacURLString, this.config.getNotifier());
        }
        invoker.setup();
        this.invokerMap.put(node, invoker);
        invoker.setOperation(wsComponent.getOperationName());
        List inputPorts = node.getInputPorts();
        ODEClient odeClient = new ODEClient();
        for (DataPort port : inputPorts) {
            Object inputVal = InterpreterUtil.findInputFromPort(port, this.invokerMap);
            if (port.getFromNode() instanceof InputNode) {
                inputVal = WorkflowInputUtil.parseValue((WSComponentPort)port.getComponentPort(), (String)inputVal);
            }
            if (null == inputVal) {
                throw new WorkFlowInterpreterException("Unable to find inputs for the node:" + node.getID());
            }
            if (port.getFromNode() instanceof EndForEachNode) {
                inputVal = WorkflowInputUtil.parseValue((WSComponentPort)port.getComponentPort(), (String)inputVal);
            }
            invoker.setInput(port.getName(), inputVal);
        }
        invoker.invoke();
    }

    private void handleDynamicComponent(Node node) throws WorkflowException {
        DynamicComponent dynamicComponent = (DynamicComponent)node.getComponent();
        String className = dynamicComponent.getClassName();
        String operationName = dynamicComponent.getOperationName();
        URL implJarLocation = dynamicComponent.getImplJarLocation();
        DynamicNode dynamicNode = (DynamicNode)node;
        LinkedList<Object> inputs = new LinkedList<Object>();
        List inputPorts = dynamicNode.getInputPorts();
        for (DataPort dataPort : inputPorts) {
            Object inputVal = InterpreterUtil.findInputFromPort(dataPort, this.invokerMap);
            Node fromNode = dataPort.getFromNode();
            QName type = null;
            if (fromNode instanceof InputNode) {
                type = BasicTypeMapping.STRING_QNAME;
            } else if (fromNode instanceof ConstantNode) {
                type = ((ConstantNode)fromNode).getType();
            } else if (dataPort.getFromPort() instanceof WSPort && BasicTypeMapping.isArrayType((XmlElement)((WSPort)dataPort.getFromPort()).getComponentPort().getElement())) {
                Invoker fromInvoker = this.invokerMap.get(fromNode);
                inputVal = BasicTypeMapping.getOutputArray((XmlElement)XmlConstants.BUILDER.parseFragmentFromString(fromInvoker.getOutputs().toString()), (String)dataPort.getFromPort().getName(), (int)BasicTypeMapping.getSimpleTypeIndex((QName)((DataPort)dataPort.getFromPort()).getType()));
                type = ((DataPort)dataPort.getFromPort()).getType();
            } else {
                type = ((DataPort)dataPort.getFromPort()).getType();
            }
            if (null == inputVal) {
                throw new WorkFlowInterpreterException("Unable to find inputs for the node:" + node.getID());
            }
            inputs.add(BasicTypeMapping.getObjectOfType((QName)type, (Object)inputVal));
        }
        DynamicInvoker dynamicInvoker = new DynamicInvoker(className, implJarLocation, operationName, inputs.toArray());
        this.invokerMap.put(node, dynamicInvoker);
        dynamicInvoker.setup();
        dynamicInvoker.invoke();
        node.setState(Node.NodeExecutionState.FINISHED);
    }

    private void handleForEach(Node node) throws WorkflowException {
        final ForEachNode forEachNode = (ForEachNode)node;
        EndForEachNode endForEachNode = null;
        Collection repeatNodes = node.getOutputPort(0).getToNodes();
        if (repeatNodes.size() != 1) {
            throw new WorkFlowInterpreterException("Only one node allowed inside foreach");
        }
        Iterator iterator = repeatNodes.iterator();
        if (iterator.hasNext()) {
            Node middleNode = (Node)iterator.next();
            if (!(middleNode instanceof WSNode) && !(middleNode instanceof SubWorkflowNode)) {
                throw new WorkFlowInterpreterException("Encountered Node inside foreach that is not a WSNode" + middleNode);
            }
            if (middleNode instanceof SubWorkflowNode) {
                for (Node node2 : middleNode.getOutputPort(0).getToNodes()) {
                    if (!(node2 instanceof EndForEachNode)) continue;
                    endForEachNode = (EndForEachNode)node2;
                }
                final LinkedList<String> listOfValues = new LinkedList<String>();
                InterpreterUtil.getInputsForForEachNode(forEachNode, listOfValues, this.invokerMap);
                final Integer[] inputNumbers = InterpreterUtil.getNumberOfInputsForForEachNode(forEachNode, this.invokerMap);
                Workflow workflow1 = ((SubWorkflowNode)middleNode).getWorkflow();
                List nodes = workflow1.getGraph().getNodes();
                ArrayList<NodeImpl> wsNodes = new ArrayList<NodeImpl>();
                for (NodeImpl subWorkflowNode : nodes) {
                    if (!(subWorkflowNode instanceof WSNode)) continue;
                    wsNodes.add(subWorkflowNode);
                }
                for (int i = 0; i < wsNodes.size(); ++i) {
                    final WSNode node1 = (WSNode)wsNodes.get(i);
                    SystemComponentInvoker systemInvoker = null;
                    List outputPorts1 = node1.getOutputPorts();
                    ArrayList<Node> endForEachNodes = new ArrayList<Node>();
                    for (DataPort port : outputPorts1) {
                        for (Node node2 : port.getToNodes()) {
                            if (node2 instanceof EndForEachNode) {
                                endForEachNodes.add(node2);
                                continue;
                            }
                            if (node2 instanceof OutputNode) continue;
                            throw new WorkFlowInterpreterException("Found More than one node inside foreach");
                        }
                    }
                    final ArrayList<Node> finalEndForEachNodes = endForEachNodes;
                    for (Node node2 : node1.getOutputPort(0).getToNodes()) {
                        int parallelRuns = listOfValues.size() * node1.getOutputPorts().size();
                        if (listOfValues.size() <= 0) continue;
                        forEachNode.setState(Node.NodeExecutionState.EXECUTING);
                        node1.setState(Node.NodeExecutionState.EXECUTING);
                        List outputPorts = node1.getOutputPorts();
                        final AtomicInteger counter = new AtomicInteger();
                        for (Node endFor : endForEachNodes) {
                            systemInvoker = new SystemComponentInvoker();
                            this.invokerMap.put(endFor, systemInvoker);
                        }
                        final Map<Node, Invoker> finalMap = this.invokerMap;
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    WorkflowInterpreter.this.runInThread(listOfValues, forEachNode, (Node)node1, finalEndForEachNodes, finalMap, counter, inputNumbers);
                                }
                                catch (WorkflowException e) {
                                    WorkflowInterpreter.this.config.getGUI().getErrorWindow().error(e);
                                }
                            }
                        }.start();
                        while (counter.intValue() < parallelRuns) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (node2 instanceof OutputNode) continue;
                        listOfValues.removeAll(listOfValues);
                        String output = (String)systemInvoker.getOutput(node1.getOutputPort(0).getName());
                        XmlElement xmlElement = XMLUtil.stringToXmlElement((String)("<result>" + output + "</result>"));
                        for (Object next1 : xmlElement.children()) {
                            if (!(next1 instanceof XmlElement)) continue;
                            listOfValues.add((String)((XmlElement)next1).children().iterator().next());
                        }
                    }
                }
                endForEachNode.setState(Node.NodeExecutionState.FINISHED);
                middleNode.setState(Node.NodeExecutionState.FINISHED);
                node.setState(Node.NodeExecutionState.FINISHED);
            } else {
                List outputPorts1 = middleNode.getOutputPorts();
                ArrayList<Node> endForEachNodes = new ArrayList<Node>();
                for (DataPort port : outputPorts1) {
                    for (Node node2 : port.getToNodes()) {
                        if (node2 instanceof EndForEachNode) {
                            endForEachNodes.add(node2);
                            continue;
                        }
                        if (node2 instanceof OutputNode) continue;
                        throw new WorkFlowInterpreterException("Found More than one node inside foreach");
                    }
                }
                final ArrayList<Node> finalEndForEachNodes = endForEachNodes;
                final Node foreachWSNode = middleNode;
                final LinkedList<String> listOfValues = new LinkedList<String>();
                InterpreterUtil.getInputsForForEachNode(forEachNode, listOfValues, this.invokerMap);
                final Integer[] inputNumbers = InterpreterUtil.getNumberOfInputsForForEachNode(forEachNode, this.invokerMap);
                int parallelRuns = this.createInputValues(listOfValues, inputNumbers).size() * outputPorts1.size();
                if (listOfValues.size() > 0) {
                    forEachNode.setState(Node.NodeExecutionState.EXECUTING);
                    foreachWSNode.setState(Node.NodeExecutionState.EXECUTING);
                    List outputPorts = middleNode.getOutputPorts();
                    final AtomicInteger counter = new AtomicInteger();
                    for (Node endFor : endForEachNodes) {
                        SystemComponentInvoker systemInvoker = new SystemComponentInvoker();
                        this.invokerMap.put(endFor, systemInvoker);
                    }
                    final Map<Node, Invoker> finalInvokerMap = this.invokerMap;
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                WorkflowInterpreter.this.runInThread(listOfValues, forEachNode, foreachWSNode, finalEndForEachNodes, finalInvokerMap, counter, inputNumbers);
                            }
                            catch (WorkflowException e) {
                                WorkflowInterpreter.this.config.getGUI().getErrorWindow().error(e);
                            }
                        }
                    }.start();
                    while (counter.intValue() < parallelRuns) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    middleNode.setState(Node.NodeExecutionState.FINISHED);
                    for (Node endForEach : endForEachNodes) {
                        endForEach.setState(Node.NodeExecutionState.FINISHED);
                    }
                } else {
                    throw new WorkFlowInterpreterException("No array values found for foreach");
                }
            }
        }
    }

    private void handleIf(Node node) throws WorkflowException {
        IfNode ifNode = (IfNode)node;
        String booleanExpression = ifNode.getXPath();
        if (booleanExpression == null) {
            throw new WorkFlowInterpreterException("XPath for if cannot be null");
        }
        List inputPorts = node.getInputPorts();
        int i = 0;
        for (DataPort port : inputPorts) {
            Object inputVal = InterpreterUtil.findInputFromPort(port, this.invokerMap);
            if (null == inputVal) {
                throw new WorkFlowInterpreterException("Unable to find inputs for the node:" + node.getID());
            }
            booleanExpression = booleanExpression.replaceAll("\\$" + i, "'" + inputVal + "'");
        }
        try {
            XPathFactory xpathFact = XPathFactory.newInstance();
            XPath xpath = xpathFact.newXPath();
            Boolean result = (Boolean)xpath.evaluate(booleanExpression, booleanExpression, XPathConstants.BOOLEAN);
            for (ControlPort controlPort : node.getControlOutPorts()) {
                if (controlPort.getName().equals("If_True")) {
                    controlPort.setConditionMet(result.booleanValue());
                    continue;
                }
                if (!controlPort.getName().equals("If_False")) continue;
                controlPort.setConditionMet(result == false);
            }
            node.setState(Node.NodeExecutionState.FINISHED);
        }
        catch (XPathExpressionException e) {
            throw new WorkFlowInterpreterException("Cannot evaluate XPath in If Condition: " + booleanExpression);
        }
    }

    private void handleEndIf(Node node) throws WorkflowException {
        EndifNode endIfNode = (EndifNode)node;
        SystemComponentInvoker invoker = new SystemComponentInvoker();
        List ports = endIfNode.getOutputPorts();
        int outputPortIndex = 0;
        int inputPortIndex = 0;
        while (outputPortIndex < ports.size()) {
            Object inputVal = InterpreterUtil.findInputFromPort(endIfNode.getInputPort(inputPortIndex), this.invokerMap);
            Object inputVal2 = InterpreterUtil.findInputFromPort(endIfNode.getInputPort(inputPortIndex + 1), this.invokerMap);
            if (inputVal == null && inputVal2 == null || inputVal != null && inputVal2 != null) {
                throw new WorkFlowInterpreterException("EndIf gets wrong input numberPort:" + inputPortIndex + " and " + (inputPortIndex + 1));
            }
            Object value = inputVal != null ? inputVal : inputVal2;
            invoker.addOutput(endIfNode.getOutputPort(outputPortIndex).getID(), value);
            ++outputPortIndex;
            inputPortIndex += 2;
        }
        this.invokerMap.put(node, invoker);
        node.setState(Node.NodeExecutionState.FINISHED);
    }

    private Invoker createInvokerForEachSingleWSNode(Node foreachWSNode, String gfacURLString, WSComponent wsComponent) throws WorkflowException {
        Invoker invoker;
        String wsdlLocation = InterpreterUtil.getEPR((WSNode)foreachWSNode);
        QName portTypeQName = wsComponent.getPortTypeQName();
        if (null == wsdlLocation) {
            invoker = this.config.isGfacEmbeddedMode() ? new EmbeddedGFacInvoker(portTypeQName, WSDLUtil.wsdlDefinitions5ToWsdlDefintions3((WsdlDefinitions)((WSNode)foreachWSNode).getComponent().getWSDL()), foreachWSNode.getID(), this.config.getMessageBoxURL().toASCIIString(), this.config.getMessageBrokerURL().toASCIIString(), this.config.getNotifier(), this.config.getTopic(), this.config.getAiravataAPI(), portTypeQName.getLocalPart(), this.config.getConfiguration()) : new GenericInvoker(portTypeQName, WSDLUtil.wsdlDefinitions5ToWsdlDefintions3((WsdlDefinitions)((WSNode)foreachWSNode).getComponent().getWSDL()), foreachWSNode.getID(), this.config.getMessageBoxURL().toASCIIString(), gfacURLString, this.config.getNotifier());
        } else {
            if (wsdlLocation.endsWith("/")) {
                wsdlLocation = wsdlLocation.substring(0, wsdlLocation.length() - 1);
            }
            if (!wsdlLocation.endsWith("?wsdl")) {
                wsdlLocation = wsdlLocation + "?wsdl";
            }
            invoker = new GenericInvoker(portTypeQName, wsdlLocation, foreachWSNode.getID(), this.getConfig().getConfiguration().getMessageBoxURL().toString(), gfacURLString, this.config.getNotifier());
        }
        return invoker;
    }

    private void runInThread(final LinkedList<String> listOfValues, ForEachNode forEachNode, final Node middleNode, List<Node> endForEachNodes, Map<Node, Invoker> tempInvoker, AtomicInteger counter, final Integer[] inputNumber) throws WorkflowException {
        WSComponent wsComponent;
        LinkedList<Invoker> invokerList = new LinkedList<Invoker>();
        if (inputNumber.length > 1) {
            List<String> inputValues = this.createInputValues(listOfValues, inputNumber);
            Iterator<Object> iterator = inputValues.iterator();
            while (iterator.hasNext()) {
                String gfacURLString = this.getConfig().getConfiguration().getGFacURL().toString();
                final String input = (String)iterator.next();
                wsComponent = (WSComponent)middleNode.getComponent();
                final Invoker invoker2 = this.createInvokerForEachSingleWSNode(middleNode, gfacURLString, wsComponent);
                invokerList.add(invoker2);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            WorkflowInterpreter.this.getInvoker(middleNode, invoker2);
                            WorkflowInterpreter.this.invokeGFacService(listOfValues, middleNode, inputNumber, input, invoker2);
                        }
                        catch (WorkflowException e) {
                            WorkflowInterpreter.this.config.getGUI().getErrorWindow().error(e);
                        }
                    }
                }.start();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    this.config.getGUI().getErrorWindow().error(e);
                }
            }
        } else {
            Invoker invoker = null;
            for (String input : listOfValues) {
                String gfacURLString = this.getConfig().getConfiguration().getGFacURL().toString();
                wsComponent = (WSComponent)middleNode.getComponent();
                invoker = this.createInvokerForEachSingleWSNode(middleNode, gfacURLString, wsComponent);
                invokerList.add(invoker);
                this.getInvoker(middleNode, invoker);
                List inputPorts = middleNode.getInputPorts();
                for (DataPort port : inputPorts) {
                    Object inputVal = InterpreterUtil.findInputFromPort(port, this.invokerMap);
                    Node fromNode = port.getFromNode();
                    inputVal = WorkflowInputUtil.parseValue((WSComponentPort)port.getComponentPort(), input);
                    if (null == inputVal) {
                        throw new WorkFlowInterpreterException("Unable to find inputs for the node:" + middleNode.getID());
                    }
                    invoker.setInput(port.getName(), inputVal);
                }
                invoker.invoke();
            }
        }
        String[] outputStr = new String[middleNode.getOutputPorts().size()];
        int i = 0;
        for (DataPort port : middleNode.getOutputPorts()) {
            String outputString = "";
            for (Invoker workflowInvoker : invokerList) {
                Object output = workflowInvoker.getOutput(port.getName());
                if (output instanceof org.xmlpull.v1.builder.XmlElement) {
                    org.xmlpull.v1.builder.XmlElement element = (org.xmlpull.v1.builder.XmlElement)((org.xmlpull.v1.builder.XmlElement)output).children().next();
                    outputString = outputString + "\n" + XMLUtil.xmlElementToString((org.xmlpull.v1.builder.XmlElement)element);
                } else {
                    outputString = outputString + "\n<value>" + output + "</value>";
                }
                counter.incrementAndGet();
            }
            outputStr[i] = outputString;
            System.out.println(outputStr[i]);
            ++i;
        }
        i = 0;
        int outputPortIndex = 0;
        for (DataPort port : middleNode.getOutputPorts()) {
            for (Node endForEachNode : endForEachNodes) {
                if (tempInvoker.get(endForEachNode) != null && !(endForEachNode instanceof OutputNode)) {
                    ((SystemComponentInvoker)tempInvoker.get(endForEachNode)).addOutput(port.getName(), outputStr[i]);
                }
                ++outputPortIndex;
            }
            ++i;
        }
        forEachNode.setState(Node.NodeExecutionState.FINISHED);
    }

    private void invokeGFacService(LinkedList<String> listOfValues, Node middleNode, Integer[] inputNumber, String input, Invoker invoker) throws WorkflowException {
        List inputPorts = middleNode.getInputPorts();
        String[] inputArray = null;
        inputArray = inputNumber.length == 1 ? listOfValues.toArray(new String[listOfValues.size()]) : input.split(",");
        int index = 0;
        for (DataPort port : inputPorts) {
            Object inputVal = InterpreterUtil.findInputFromPort(port, this.invokerMap);
            Node fromNode = port.getFromNode();
            if (fromNode instanceof ForEachNode) {
                inputVal = inputArray[index++];
            }
            if (null == inputVal) {
                throw new WorkFlowInterpreterException("Unable to find inputs for the node:" + middleNode.getID());
            }
            invoker.setInput(port.getName(), inputVal);
        }
        invoker.invoke();
    }

    private Invoker getInvoker(Node middleNode, Invoker invoker) throws WorkflowException {
        if (middleNode instanceof WSNode) {
            WSComponent wsComponent = (WSComponent)middleNode.getComponent();
            invoker.setup();
            invoker.setOperation(wsComponent.getOperationName());
        } else if (!(middleNode instanceof SubWorkflowNode)) {
            throw new WorkflowRuntimeException("Only Web services and subworkflows are supported for For-Each : Found : " + middleNode);
        }
        return invoker;
    }

    private List<String> createInputValues(LinkedList<String> listOfValues, Integer[] inputNumbers) throws WorkflowException {
        ArrayList<String> inputValues = null;
        try {
            inputValues = new ArrayList<String>();
            if (inputNumbers.length == 1) {
                return listOfValues;
            }
            if (this.config.isRunWithCrossProduct()) {
                for (int i = 0; i < inputNumbers[0]; ++i) {
                    for (int j = 0; j < inputNumbers[1]; ++j) {
                        inputValues.add(listOfValues.get(i) + "," + listOfValues.get(inputNumbers[0] + j));
                    }
                }
            } else {
                ArrayList<String[]> inputList = new ArrayList<String[]>();
                int startIndex = 0;
                for (int input = 0; input < inputNumbers.length; ++input) {
                    String[] inputArray = new String[inputNumbers[input].intValue()];
                    for (int travers = 0; travers < inputNumbers[input]; ++travers) {
                        inputArray[travers] = listOfValues.get(startIndex++);
                    }
                    inputList.add(inputArray);
                }
                int inputSize = 1;
                for (String[] inputArrays : inputList) {
                    if (inputArrays.length == 1) continue;
                    inputSize = inputArrays.length;
                }
                ArrayList<String[]> finalInputList = new ArrayList<String[]>();
                for (String[] inputArrays : inputList) {
                    if (inputArrays.length == 1) {
                        String[] fullArray = new String[inputSize];
                        for (int i = 0; i < fullArray.length; ++i) {
                            fullArray[i] = inputArrays[0];
                        }
                        finalInputList.add(fullArray);
                        continue;
                    }
                    finalInputList.add(inputArrays);
                }
                for (int i = 0; i < inputSize; ++i) {
                    String inputValue = "";
                    for (String[] array : finalInputList) {
                        inputValue = inputValue + "," + array[i];
                    }
                    inputValue = inputValue.replaceFirst(",", "");
                    inputValues.add(inputValue);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new WorkflowException("Wrong number of Inputs to For EachNode");
        }
        return inputValues;
    }

    private ArrayList<Node> getReadyOutputNodesDynamically() {
        ArrayList<Node> list = new ArrayList<Node>();
        List nodes = this.getGraph().getNodes();
        for (Node node : nodes) {
            if (!(node instanceof OutputNode) || node.getState() != Node.NodeExecutionState.WAITING || node.getInputPort(0).getFromNode().getState() != Node.NodeExecutionState.FINISHED) continue;
            list.add(node);
        }
        return list;
    }

    private int getRemainNodesDynamically() {
        return InterpreterUtil.getWaitingNodeCountDynamically(this.getGraph()) + InterpreterUtil.getRunningNodeCountDynamically(this.getGraph());
    }

    private ArrayList<Node> getInputNodesDynamically() {
        return this.getInputNodes(this.getWorkflow());
    }

    private ArrayList<Node> getInputNodes(Workflow wf) {
        ArrayList<Node> list = new ArrayList<Node>();
        List nodes = wf.getGraph().getNodes();
        for (Node node : nodes) {
            String name = node.getComponent().getName();
            if (!"Input".equals(name) && !"Const".equals(name) && !"S3Input".equals(name)) continue;
            list.add(node);
        }
        return list;
    }

    private ArrayList<Node> getReadyNodesDynamically() {
        ArrayList<Node> list = new ArrayList<Node>();
        ArrayList<Node> waiting = InterpreterUtil.getWaitingNodesDynamically(this.getGraph());
        ArrayList<Node> finishedNodes = InterpreterUtil.getFinishedNodesDynamically(this.getGraph());
        for (Node node : waiting) {
            List inputPorts;
            boolean controlDone;
            ControlPort control;
            Component component = node.getComponent();
            if (component instanceof WSComponent || component instanceof DynamicComponent || component instanceof SubWorkflowComponent || component instanceof ForEachComponent || component instanceof EndForEachComponent || component instanceof IfComponent || component instanceof InstanceComponent) {
                control = node.getControlInPort();
                controlDone = true;
                if (control != null) {
                    for (EdgeImpl edge : control.getEdges()) {
                        controlDone = controlDone && (finishedNodes.contains(edge.getFromPort().getNode()) || ((ControlPort)edge.getFromPort()).isConditionMet());
                    }
                }
                inputPorts = node.getInputPorts();
                boolean inputsDone = true;
                for (DataPort dataPort : inputPorts) {
                    inputsDone = inputsDone && finishedNodes.contains(dataPort.getFromNode());
                }
                if (!inputsDone || !controlDone) continue;
                list.add(node);
                continue;
            }
            if (component instanceof EndifComponent) {
                int expectedOutput = node.getOutputPorts().size();
                int actualInput = 0;
                inputPorts = node.getInputPorts();
                for (DataPort dataPort : inputPorts) {
                    if (!finishedNodes.contains(dataPort.getFromNode())) continue;
                    ++actualInput;
                }
                if (expectedOutput != actualInput) continue;
                list.add(node);
                continue;
            }
            if (component instanceof TerminateInstanceComponent) {
                control = node.getControlInPort();
                controlDone = true;
                if (control != null) {
                    for (EdgeImpl edge : control.getEdges()) {
                        controlDone = controlDone && finishedNodes.contains(edge.getFromPort().getFromNode());
                    }
                }
                inputPorts = node.getInputPorts();
                boolean inputsDone = true;
                for (DataPort dataPort : inputPorts) {
                    inputsDone = inputsDone && finishedNodes.contains(dataPort.getFromNode());
                }
                if (!inputsDone || !controlDone) continue;
                list.add(node);
                continue;
            }
            if ("Input".equals(component.getName()) || "DifferedInput".equals(component.getName()) || "S3Input".equals(component.getName()) || "Output".equals(component.getName()) || "Memo".equals(component.getName()) || component instanceof EndDoWhileComponent) continue;
            if (component instanceof DoWhileComponent) {
                control = node.getControlInPort();
                controlDone = true;
                if (control != null) {
                    for (EdgeImpl edge : control.getEdges()) {
                        controlDone = controlDone && finishedNodes.contains(edge.getFromPort().getFromNode());
                    }
                }
                if (!controlDone) continue;
                list.add(node);
                continue;
            }
            throw new WorkFlowInterpreterException("Component Not handled :" + component.getName());
        }
        this.notifyViaInteractor(WorkflowExecutionMessage.HANDLE_DEPENDENT_NODES_DIFFERED_INPUTS, this.getGraph());
        return list;
    }

    public Workflow getWorkflow() {
        return this.config.getWorkflow();
    }

    public void setProvenanceWriter(PredicatedTaskRunner provenanceWriter) {
        this.provenanceWriter = provenanceWriter;
    }

    public WorkflowInterpreterConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(WorkflowInterpreterConfiguration config) {
        this.config = config;
    }

    private WSGraph getGraph() {
        return this.getWorkflow().getGraph();
    }

    private ArrayList<Node> getFinishedNodesDynamically() {
        return this.getNodesWithState(Node.NodeExecutionState.FINISHED);
    }

    private ArrayList<Node> getWaitingNodesDynamically() {
        return this.getNodesWithState(Node.NodeExecutionState.WAITING);
    }

    private ArrayList<Node> getNodesWithState(Node.NodeExecutionState state) {
        ArrayList<Node> list = new ArrayList<Node>();
        List nodes = this.getGraph().getNodes();
        for (Node node : nodes) {
            if (state != node.getState()) continue;
            list.add(node);
        }
        return list;
    }

    public static void setWorkflowInterpreterConfigurationThreadLocal(WorkflowInterpreterConfiguration workflowInterpreterConfiguration) {
        workflowInterpreterConfigurationThreadLocal.set(workflowInterpreterConfiguration);
    }

    public static WorkflowInterpreterConfiguration getWorkflowInterpreterConfiguration() {
        return workflowInterpreterConfigurationThreadLocal.get();
    }
}

