/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.interpretor;

import java.net.URI;
import java.util.List;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.workflow.model.graph.util.GraphUtil;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaConstants;
import org.apache.airavata.xbaya.jython.lib.ServiceNotifiable;
import org.apache.airavata.xbaya.jython.lib.StandaloneServiceNotificationSender;
import org.apache.airavata.xbaya.jython.lib.WorkflowNotifiable;
import org.apache.axis2.addressing.EndpointReference;
import org.python.core.PyObject;

public class StandaloneNotificationSender
implements WorkflowNotifiable {
    private Workflow workflow;
    private URI workflowID;

    public StandaloneNotificationSender(String topic, Workflow workflow) {
        this.workflow = workflow;
        this.workflowID = URI.create(StringUtil.convertToJavaIdentifier((String)topic));
    }

    @Override
    public EndpointReference getEventSink() {
        return new EndpointReference(XBayaConstants.DEFAULT_BROKER_URL.toString());
    }

    @Override
    public void workflowStarted(PyObject[] args, String[] keywords) {
        List inputs = GraphUtil.getInputNodes((Graph)this.workflow.getGraph());
        for (InputNode inputNode : inputs) {
            inputNode.setState(Node.NodeExecutionState.FINISHED);
        }
    }

    @Override
    public void workflowStarted(Object[] args, String[] keywords) {
        List inputs = GraphUtil.getInputNodes((Graph)this.workflow.getGraph());
        for (InputNode inputNode : inputs) {
            inputNode.setState(Node.NodeExecutionState.FINISHED);
        }
    }

    @Override
    public void workflowFinished(Object[] args, String[] keywords) {
        List outputs = GraphUtil.getOutputNodes((Graph)this.workflow.getGraph());
        for (OutputNode outputNode : outputs) {
            outputNode.setState(Node.NodeExecutionState.EXECUTING);
        }
    }

    @Override
    public void sendingPartialResults(Object[] args, String[] keywords) {
    }

    @Override
    public void workflowFinished(PyObject[] args, String[] keywords) {
        List outputs = GraphUtil.getOutputNodes((Graph)this.workflow.getGraph());
        for (OutputNode outputNode : outputs) {
            outputNode.setState(Node.NodeExecutionState.EXECUTING);
        }
    }

    @Override
    public void workflowTerminated() {
    }

    @Override
    public void workflowFailed(String message) {
    }

    @Override
    public void workflowFailed(Throwable e) {
    }

    @Override
    public void workflowFailed(String message, Throwable e) {
    }

    @Override
    public ServiceNotifiable createServiceNotificationSender(String nodeID) {
        return new StandaloneServiceNotificationSender(this.workflow, this.workflowID);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getTopic() {
        return this.workflowID.toASCIIString();
    }
}

