/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.interpretor;

import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.workflow.model.wf.WorkflowExecutionState;
import org.apache.airavata.xbaya.interpretor.StandaloneNotificationSender;
import org.apache.airavata.xbaya.interpretor.WorkflowExecutionMessage;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreter;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreterConfiguration;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreterInteractor;

public class SSWorkflowInterpreterInteractorImpl
implements WorkflowInterpreterInteractor {
    @Override
    public boolean notify(WorkflowExecutionMessage messageType, WorkflowInterpreterConfiguration config, Object data) {
        switch (messageType) {
            case NODE_STATE_CHANGED: {
                break;
            }
            case EXECUTION_STATE_CHANGED: {
                WorkflowExecutionState state = (WorkflowExecutionState)data;
                if (state != WorkflowExecutionState.PAUSED && state != WorkflowExecutionState.STOPPED) break;
                config.getWorkflow().setExecutionState(WorkflowExecutionState.STOPPED);
                break;
            }
            case EXECUTION_TASK_START: {
                break;
            }
            case EXECUTION_TASK_END: {
                break;
            }
            case OPEN_SUBWORKFLOW: {
                break;
            }
            case HANDLE_DEPENDENT_NODES_DIFFERED_INPUTS: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object retrieveData(WorkflowExecutionMessage messageType, WorkflowInterpreterConfiguration config, Object data) throws Exception {
        WorkflowInterpreter result = null;
        switch (messageType) {
            case INPUT_WORKFLOWINTERPRETER_FOR_WORKFLOW: {
                Workflow subWorkflow = (Workflow)data;
                WorkflowInterpreterConfiguration workflowInterpreterConfiguration = new WorkflowInterpreterConfiguration(subWorkflow, config.getTopic(), config.getMessageBoxURL(), config.getMessageBrokerURL(), config.getRegistry(), config.getConfiguration(), config.getGUI(), config.getMonitor());
                if (config.isTestMode()) {
                    workflowInterpreterConfiguration.setNotifier(new StandaloneNotificationSender(workflowInterpreterConfiguration.getTopic(), workflowInterpreterConfiguration.getWorkflow()));
                }
                result = new WorkflowInterpreter(workflowInterpreterConfiguration, new SSWorkflowInterpreterInteractorImpl());
            }
        }
        return result;
    }
}

