/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.interpretor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.workflow.model.wf.WorkflowExecutionState;
import org.apache.airavata.ws.monitor.MonitorException;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.interpretor.StandaloneNotificationSender;
import org.apache.airavata.xbaya.interpretor.WorkflowExecutionMessage;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreter;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreterConfiguration;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreterInteractor;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.WaitDialog;
import org.apache.airavata.xbaya.ui.graph.subworkflow.SubWorkflowNodeGUI;
import org.apache.airavata.xbaya.ui.graph.system.DifferedInputHandler;
import org.apache.airavata.xbaya.ui.utils.Cancelable;
import org.apache.airavata.xbaya.util.InterpreterUtil;

public class GUIWorkflowInterpreterInteractorImpl
implements WorkflowInterpreterInteractor {
    private XBayaGUI xbayaGUI;
    private Workflow workflow;
    private XBayaEngine engine;
    private Map<String, WaitDialog> taskDialogs = new HashMap<String, WaitDialog>();

    public GUIWorkflowInterpreterInteractorImpl(XBayaEngine engine, Workflow workflow) {
        this.engine = engine;
        this.xbayaGUI = engine.getGUI();
        this.setWorkflow(workflow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notify(WorkflowExecutionMessage messageType, WorkflowInterpreterConfiguration config, Object data) {
        switch (messageType) {
            case NODE_STATE_CHANGED: {
                this.xbayaGUI.getGraphCanvas().repaint();
                break;
            }
            case EXECUTION_STATE_CHANGED: {
                WorkflowExecutionState state = (WorkflowExecutionState)data;
                this.getWorkflow().setExecutionState(state);
                if (state != WorkflowExecutionState.PAUSED || config.getWorkflow().getExecutionState() != WorkflowExecutionState.RUNNING && config.getWorkflow().getExecutionState() != WorkflowExecutionState.STEP) break;
                config.getGUI().getToolbar().getPlayAction().actionPerformed(null);
                break;
            }
            case EXECUTION_TASK_START: {
                WorkflowInterpreterInteractor.TaskNotification task = (WorkflowInterpreterInteractor.TaskNotification)data;
                final WaitDialog waitDialog = new WaitDialog(new Cancelable(){

                    @Override
                    public void cancel() {
                    }
                }, task.messageTitle, task.message, this.xbayaGUI);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        waitDialog.show();
                    }
                }).start();
                this.taskDialogs.put(task.messageId, waitDialog);
                break;
            }
            case EXECUTION_TASK_END: {
                WorkflowInterpreterInteractor.TaskNotification task = (WorkflowInterpreterInteractor.TaskNotification)data;
                if (!this.taskDialogs.containsKey(task.messageId)) break;
                this.taskDialogs.get(task.messageId).hide();
                this.taskDialogs.remove(task.messageId);
                break;
            }
            case EXECUTION_ERROR: {
                this.xbayaGUI.getErrorWindow().error((Exception)data);
                break;
            }
            case OPEN_SUBWORKFLOW: {
                ((SubWorkflowNodeGUI)NodeController.getGUI((Node)data)).openWorkflowTab(config.getGUI());
                break;
            }
            case EXECUTION_CLEANUP: {
                this.engine.resetWorkflowInterpreter();
                try {
                    config.getMonitor().stop();
                    break;
                }
                catch (MonitorException e) {
                    e.printStackTrace();
                    break;
                }
                finally {
                    this.engine.getMonitor().resetEventData();
                }
            }
            case HANDLE_DEPENDENT_NODES_DIFFERED_INPUTS: {
                ArrayList<Node> waitingNodes = InterpreterUtil.getWaitingNodesDynamically((WSGraph)data);
                for (Node readyNode : waitingNodes) {
                    DifferedInputHandler.handleDifferredInputsofDependentNodes(readyNode, config.getGUI());
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object retrieveData(WorkflowExecutionMessage messageType, WorkflowInterpreterConfiguration config, Object data) throws Exception {
        WorkflowInterpreter result = null;
        switch (messageType) {
            case INPUT_WORKFLOWINTERPRETER_FOR_WORKFLOW: {
                Workflow subWorkflow = (Workflow)data;
                WorkflowInterpreterConfiguration workflowInterpreterConfiguration = new WorkflowInterpreterConfiguration(subWorkflow, config.getTopic(), config.getMessageBoxURL(), config.getMessageBrokerURL(), config.getRegistry(), config.getConfiguration(), config.getGUI(), this.engine.getMonitor());
                workflowInterpreterConfiguration.setActOnProvenance(config.isActOnProvenance());
                workflowInterpreterConfiguration.setSubWorkflow(true);
                if (config.isTestMode()) {
                    workflowInterpreterConfiguration.setNotifier(new StandaloneNotificationSender(workflowInterpreterConfiguration.getTopic(), workflowInterpreterConfiguration.getWorkflow()));
                }
                result = new WorkflowInterpreter(workflowInterpreterConfiguration, new GUIWorkflowInterpreterInteractorImpl(this.engine, config.getWorkflow()));
                this.engine.registerWorkflowInterpreter(result);
            }
        }
        return result;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }
}

