/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.interpretor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.impl.EdgeImpl;
import org.apache.airavata.workflow.model.graph.system.DoWhileNode;
import org.apache.airavata.workflow.model.graph.system.EndDoWhileNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.interpretor.SystemComponentInvoker;
import org.apache.airavata.xbaya.interpretor.WorkFlowInterpreterException;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreter;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.util.InterpreterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoWhileHandler
implements Callable<Boolean> {
    private static Logger log = LoggerFactory.getLogger(DoWhileHandler.class);
    private DoWhileNode dowhilenode;
    private Map<Node, Invoker> invokerMap;
    private ArrayList<Node> waitingNode;
    private ArrayList<Node> finishedNodes;
    private WorkflowInterpreter interpreter;
    private ExecutorService threadExecutor;

    public DoWhileHandler(DoWhileNode node, Map<Node, Invoker> invokerMap, ArrayList<Node> waitingNode, ArrayList<Node> finishedNodes, WorkflowInterpreter interpreter, ExecutorService threadExecutor) {
        this.dowhilenode = node;
        this.invokerMap = invokerMap;
        this.waitingNode = waitingNode;
        this.finishedNodes = finishedNodes;
        this.interpreter = interpreter;
        this.threadExecutor = threadExecutor;
    }

    private boolean evaluate(DoWhileNode doWhileNode, List<DataPort> inputPorts, Map<Node, Invoker> invokerMap) throws WorkFlowInterpreterException, WorkflowException {
        String booleanExpression = doWhileNode.getXpath();
        if (booleanExpression == null) {
            throw new WorkFlowInterpreterException("XPath for if cannot be null");
        }
        int i = 0;
        for (DataPort port : inputPorts) {
            Object inputVal1 = InterpreterUtil.findInputFromPort(port, invokerMap);
            if (null == inputVal1) {
                throw new WorkFlowInterpreterException("Unable to find inputs for the node:" + doWhileNode.getID());
            }
            booleanExpression = booleanExpression.replaceAll("\\$" + i, "'" + inputVal1 + "'");
            ++i;
        }
        Boolean result = new Boolean(false);
        try {
            XPathFactory xpathFact = XPathFactory.newInstance();
            XPath xpath = xpathFact.newXPath();
            result = (Boolean)xpath.evaluate(booleanExpression, booleanExpression, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            throw new WorkFlowInterpreterException("Cannot evaluate XPath in If Condition: " + booleanExpression);
        }
        return result;
    }

    private ArrayList<Node> handleDowhile(ArrayList<Node> waitingNode, ArrayList<Node> finishedNodes) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node node : waitingNode) {
            Component component = node.getComponent();
            if (!(component instanceof WSComponent)) continue;
            ControlPort control = node.getControlInPort();
            boolean controlDone = true;
            if (control != null) {
                for (EdgeImpl edge : control.getEdges()) {
                    controlDone = controlDone && (finishedNodes.contains(edge.getFromPort().getNode()) || ((ControlPort)edge.getFromPort()).isConditionMet());
                }
            }
            List inputPorts = node.getInputPorts();
            boolean inputsDone = true;
            for (DataPort dataPort : inputPorts) {
                inputsDone = inputsDone && finishedNodes.contains(dataPort.getFromNode());
            }
            if (!inputsDone || !controlDone) continue;
            list.add(node);
        }
        return list;
    }

    @Override
    public Boolean call() throws Exception {
        log.debug("Invoked Dowhile node");
        SystemComponentInvoker dowhileinvoker = new SystemComponentInvoker();
        Object inputVal1 = InterpreterUtil.findInputFromPort(this.dowhilenode.getInputPort(0), this.invokerMap);
        dowhileinvoker.addOutput(this.dowhilenode.getOutputPort(0).getID(), inputVal1);
        this.invokerMap.put((Node)this.dowhilenode, dowhileinvoker);
        this.finishedNodes.add((Node)this.dowhilenode);
        ArrayList<Node> readyNodes = this.handleDowhile(this.waitingNode, this.finishedNodes);
        if (readyNodes.size() != 1) {
            throw new WorkflowRuntimeException("More than one dowhile execution not supported");
        }
        Node donode = readyNodes.get(0);
        this.interpreter.handleWSComponent(donode);
        log.debug("Invoked service " + donode.getName());
        List inputPorts = this.dowhilenode.getInputPorts();
        boolean runflag = true;
        while (runflag) {
            while (NodeController.isRunning(donode) || NodeController.isWaiting(donode)) {
                Thread.sleep(500L);
                log.debug("Service " + donode.getName() + " waiting");
            }
            if (NodeController.isFinished(donode)) {
                log.debug("Service " + donode.getName() + " Finished");
                List ports = this.dowhilenode.getOutputPorts();
                int inputPortIndex = 1;
                for (int outputPortIndex = 0; outputPortIndex < ports.size(); ++outputPortIndex) {
                    Object inputValue = InterpreterUtil.findInputFromPort(this.dowhilenode.getInputPort(inputPortIndex), this.invokerMap);
                    dowhileinvoker.addOutput(this.dowhilenode.getOutputPort(outputPortIndex).getID(), inputValue);
                }
            } else {
                if (NodeController.isFailed(donode)) {
                    log.debug("Service " + donode.getName() + " Failed");
                    runflag = false;
                    this.dowhilenode.setState(Node.NodeExecutionState.FAILED);
                    this.threadExecutor.shutdown();
                    return false;
                }
                if (donode.isBreak()) {
                    log.debug("Service " + donode.getName() + " set to break");
                    runflag = false;
                } else {
                    log.error("Service " + donode.getName() + " have unknow status");
                    throw new WorkFlowInterpreterException("Unknow status of the node");
                }
            }
            this.invokerMap.put((Node)this.dowhilenode, dowhileinvoker);
            log.debug("Going to evaluate do while expression for " + donode.getName());
            if (!this.evaluate(this.dowhilenode, inputPorts, this.invokerMap)) {
                log.debug("Expression evaluation is false so calling EndDoWhile");
                runflag = false;
                continue;
            }
            if (readyNodes.size() != 1) {
                throw new WorkFlowInterpreterException("More than one dowhile execution not supported");
            }
            Node whileNode = readyNodes.get(0);
            log.debug("Expression evaluation is true so invoking service again " + whileNode.getName());
            this.interpreter.handleWSComponent(whileNode);
        }
        this.dowhilenode.setState(Node.NodeExecutionState.FINISHED);
        EndDoWhileNode endDoWhileNode = this.dowhilenode.getEndDoWhileNode();
        SystemComponentInvoker invoker = new SystemComponentInvoker();
        List inputports = endDoWhileNode.getInputPorts();
        for (int inputPortIndex = 0; inputPortIndex < inputports.size(); ++inputPortIndex) {
            Object inputVal = dowhileinvoker.getOutput(((DataPort)inputports.get(inputPortIndex)).getFromPort().getID());
            invoker.addOutput(endDoWhileNode.getOutputPort(inputPortIndex).getID(), inputVal);
        }
        this.invokerMap.put((Node)endDoWhileNode, invoker);
        endDoWhileNode.setState(Node.NodeExecutionState.FINISHED);
        this.threadExecutor.shutdown();
        return true;
    }
}

