/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.globus;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.globusonline.transfer.APIError;
import org.globusonline.transfer.BaseTransferAPIClient;
import org.globusonline.transfer.JSONTransferAPIClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GridFTPFileTransferClient {
    private JSONTransferAPIClient client;
    private static DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public GridFTPFileTransferClient(JSONTransferAPIClient client) {
        this.client = client;
    }

    public static void main(String[] args) {
        String username = "heshan";
        String caFile = "/home/heshan/Dev/globusonline/transfer-api-client-java.git/trunk/ca/gd-bundle_ca.cert";
        String certFile = "/tmp/x509up_u780936";
        String keyFile = "/tmp/x509up_u780936";
        String baseUrl = null;
        String sourceEndpoint = "xsede#ranger";
        String sourceFilePath = "~/tmp.log";
        String destEndpoint = "xsede#trestles";
        String destFilePath = "~/tmp.log.copy";
        try {
            JSONTransferAPIClient c = new JSONTransferAPIClient(username, caFile, certFile, keyFile, baseUrl);
            System.out.println("base url: " + c.getBaseUrl());
            GridFTPFileTransferClient e = new GridFTPFileTransferClient(c);
            e.transfer(sourceEndpoint, sourceFilePath, destEndpoint, destFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void transfer(String sourceEndpoint, String sourceFilePath, String destEndpoint, String destFilePath) throws IOException, JSONException, GeneralSecurityException, APIError {
        System.out.println("Starting transfer...");
        if (!this.autoActivate(sourceEndpoint) || !this.autoActivate(destEndpoint)) {
            System.err.println("Unable to auto activate go tutorial endpoints,  exiting");
            return;
        }
        JSONTransferAPIClient.Result r = this.client.getResult("/transfer/submission_id");
        String submissionId = r.document.getString("value");
        JSONObject transfer = new JSONObject();
        transfer.put("DATA_TYPE", (Object)"transfer");
        transfer.put("submission_id", (Object)submissionId);
        JSONObject item = new JSONObject();
        item.put("DATA_TYPE", (Object)"transfer_item");
        item.put("source_endpoint", (Object)sourceEndpoint);
        item.put("source_path", (Object)sourceFilePath);
        item.put("destination_endpoint", (Object)destEndpoint);
        item.put("destination_path", (Object)destFilePath);
        transfer.append("DATA", (Object)item);
        r = this.client.postResult("/transfer", transfer.toString(), null);
        String taskId = r.document.getString("task_id");
        if (!this.waitForTask(taskId, 120)) {
            System.out.println("Transfer not complete after 2 minutes, exiting");
            return;
        }
        System.out.println("Transfer completed...");
    }

    public void displayTasksummary() throws IOException, JSONException, GeneralSecurityException, APIError {
        JSONTransferAPIClient.Result r = this.client.getResult("/tasksummary");
        System.out.println("Task Summary for " + this.client.getUsername() + ": ");
        Iterator keysIter = r.document.sortedKeys();
        while (keysIter.hasNext()) {
            String key = (String)keysIter.next();
            if (key.equals("DATA_TYPE")) continue;
            System.out.println("  " + key + ": " + r.document.getString(key));
        }
    }

    public void displayTaskList(long maxAge) throws IOException, JSONException, GeneralSecurityException, APIError {
        HashMap<String, String> params = new HashMap<String, String>();
        if (maxAge > 0L) {
            long minTime = System.currentTimeMillis() - 1000L * maxAge;
            params.put("filter", "request_time:" + isoDateFormat.format(new Date(minTime)) + ",");
        }
        JSONTransferAPIClient.Result r = this.client.getResult("/task_list", params);
        int length = r.document.getInt("length");
        if (length == 0) {
            System.out.println("No tasks were submitted in the last " + maxAge + " seconds");
            return;
        }
        JSONArray tasksArray = r.document.getJSONArray("DATA");
        for (int i = 0; i < tasksArray.length(); ++i) {
            JSONObject taskObject = tasksArray.getJSONObject(i);
            System.out.println("Task " + taskObject.getString("task_id") + ":");
            GridFTPFileTransferClient.displayTask(taskObject);
        }
    }

    private static void displayTask(JSONObject taskObject) throws JSONException {
        Iterator keysIter = taskObject.sortedKeys();
        while (keysIter.hasNext()) {
            String key = (String)keysIter.next();
            if (key.equals("DATA_TYPE") || key.equals("LINKS") || key.endsWith("_link")) continue;
            System.out.println("  " + key + ": " + taskObject.getString(key));
        }
    }

    public boolean autoActivate(String endpointName) throws IOException, JSONException, GeneralSecurityException, APIError {
        String resource = BaseTransferAPIClient.endpointPath((String)endpointName) + "/autoactivate";
        JSONTransferAPIClient.Result r = this.client.postResult(resource, null, null);
        String code = r.document.getString("code");
        return !code.startsWith("AutoActivationFailed");
    }

    public void displayLs(String endpointName, String path) throws IOException, JSONException, GeneralSecurityException, APIError {
        HashMap<String, String> params = new HashMap<String, String>();
        if (path != null) {
            params.put("path", path);
        }
        String resource = BaseTransferAPIClient.endpointPath((String)endpointName) + "/ls";
        JSONTransferAPIClient.Result r = this.client.getResult(resource, params);
        System.out.println("Contents of " + path + " on " + endpointName + ":");
        JSONArray fileArray = r.document.getJSONArray("DATA");
        for (int i = 0; i < fileArray.length(); ++i) {
            JSONObject fileObject = fileArray.getJSONObject(i);
            System.out.println("  " + fileObject.getString("name"));
            Iterator keysIter = fileObject.sortedKeys();
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                if (key.equals("DATA_TYPE") || key.equals("LINKS") || key.endsWith("_link") || key.equals("name")) continue;
                System.out.println("    " + key + ": " + fileObject.getString(key));
            }
        }
    }

    public boolean waitForTask(String taskId, int timeout) throws IOException, JSONException, GeneralSecurityException, APIError {
        String status = "ACTIVE";
        String resource = "/task/" + taskId;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fields", "status");
        while (timeout > 0 && status.equals("ACTIVE")) {
            JSONTransferAPIClient.Result r = this.client.getResult(resource, params);
            status = r.document.getString("status");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                return false;
            }
            timeout -= 10;
        }
        return !status.equals("ACTIVE");
    }
}

