/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.gfac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlInfosetBuilder;
import xsul.XmlConstants;
import xsul.wsif.WSIFMessage;
import xsul.wsif.WSIFOperation;
import xsul.wsif.WSIFPort;
import xsul.wsif.impl.WSIFMessageElement;
import xsul.xwsif_runtime.WSIFClient;
import xsul.xwsif_runtime.WSIFRuntime;

public class SimpleWSClient {
    private static final Logger logger = LoggerFactory.getLogger(SimpleWSClient.class);
    private static final XmlInfosetBuilder builder = XmlConstants.BUILDER;
    private String requestNS = "http://www.extreme.indiana.edu/namespaces/2004/01/gFac";

    public WSIFMessage sendSOAPMessage(String url, Object[][] args, String opName) throws ComponentRegistryException {
        WSIFClient wclient = WSIFRuntime.newClient((String)url);
        return this.sendSOAPMessage(wclient, args, opName);
    }

    public WSIFMessage sendSOAPMessage(WSIFClient wclient, Object[][] args, String opName) throws ComponentRegistryException {
        WSIFPort port = wclient.getPort();
        WSIFOperation operation = port.createOperation(opName);
        WSIFMessage outputMessage = operation.createOutputMessage();
        WSIFMessage faultMessage = operation.createFaultMessage();
        String messageName = operation.createInputMessage().getName();
        XmlElement inputMsgElem = builder.newFragment(this.requestNS, messageName);
        for (int i = 0; i < args.length; ++i) {
            this.createMessage((String)args[i][0], args[i][1], inputMsgElem);
        }
        WSIFMessageElement inputMessage = new WSIFMessageElement(inputMsgElem);
        boolean success = operation.executeRequestResponseOperation((WSIFMessage)inputMessage, outputMessage, faultMessage);
        if (success) {
            logger.debug("" + outputMessage);
            return outputMessage;
        }
        throw new ComponentRegistryException("Excpetion at server " + faultMessage);
    }

    private void createMessage(String paramName, Object value, XmlElement inputMsgElem) throws ComponentRegistryException {
        XmlElement paramsElem = builder.newFragment(this.requestNS, paramName);
        if (value instanceof String) {
            paramsElem.addChild(value);
        } else if (value instanceof Collection) {
            Collection list = (Collection)value;
            Iterator arrayValues = list.iterator();
            while (arrayValues.hasNext()) {
                XmlElement item = builder.newFragment("value");
                item.addChild(arrayValues.next());
                paramsElem.addChild((Object)item);
            }
        } else if (value instanceof ArrayList) {
            Collection list = (Collection)value;
            Iterator arrayValues = list.iterator();
            while (arrayValues.hasNext()) {
                XmlElement item = builder.newFragment("value");
                item.addChild(arrayValues.next());
                paramsElem.addChild((Object)item);
            }
        } else if (value instanceof String[]) {
            String[] list = (String[])value;
            for (int i = 0; i < list.length; ++i) {
                XmlElement item = builder.newFragment("value");
                item.addChild((Object)list[i]);
                paramsElem.addChild((Object)item);
            }
        } else {
            throw new ComponentRegistryException("Simple WS Client can not handle the value of type " + value);
        }
        inputMsgElem.addElement(paramsElem);
    }
}

