/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.gfac;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.xbaya.gfac.SimpleWSClient;
import org.xmlpull.v1.builder.Iterable;
import org.xmlpull.v1.builder.XmlElement;
import xsul.wsif.WSIFMessage;
import xsul.wsif.impl.WSIFMessageElement;

public class GFacRegistryClient {
    public static final String GFAC_NAMESPACE = "http://www.extreme.indiana.edu/namespaces/2004/01/gFac";
    private static final String SEARCH_SERVICE_INSTANCE = "searchServiceInstance";
    private static final String SEARCH_SERVIE = "searchService";
    private static final String QNAME = "qname";
    private static final String DESC_AS_STRING = "descAsStr";
    private static final String LIFE_TIME = "lifetimeAsSeconds";
    private static final String RESULTS = "results";
    private static final String GET_ABSTRACT_WSDL = "getAbstractWsdl";
    private String wsdlURL;
    private SimpleWSClient client;

    public GFacRegistryClient(URI wsdlURL) {
        this(wsdlURL.toString());
    }

    public GFacRegistryClient(String wsdlURL) {
        this.wsdlURL = wsdlURL;
        this.client = new SimpleWSClient();
    }

    public void registerAppDesc(String appDescAsStr) throws ComponentRegistryException {
        this.client.sendSOAPMessage(this.wsdlURL, (Object[][])new String[][]{{DESC_AS_STRING, appDescAsStr}}, "registerAppDesc");
    }

    public void registerConcreteWsdl(String wsdlAsStr, int lifetimeAsSeconds) throws ComponentRegistryException {
        this.client.sendSOAPMessage(this.wsdlURL, (Object[][])new String[][]{{DESC_AS_STRING, wsdlAsStr}, {LIFE_TIME, String.valueOf(lifetimeAsSeconds)}}, "registerConcreteWsdl");
    }

    public String getConcreteWsdl(String wsdlQName) throws ComponentRegistryException {
        WSIFMessage response = this.client.sendSOAPMessage(this.wsdlURL, (Object[][])new String[][]{{QNAME, wsdlQName}}, "getConcreateWsdl");
        return (String)response.getObjectPart(DESC_AS_STRING);
    }

    public void removeConcreteWsdl(String wsdlQName) throws ComponentRegistryException {
        this.client.sendSOAPMessage(this.wsdlURL, (Object[][])new String[][]{{QNAME, wsdlQName}}, "removeConcreteWsdl");
    }

    public String[] findService(String serviceName) throws ComponentRegistryException {
        WSIFMessage response = this.client.sendSOAPMessage(this.wsdlURL, (Object[][])new String[][]{{QNAME, serviceName}}, SEARCH_SERVICE_INSTANCE);
        return GFacRegistryClient.findArrayValue(RESULTS, (WSIFMessageElement)response).toArray(new String[0]);
    }

    public String[] findServiceDesc(String serviceName) throws ComponentRegistryException {
        WSIFMessage response = this.client.sendSOAPMessage(this.wsdlURL, (Object[][])new String[][]{{QNAME, serviceName}}, SEARCH_SERVIE);
        return GFacRegistryClient.findArrayValue(RESULTS, (WSIFMessageElement)response).toArray(new String[0]);
    }

    public String getAbstractWsdl(String wsdlQName) throws ComponentRegistryException {
        WSIFMessage response = this.client.sendSOAPMessage(this.wsdlURL, (Object[][])new String[][]{{QNAME, wsdlQName}}, GET_ABSTRACT_WSDL);
        return (String)response.getObjectPart(DESC_AS_STRING);
    }

    private static ArrayList<String> findArrayValue(String name, WSIFMessageElement response) {
        Iterable it;
        XmlElement param = response.element(null, name);
        if (param != null && (it = param.elements(null, "value")) != null) {
            ArrayList<String> values = new ArrayList<String>();
            Iterator arrayValues = it.iterator();
            while (arrayValues.hasNext()) {
                values.add(((XmlElement)arrayValues.next()).requiredTextContent());
            }
            return values;
        }
        return null;
    }
}

