/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.datadriven;

import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.Pair;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.system.InputComponent;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.workflow.model.wf.Workflow;

public class WorkflowHarvester {
    public Workflow[] harvest(Workflow workflow, QName dataType) {
        LinkedList<Workflow> harvest = new LinkedList<Workflow>();
        LinkedList<Pair<String, String>> candidates = this.getCandidates(workflow, dataType);
        for (Pair pair : candidates) {
            Workflow clone = workflow.clone();
            NodeImpl node = clone.getGraph().getNode((String)pair.getLeft());
            if (null == node) {
                throw new WorkflowRuntimeException("Specified node not found:" + (String)pair.getLeft());
            }
            DataPort candidatePort = null;
            List inPorts = node.getInputPorts();
            for (DataPort dataPort : inPorts) {
                if (!((String)pair.getRight()).equals(dataPort.getID())) continue;
                candidatePort = dataPort;
                break;
            }
            if (null == candidatePort) {
                throw new WorkflowRuntimeException("Specifies Port was not found:" + (String)pair.getRight());
            }
            if (candidatePort.getFromNode() instanceof InputNode) continue;
            this.removeUnnecessaryNodes((Node)node, (Port)candidatePort, clone);
            Node input = clone.addNode((Component)new InputComponent());
            input.setPosition(new Point(Math.max(0, node.getPosition().x - 150), node.getPosition().y));
            if (clone.getGraph().getNodes().size() >= workflow.getGraph().getNodes().size() || this.isWorkflowAlreadyHarvested(harvest, clone)) continue;
            try {
                clone.getGraph().addEdge(input.getOutputPort(0), (Port)candidatePort);
                this.cleanLeftOverInputNodes(clone);
            }
            catch (GraphException e) {
                throw new RuntimeException(e);
            }
            harvest.add(clone);
        }
        return harvest.toArray(new Workflow[0]);
    }

    private void cleanLeftOverInputNodes(Workflow clone) {
        List nodes = clone.getGraph().getNodes();
        LinkedList<Node> removeList = new LinkedList<Node>();
        for (Node nodeImpl : nodes) {
            if (!(nodeImpl instanceof InputNode) || nodeImpl.getOutputPort(0).getToNodes().size() != 0) continue;
            removeList.add(nodeImpl);
        }
        for (Node node : removeList) {
            try {
                clone.removeNode(node);
            }
            catch (GraphException e) {
                throw new WorkflowRuntimeException((Throwable)e);
            }
        }
    }

    private boolean isWorkflowAlreadyHarvested(LinkedList<Workflow> harvest, Workflow clone) {
        for (Workflow workflow : harvest) {
            if (!workflow.equals(clone)) continue;
            return true;
        }
        return false;
    }

    private void removeUnnecessaryNodes(Node node, Port candidatePort, Workflow workflow) {
        if (candidatePort.getFromPort().getEdges().size() == 1) {
            Node fromNode = candidatePort.getFromNode();
            try {
                List inputPorts = fromNode.getInputPorts();
                for (DataPort dataPort : inputPorts) {
                    this.removeUnnecessaryNodes(fromNode, (Port)dataPort, workflow);
                }
                workflow.removeNode(fromNode);
            }
            catch (GraphException e) {
                throw new WorkflowRuntimeException((Throwable)e);
            }
        }
    }

    private List<DataPort> getRemainderPorts(Pair<WSNode, DataPort> pair) {
        LinkedList<DataPort> ret = new LinkedList<DataPort>();
        List inputPorts = ((WSNode)pair.getLeft()).getInputPorts();
        for (DataPort dataPort : inputPorts) {
            if (pair.getRight() == dataPort) continue;
            ret.add(dataPort);
        }
        return ret;
    }

    private LinkedList<Pair<String, String>> getCandidates(Workflow workflow, QName dataType) {
        LinkedList<Pair<String, String>> candidates = new LinkedList<Pair<String, String>>();
        List nodes = workflow.getGraph().getNodes();
        for (NodeImpl node : nodes) {
            if (!(node instanceof WSNode)) continue;
            List inputPorts = ((WSNode)node).getInputPorts();
            for (DataPort dataPort : inputPorts) {
                if (!dataType.equals(dataPort.getType())) continue;
                candidates.add((Pair<String, String>)new Pair((Object)node.getID(), (Object)dataPort.getID()));
            }
        }
        return candidates;
    }
}

