/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.core.workflow;

import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.system.ParameterNode;

public class ParameterListModel
extends AbstractListModel {
    private List<? extends ParameterNode> parameterNodes;

    public ParameterListModel(List<? extends ParameterNode> parameterNodes) {
        this.parameterNodes = parameterNodes;
    }

    @Override
    public Object getElementAt(int index) {
        return this.parameterNodes.get(index).getName();
    }

    @Override
    public int getSize() {
        return this.parameterNodes.size();
    }

    public void up(int index) {
        if (index < 1 || index >= this.parameterNodes.size()) {
            throw new WorkflowRuntimeException("Illegal index: " + index);
        }
        this.swap(index - 1, index);
    }

    public void down(int index) {
        if (index < 0 || index >= this.parameterNodes.size() - 1) {
            throw new WorkflowRuntimeException("Illegal index: " + index);
        }
        this.swap(index, index + 1);
    }

    private void swap(int index0, int index1) {
        Collections.swap(this.parameterNodes, index0, index1);
        this.fireContentsChanged(this, index0, index1);
    }
}

