/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.core.generators;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.graph.ws.WSGraphFactory;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;

public class WorkflowFiler {
    private static Logger logger = LoggerFactory.getLogger(WorkflowFiler.class);
    private XBayaEngine engine;
    private JFileChooser graphFileChooser;
    private final FileFilter graphFileFilter = new FileFilter(){

        @Override
        public String getDescription() {
            return "Workflow Files";
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.endsWith(".xgr")) {
                return true;
            }
            return name.endsWith(".xwf");
        }
    };

    public WorkflowFiler(XBayaEngine engine) {
        this.engine = engine;
        this.graphFileChooser = new JFileChooser(XBayaPathConstants.WORKFLOW_DIRECTORY);
        this.graphFileChooser.addChoosableFileFilter(this.graphFileFilter);
    }

    public void openWorkflow() {
        Workflow workflow = null;
        int returnVal = this.graphFileChooser.showOpenDialog(this.engine.getGUI().getFrame());
        if (returnVal == 0) {
            File file = this.graphFileChooser.getSelectedFile();
            logger.debug(file.getPath());
            try {
                String path = file.getPath();
                if (path.endsWith(".xgr")) {
                    WSGraph graph = WSGraphFactory.createGraph((File)file);
                    workflow = Workflow.graphToWorkflow((WSGraph)graph);
                } else {
                    XmlElement workflowElement = XMLUtil.loadXML((File)file);
                    workflow = new Workflow(workflowElement);
                }
                GraphCanvas newGraphCanvas = this.engine.getGUI().newGraphCanvas(true);
                newGraphCanvas.setWorkflow(workflow);
                this.engine.getGUI().getGraphCanvas().setWorkflowFile(file);
            }
            catch (IOException e) {
                this.engine.getGUI().getErrorWindow().error("Failed to open the file.", e);
            }
            catch (GraphException e) {
                this.engine.getGUI().getErrorWindow().error("The workflow file is in wrong format.", e);
            }
            catch (ComponentException e) {
                this.engine.getGUI().getErrorWindow().error("The workflow file is in wrong format.", e);
            }
            catch (RuntimeException e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Error e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
        }
    }

    public void saveWorkflow() {
        this.saveWorkflow(this.engine.getGUI().getGraphCanvas());
    }

    public void saveAsWorkflow() {
        GraphCanvas graphCanvas = this.engine.getGUI().getGraphCanvas();
        File saveAsWorkflowFile = this.saveAsWorkflow(graphCanvas);
        if (saveAsWorkflowFile != null) {
            graphCanvas.setWorkflowFile(saveAsWorkflowFile);
        }
    }

    public void saveWorkflow(GraphCanvas graphCanvas) {
        if (graphCanvas.getWorkflowFile() == null) {
            File saveAsWorkflowFile = this.saveAsWorkflow(graphCanvas);
            graphCanvas.setWorkflowFile(saveAsWorkflowFile);
        } else {
            this.saveWorkflow(graphCanvas.getWorkflow(), graphCanvas.getWorkflowFile());
        }
        if (graphCanvas.getWorkflowFile() != null) {
            graphCanvas.workflowSaved();
        }
    }

    public void saveAllWorkflows() {
        List<GraphCanvas> graphCanvases = this.engine.getGUI().getGraphCanvases();
        for (GraphCanvas graphCanvas : graphCanvases) {
            this.saveWorkflow(graphCanvas);
        }
    }

    public File saveAsWorkflow(GraphCanvas graphCanvas) {
        int returnVal = this.graphFileChooser.showSaveDialog(this.engine.getGUI().getFrame());
        if (returnVal == 0) {
            File file = this.graphFileChooser.getSelectedFile();
            logger.debug(file.getPath());
            String path = file.getPath();
            if (!path.endsWith(".xwf")) {
                file = new File(path + ".xwf");
            }
            this.saveWorkflow(graphCanvas.getWorkflow(), file);
            return file;
        }
        return null;
    }

    private void saveWorkflow(Workflow workflow, File file) {
        try {
            XMLUtil.saveXML((XmlElement)workflow.toXML(), (File)file);
        }
        catch (IOException e) {
            this.engine.getGUI().getErrorWindow().error("Failed to write the file.", e);
        }
        catch (RuntimeException e) {
            this.engine.getGUI().getErrorWindow().error("Failed to save the workflow.", e);
        }
        catch (Error e) {
            this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
    }

    public void importWorkflow() {
        int returnVal = this.graphFileChooser.showOpenDialog(this.engine.getGUI().getFrame());
        if (returnVal == 0) {
            File file = this.graphFileChooser.getSelectedFile();
            try {
                Workflow importedWorkflow;
                String path = file.getPath();
                if (path.endsWith(".xgr")) {
                    WSGraph importedGraph = WSGraphFactory.createGraph((File)file);
                    importedWorkflow = Workflow.graphToWorkflow((WSGraph)importedGraph);
                } else {
                    XmlElement importedWorkflowElement = XMLUtil.loadXML((File)file);
                    importedWorkflow = new Workflow(importedWorkflowElement);
                }
                GraphCanvas newGraphCanvas = this.engine.getGUI().newGraphCanvas(true);
                newGraphCanvas.setWorkflow(importedWorkflow);
                this.engine.getGUI().setWorkflow(importedWorkflow);
                this.engine.getGUI().getGraphCanvas().setWorkflowFile(file);
            }
            catch (IOException e) {
                this.engine.getGUI().getErrorWindow().error("Failed to open the file.", e);
            }
            catch (GraphException e) {
                this.engine.getGUI().getErrorWindow().error("The workflow file is in wrong format.", e);
            }
            catch (ComponentException e) {
                this.engine.getGUI().getErrorWindow().error("The workflow file is in wrong format.", e);
            }
            catch (RuntimeException e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Error e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
        }
    }

    public Workflow getWorkflow() {
        Workflow workflow = null;
        int returnVal = this.graphFileChooser.showOpenDialog(this.engine.getGUI().getFrame());
        if (returnVal == 0) {
            File file = this.graphFileChooser.getSelectedFile();
            logger.debug(file.getPath());
            try {
                String path = file.getPath();
                if (path.endsWith(".xgr")) {
                    WSGraph graph = WSGraphFactory.createGraph((File)file);
                    workflow = Workflow.graphToWorkflow((WSGraph)graph);
                } else {
                    XmlElement workflowElement = XMLUtil.loadXML((File)file);
                    workflow = new Workflow(workflowElement);
                }
            }
            catch (IOException e) {
                this.engine.getGUI().getErrorWindow().error("Failed to open the file.", e);
            }
            catch (GraphException e) {
                this.engine.getGUI().getErrorWindow().error("The workflow file is in wrong format.", e);
            }
            catch (ComponentException e) {
                this.engine.getGUI().getErrorWindow().error("The workflow file is in wrong format.", e);
            }
            catch (RuntimeException e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Error e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
        }
        return workflow;
    }
}

