/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.core.generators;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.gpel.model.GpelProcess;
import org.xmlpull.infoset.XmlElement;
import xsul5.XmlConstants;
import xsul5.wsdl.WsdlDefinitions;

public class ODEScriptFiler {
    private XBayaEngine engine;
    private JFileChooser bpelFileChooser;
    private final FileFilter bpelFileFilter = new FileFilter(){

        @Override
        public String getDescription() {
            return "BPEL Files";
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".bpel");
        }
    };

    public ODEScriptFiler(XBayaEngine engine) {
        this.engine = engine;
        this.bpelFileChooser = new JFileChooser(XBayaPathConstants.BPEL_SCRIPT_DIRECTORY);
        this.bpelFileChooser.addChoosableFileFilter(this.bpelFileFilter);
    }

    public void save() {
        block11: {
            Workflow wf = this.engine.getGUI().getWorkflow();
            if (0 == wf.getGraph().getNodes().size()) {
                this.engine.getGUI().getErrorWindow().warning("Workflow is Empty");
                return;
            }
            try {
                int returnVal = this.bpelFileChooser.showSaveDialog(this.engine.getGUI().getFrame());
                if (returnVal != 0) break block11;
                File file = this.bpelFileChooser.getSelectedFile();
                String path = file.getPath();
                if (path.endsWith(".bpel")) {
                    path = path.substring(0, path.length() - ".bpel".length());
                }
                File bpelFile = new File(path + ".bpel");
                File wsdlFile = new File(path + ".wsdl");
                URI temp = null;
                try {
                    temp = new URI("temp");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                GpelProcess process = wf.getOdeProcess(WSDLUtil.appendWSDLQuary((URI)temp), this.engine.getConfiguration().getODEURL());
                String processString = process.xmlStringPretty();
                FileWriter writer = new FileWriter(bpelFile);
                writer.write(processString);
                writer.close();
                WsdlDefinitions workflowWSDL = wf.getOdeWorkflowWSDL(this.engine.getConfiguration().getDSCURL(), this.engine.getConfiguration().getODEURL());
                String workflowWsdlStr = XmlConstants.BUILDER.serializeToStringPretty((Object)workflowWSDL.xml());
                writer = new FileWriter(wsdlFile);
                writer.write(workflowWsdlStr);
                Map wsdlMap = wf.getOdeServiceWSDLs(this.engine.getConfiguration().getDSCURL(), this.engine.getConfiguration().getODEURL());
                Set keySet = wsdlMap.keySet();
                for (String string : keySet) {
                    writer = new FileWriter(new File(wsdlFile.getParent(), QName.valueOf(string).getLocalPart()));
                    writer.write(XmlConstants.BUILDER.serializeToStringPretty((Object)((WsdlDefinitions)wsdlMap.get(string)).xml()));
                    writer.close();
                }
                XmlElement deployDescriptor = wf.getODEDeploymentDescriptor(this.engine.getConfiguration().getDSCURL(), this.engine.getConfiguration().getODEURL());
                writer = new FileWriter(new File(wsdlFile.getParent(), "deploy.xml"));
                writer.write(XmlConstants.BUILDER.serializeToString((Object)deployDescriptor));
                writer.close();
            }
            catch (IOException e) {
                this.engine.getGUI().getErrorWindow().error("Failed to write the file.", e);
            }
            catch (GraphException e) {
                this.engine.getGUI().getErrorWindow().error("The workflow file is in wrong format.", e);
            }
            catch (RuntimeException e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Error e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (ComponentException e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
        }
    }
}

