/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.core.generators;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.airavata.common.utils.IOUtil;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.apache.airavata.xbaya.jython.script.JythonScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonFiler {
    private static Logger logger = LoggerFactory.getLogger(JythonFiler.class);
    private XBayaEngine engine;
    private JFileChooser jythonFileChooser;
    private final FileFilter jythonFileFilter = new FileFilter(){

        @Override
        public String getDescription() {
            return "Jython Scripts";
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".py");
        }
    };

    public JythonFiler(XBayaEngine engine) {
        this.engine = engine;
        this.jythonFileChooser = new JFileChooser(XBayaPathConstants.JYTHON_SCRIPT_DIRECTORY);
        this.jythonFileChooser.addChoosableFileFilter(this.jythonFileFilter);
    }

    public void exportJythonScript() {
        ArrayList<String> warnings;
        Workflow workflow = this.engine.getGUI().getWorkflow();
        JythonScript script = new JythonScript(workflow, this.engine.getConfiguration());
        if (!script.validate(warnings = new ArrayList<String>())) {
            StringBuilder buf = new StringBuilder();
            for (String warning : warnings) {
                buf.append("- ");
                buf.append(warning);
                buf.append("\n");
            }
            this.engine.getGUI().getErrorWindow().warning(buf.toString());
            return;
        }
        int returnVal = this.jythonFileChooser.showSaveDialog(this.engine.getGUI().getFrame());
        if (returnVal == 0) {
            File file = this.jythonFileChooser.getSelectedFile();
            logger.debug(file.getPath());
            String path = file.getPath();
            if (!path.endsWith(".py")) {
                file = new File(path + ".py");
            }
            try {
                script.create();
                IOUtil.writeToFile((String)script.getJythonString(), (File)file);
            }
            catch (IOException e) {
                this.engine.getGUI().getErrorWindow().error("Failed to write the file.", e);
            }
            catch (GraphException e) {
                this.engine.getGUI().getErrorWindow().error("The workflow file is in wrong format.", e);
            }
            catch (RuntimeException e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Error e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
        }
    }
}

