/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.core.generators;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.airavata.xbaya.XBayaEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageFiler {
    private static Logger logger = LoggerFactory.getLogger(ImageFiler.class);
    private XBayaEngine engine;
    private JFileChooser pngFileChooser;
    private final FileFilter pngFileFilter = new FileFilter(){

        @Override
        public String getDescription() {
            return "PNG Files";
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".png");
        }
    };

    public ImageFiler(XBayaEngine engine) {
        this.engine = engine;
        this.pngFileChooser = new JFileChooser();
        this.pngFileChooser.addChoosableFileFilter(this.pngFileFilter);
    }

    public void saveWorkflowImage() {
        int returnVal = this.pngFileChooser.showSaveDialog(this.engine.getGUI().getFrame());
        if (returnVal == 0) {
            File file = this.pngFileChooser.getSelectedFile();
            logger.debug(file.getPath());
            String path = file.getPath();
            if (!path.endsWith(".png")) {
                file = new File(path + ".png");
            }
            try {
                BufferedImage image = this.engine.getGUI().getWorkflow().getImage();
                ImageIO.write((RenderedImage)image, "PNG", file);
            }
            catch (IOException e) {
                this.engine.getGUI().getErrorWindow().error("Failed to write the file.", e);
            }
            catch (RuntimeException e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Error e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
        }
    }
}

