/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.core.generators;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.gpel.script.BPELScript;
import org.apache.airavata.workflow.model.gpel.script.BPELScriptType;
import org.apache.airavata.workflow.model.gpel.script.WorkflowWSDL;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.gpel.model.GpelProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;

public class BPELFiler {
    private static Logger logger = LoggerFactory.getLogger(BPELFiler.class);
    private XBayaEngine engine;
    private JFileChooser bpelFileChooser;
    private final FileFilter bpelFileFilter = new FileFilter(){

        @Override
        public String getDescription() {
            return "BPEL Files";
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".bpel");
        }
    };

    public BPELFiler(XBayaEngine engine) {
        this.engine = engine;
        this.bpelFileChooser = new JFileChooser(XBayaPathConstants.BPEL_SCRIPT_DIRECTORY);
        this.bpelFileChooser.addChoosableFileFilter(this.bpelFileFilter);
    }

    public void exportBPEL() {
        ArrayList warnings;
        Workflow workflow = this.engine.getGUI().getWorkflow();
        BPELScript bpel = new BPELScript(workflow);
        if (!bpel.validate(warnings = new ArrayList())) {
            StringBuilder buf = new StringBuilder();
            for (String warning : warnings) {
                buf.append("- ");
                buf.append(warning);
                buf.append("\n");
            }
            this.engine.getGUI().getErrorWindow().warning(buf.toString());
            return;
        }
        int returnVal = this.bpelFileChooser.showSaveDialog(this.engine.getGUI().getFrame());
        if (returnVal == 0) {
            File file = this.bpelFileChooser.getSelectedFile();
            logger.debug(file.getPath());
            String path = file.getPath();
            if (path.endsWith(".bpel")) {
                path = path.substring(0, path.length() - ".bpel".length());
            }
            File bpelFile = new File(path + ".bpel");
            File wsdlFile = new File(path + ".wsdl");
            try {
                bpel.create(BPELScriptType.BPEL2);
                GpelProcess gpelProcess = bpel.getGpelProcess();
                XMLUtil.saveXML((XmlElement)gpelProcess.xml(), (File)bpelFile);
                WorkflowWSDL workflowWSDL = bpel.getWorkflowWSDL();
                XMLUtil.saveXML((XmlElement)workflowWSDL.getWsdlDefinitions().xml(), (File)wsdlFile);
            }
            catch (IOException e) {
                this.engine.getGUI().getErrorWindow().error("Failed to write the file.", e);
            }
            catch (GraphException e) {
                this.engine.getGUI().getErrorWindow().error("The workflow is not compelete.", e);
            }
            catch (RuntimeException e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Error e) {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
        }
    }
}

